/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.customer.ITraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.TraderClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.common.DiscountCodeTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.common.TraderInteractionTab;
import io.github.lightman314.lightmanscurrency.client.gui.util.IWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenStorage;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class TraderScreen
extends EasyMenuScreen<TraderMenu>
implements ITraderScreen {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/trader.png");
    public static final int WIDTH = 206;
    public static final int HEIGHT = 236;
    private final ScreenPosition INFO_WIDGET_POSITION = ScreenPosition.of(175, 140);
    private final TraderClientTab DEFAULT_TAB = new TraderInteractionTab(this);
    private final TraderClientTab CODE_TAB = new DiscountCodeTab(this);
    IconButton buttonOpenStorage;
    IconButton buttonCollectCoins;
    IconButton buttonOpenTerminal;
    IconButton buttonSubmitCodes;
    TraderClientTab currentTab = this.DEFAULT_TAB;
    private final LazyWidgetPositioner rightEdgePositioner = LazyWidgetPositioner.create(this, LazyWidgetPositioner.createTopdown(), 206, 0, 20);

    @Override
    public void setTab(@Nonnull TraderClientTab tab) {
        this.currentTab.onClose();
        this.currentTab = tab;
        this.currentTab.onOpen();
    }

    @Override
    public void closeTab() {
        this.setTab(this.DEFAULT_TAB);
    }

    @Override
    @Nonnull
    public IWidgetPositioner getRightEdgePositioner() {
        return this.rightEdgePositioner;
    }

    protected boolean forceShowTerminalButton() {
        return false;
    }

    public TraderScreen(TraderMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(206, 236);
    }

    @Override
    public void initialize(ScreenArea screenArea) {
        TraderData trader;
        this.rightEdgePositioner.clear();
        this.addChild(this.rightEdgePositioner);
        this.buttonOpenStorage = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::OpenStorage)).icon(IconUtil.ICON_STORAGE).addon(EasyAddonHelper.visibleCheck(() -> ((TraderMenu)this.f_97732_).isSingleTrader() && ((TraderMenu)this.f_97732_).getSingleTrader().hasPermission(((TraderMenu)this.f_97732_).player, "openStorage")))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_OPEN_STORAGE))).build());
        this.buttonCollectCoins = this.addChild(IconAndButtonUtil.finishCollectCoinButton((IconButton.Builder)IconButton.builder().pressAction(this::CollectCoins), ((TraderMenu)this.f_97732_).player, ((TraderMenu)this.f_97732_)::getSingleTrader));
        this.buttonOpenTerminal = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::OpenTerminal)).icon(IconUtil.ICON_BACK).addon(EasyAddonHelper.visibleCheck(this::showTerminalButton))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_NETWORK_BACK))).build());
        this.buttonSubmitCodes = this.addChild(((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::OpenCodeSelection)).icon(IconData.of(ModItems.COUPON)).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_DISCOUNT_CODES))).build());
        this.rightEdgePositioner.addWidgets(this.buttonOpenTerminal, this.buttonOpenStorage, this.buttonCollectCoins, this.buttonSubmitCodes);
        if (((TraderMenu)this.f_97732_).isSingleTrader() && (trader = ((TraderMenu)this.f_97732_).getSingleTrader()) != null) {
            trader.onScreenInit(this, this::addChild);
        }
        this.currentTab.onOpen();
        this.m_181908_();
    }

    private boolean showTerminalButton() {
        return this.forceShowTerminalButton() || ((TraderMenu)this.f_97732_).isSingleTrader() && ((TraderMenu)this.f_97732_).getSingleTrader().showOnTerminal();
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
        gui.blit(GUI_TEXTURE, this.INFO_WIDGET_POSITION, this.f_97726_ + 38, 0, 10, 10);
        for (Slot slot : ((TraderMenu)this.f_97732_).getCoinSlots()) {
            gui.renderSlot((IEasyScreen)this, slot);
        }
        if (((TraderMenu)this.f_97732_).getInteractionSlot().m_6659_()) {
            gui.renderSlot((IEasyScreen)this, ((TraderMenu)this.f_97732_).getInteractionSlot());
        }
        try {
            this.currentTab.renderBG(gui);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering trader tab " + this.currentTab.getClass().getName(), t);
        }
        gui.drawString(this.f_169604_, 23, this.f_97727_ - 94, 0x404040);
        Component valueText = ((TraderMenu)this.f_97732_).getContext(null).getAvailableFunds().getRandomValueLine();
        gui.drawString(valueText, 175 - gui.font.m_92852_((FormattedText)valueText), this.f_97727_ - 94, 0x404040);
    }

    @Override
    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        try {
            this.currentTab.renderAfterWidgets(gui);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering trader tab tooltips " + this.currentTab.getClass().getName(), t);
        }
        if (this.INFO_WIDGET_POSITION.offset(this).isMouseInArea(gui.mousePos, 10, 10)) {
            gui.renderComponentTooltip(((TraderMenu)this.f_97732_).getContext(null).getAvailableFundsDescription());
        }
    }

    private void OpenStorage(EasyButton button) {
        if (((TraderMenu)this.f_97732_).isSingleTrader()) {
            new CPacketOpenStorage(((TraderMenu)this.f_97732_).getSingleTrader().getID()).send();
        }
    }

    private void CollectCoins(EasyButton button) {
        if (((TraderMenu)this.f_97732_).isSingleTrader()) {
            CPacketCollectCoins.sendToServer();
        }
    }

    private void OpenTerminal(EasyButton button) {
        if (this.showTerminalButton()) {
            new CPacketOpenNetworkTerminal().send();
        }
    }

    private void OpenCodeSelection() {
        TraderClientTab traderClientTab = this.currentTab;
        if (traderClientTab instanceof DiscountCodeTab) {
            DiscountCodeTab codeTab = (DiscountCodeTab)traderClientTab;
            this.closeTab();
        } else {
            this.setTab(this.CODE_TAB);
        }
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.currentTab.blockInventoryClosing();
    }
}

