/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.easy;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IKeyboardListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ILateRender;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IPreRender;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IWidgetWrapper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public abstract class EasyScreen
extends Screen
implements IEasyScreen {
    private final List<IPreRender> preRenders = new ArrayList<IPreRender>();
    private final List<ILateRender> lateRenders = new ArrayList<ILateRender>();
    private final List<IEasyTickable> guiTickers = new ArrayList<IEasyTickable>();
    private final List<ITooltipSource> tooltipSources = new ArrayList<ITooltipSource>();
    private final List<IScrollListener> scrollListeners = new ArrayList<IScrollListener>();
    private final List<IMouseListener> mouseListeners = new ArrayList<IMouseListener>();
    private final List<IKeyboardListener> keyboardListeners = new ArrayList<IKeyboardListener>();
    private ScreenArea screenArea = ScreenArea.of(0, 0, 100, 100);

    @Override
    @Nonnull
    public final Font getFont() {
        return this.f_96547_;
    }

    @Override
    @Nonnull
    public final Player getPlayer() {
        return this.f_96541_.f_91074_;
    }

    protected EasyScreen() {
        this((Component)EasyText.empty());
    }

    protected EasyScreen(Component title) {
        super(title);
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    @Nonnull
    public final ScreenArea getArea() {
        return this.screenArea;
    }

    @Override
    public final int getGuiLeft() {
        return this.screenArea.x;
    }

    @Override
    public final int getGuiTop() {
        return this.screenArea.y;
    }

    @Override
    @Nonnull
    public final ScreenPosition getCorner() {
        return this.screenArea.pos;
    }

    @Override
    public final int getXSize() {
        return this.screenArea.width;
    }

    @Override
    public final int getYSize() {
        return this.screenArea.height;
    }

    protected final void resize(int width, int height) {
        this.screenArea = this.screenArea.ofSize(width, height);
        this.recalculateCorner();
    }

    protected final void m_7856_() {
        this.preRenders.clear();
        this.lateRenders.clear();
        this.guiTickers.clear();
        this.tooltipSources.clear();
        this.scrollListeners.clear();
        this.mouseListeners.clear();
        this.keyboardListeners.clear();
        super.m_7856_();
        this.recalculateCorner();
        this.initialize(this.screenArea);
    }

    protected void recalculateCorner() {
        this.screenArea = this.screenArea.atPosition(ScreenPosition.of((this.f_96543_ - this.screenArea.width) / 2, (this.f_96544_ - this.screenArea.height) / 2));
    }

    protected abstract void initialize(ScreenArea var1);

    public final void m_280273_(@Nonnull GuiGraphics gui) {
        if (((Boolean)LCConfig.CLIENT.debugScreens.get()).booleanValue()) {
            gui.m_280509_(0, 0, this.f_96543_, this.f_96544_, -65794);
        } else {
            super.m_280273_(gui);
        }
    }

    public final void m_88315_(@Nonnull GuiGraphics mcgui, int mouseX, int mouseY, float partialTicks) {
        this.renderTick();
        EasyGuiGraphics gui = EasyGuiGraphics.create(mcgui, this.f_96547_, mouseX, mouseY, partialTicks).pushOffset(this.getCorner());
        for (Object r : ImmutableList.copyOf(this.preRenders)) {
            try {
                r.preRender(gui);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error occurred while early rendering " + r.getClass().getName(), t);
            }
        }
        this.m_280273_(mcgui);
        this.renderBG(gui);
        for (Renderable renderable : ImmutableList.copyOf((Collection)this.f_169369_)) {
            renderable.m_88315_(mcgui, mouseX, mouseY, partialTicks);
        }
        for (Object r : ImmutableList.copyOf(this.lateRenders)) {
            try {
                r.lateRender(gui);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error occurred while late rendering " + r.getClass().getName(), t);
            }
        }
        this.renderAfterWidgets(gui);
        EasyScreenHelper.RenderTooltips(gui, (List<ITooltipSource>)ImmutableList.copyOf(this.tooltipSources));
        this.renderAfterTooltips(gui);
    }

    protected void renderTick() {
    }

    protected abstract void renderBG(@Nonnull EasyGuiGraphics var1);

    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
    }

    protected void renderAfterTooltips(@Nonnull EasyGuiGraphics gui) {
    }

    public final <T> T addChild(T child) {
        Object w;
        Object r;
        Object l;
        ITooltipSource t;
        IEasyTickable ticker;
        if (child instanceof EasyWidget.EasyBuilder) {
            LightmansCurrency.LogError("Builder accidentally passed along as a widget!", new Throwable());
        }
        if (child instanceof EasyWidgetWithChildren) {
            EasyWidgetWithChildren w2 = (EasyWidgetWithChildren)((Object)child);
            w2.pairWithScreen(this::addChild, this::removeChild);
            if (w2.addChildrenBeforeThis()) {
                w2.addChildren();
            }
        }
        if (child instanceof Renderable) {
            Renderable r2 = (Renderable)child;
            if (!this.f_169369_.contains(child)) {
                this.f_169369_.add(r2);
            }
        }
        if (child instanceof GuiEventListener && child instanceof NarratableEntry) {
            super.m_7787_((GuiEventListener)((NarratableEntry)child));
        }
        if ((ticker = EasyScreenHelper.getWidgetTicker(child)) != null && !this.guiTickers.contains(ticker)) {
            this.guiTickers.add(ticker);
        }
        if (child instanceof ITooltipSource && !this.tooltipSources.contains(t = (ITooltipSource)child)) {
            this.tooltipSources.add(t);
        }
        if (child instanceof IMouseListener && !this.mouseListeners.contains(l = (IMouseListener)child)) {
            this.mouseListeners.add((IMouseListener)l);
        }
        if (child instanceof IScrollListener && !this.scrollListeners.contains(l = (IScrollListener)child)) {
            this.scrollListeners.add((IScrollListener)l);
        }
        if (child instanceof IPreRender && !this.preRenders.contains(r = (IPreRender)child)) {
            this.preRenders.add((IPreRender)r);
        }
        if (child instanceof ILateRender && !this.lateRenders.contains(r = (ILateRender)child)) {
            this.lateRenders.add((ILateRender)r);
        }
        if (child instanceof EasyWidget) {
            w = (EasyWidget)((Object)child);
            ((EasyWidget)((Object)w)).addAddons(this::addChild);
        }
        if (child instanceof IKeyboardListener) {
            l = (IKeyboardListener)child;
            this.keyboardListeners.add((IKeyboardListener)l);
        }
        if (child instanceof EasyWidgetWithChildren && !((EasyWidgetWithChildren)((Object)(w = (EasyWidgetWithChildren)((Object)child)))).addChildrenBeforeThis()) {
            ((EasyWidgetWithChildren)((Object)w)).addChildren();
        }
        if (child instanceof IWidgetWrapper) {
            w = (IWidgetWrapper)child;
            this.addChild((T)w.getWrappedWidget());
        }
        return child;
    }

    @Override
    public final void removeChild(Object child) {
        Object r;
        Object w;
        Object l;
        if (child instanceof Renderable) {
            Renderable r2 = (Renderable)child;
            this.f_169369_.remove(r2);
        }
        if (child instanceof GuiEventListener) {
            GuiEventListener l2 = (GuiEventListener)child;
            super.m_169411_(l2);
        }
        IEasyTickable ticker = EasyScreenHelper.getWidgetTicker(child);
        this.guiTickers.remove(ticker);
        if (child instanceof ITooltipSource) {
            ITooltipSource t = (ITooltipSource)child;
            this.tooltipSources.remove(t);
        }
        if (child instanceof IMouseListener) {
            l = (IMouseListener)child;
            this.mouseListeners.remove(l);
        }
        if (child instanceof IScrollListener) {
            l = (IScrollListener)child;
            this.scrollListeners.remove(l);
        }
        if (child instanceof EasyWidget) {
            w = (EasyWidget)((Object)child);
            ((EasyWidget)((Object)w)).removeAddons(this::removeChild);
        }
        if (child instanceof IPreRender) {
            r = (IPreRender)child;
            this.preRenders.remove(r);
        }
        if (child instanceof ILateRender) {
            r = (ILateRender)child;
            this.lateRenders.remove(r);
        }
        if (child instanceof IKeyboardListener) {
            l = (IKeyboardListener)child;
            this.keyboardListeners.remove(l);
        }
        if (child instanceof EasyWidgetWithChildren) {
            w = (EasyWidgetWithChildren)((Object)child);
            ((EasyWidgetWithChildren)((Object)w)).removeChildren();
        }
        if (child instanceof IWidgetWrapper) {
            w = (IWidgetWrapper)child;
            this.removeChild(w.getWrappedWidget());
        }
    }

    public final void m_86600_() {
        super.m_86600_();
        for (IEasyTickable t : ImmutableList.copyOf(this.guiTickers)) {
            t.tick();
        }
        this.screenTick();
    }

    protected void screenTick() {
    }

    @Nonnull
    @Deprecated
    protected final <T extends GuiEventListener & NarratableEntry> T m_7787_(@Nonnull T widget) {
        return (T)((GuiEventListener)this.addChild(widget));
    }

    @Nonnull
    @Deprecated
    protected final <T extends GuiEventListener & Renderable> T m_142416_(@Nonnull T widget) {
        return (T)((GuiEventListener)this.addChild(widget));
    }

    @Nonnull
    @Deprecated
    protected final <T extends Renderable> T m_169394_(@Nonnull T widget) {
        return this.addChild(widget);
    }

    @Deprecated
    protected final void m_169411_(@Nonnull GuiEventListener widget) {
        this.removeChild(widget);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        for (IScrollListener l : ImmutableList.copyOf(this.scrollListeners)) {
            if (!l.m_6050_(mouseX, mouseY, scroll)) continue;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (IMouseListener l : ImmutableList.copyOf(this.mouseListeners)) {
            if (!l.onMouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (IMouseListener l : ImmutableList.copyOf(this.mouseListeners)) {
            if (!l.onMouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (IKeyboardListener listener : new ArrayList<IKeyboardListener>(this.keyboardListeners)) {
            if (!listener.onKeyPress(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.blockInventoryClosing()) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

