/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.terminal;

import com.google.common.base.Predicates;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.PendingSearch;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.PredicateWithResult;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FilterUtils {
    private FilterUtils() {
    }

    public static void boolCheck(PendingSearch search, String filter, boolean value) {
        search.processStrictFilter(filter, bool -> "true".contains(bool.toLowerCase()) == value);
    }

    public static void intRange(PendingSearch search, String filter, int value) {
        search.processUnfiltered(FilterUtils.intRange(filter, value));
    }

    public static Predicate<String> intRange(String filter, int value) {
        return input -> {
            try {
                if (!input.startsWith(filter)) {
                    return false;
                }
                if ((input = input.substring(filter.length())).startsWith(">=")) {
                    return value >= Integer.parseInt(input.substring(2));
                }
                if (input.startsWith(">")) {
                    return value > Integer.parseInt(input.substring(1));
                }
                if (input.startsWith("<=")) {
                    return value <= Integer.parseInt(input.substring(2));
                }
                if (input.startsWith("<")) {
                    return value < Integer.parseInt(input.substring(1));
                }
                if (input.startsWith("=")) {
                    if (input.startsWith("==")) {
                        return value == Integer.parseInt(input.substring(2));
                    }
                    return value == Integer.parseInt(input.substring(1));
                }
                if ((input.startsWith("[") || input.startsWith("(")) && (input.endsWith("]") || input.endsWith(")"))) {
                    boolean startInclusive = input.startsWith("[");
                    boolean endInclusive = input.endsWith("]");
                    input = input.substring(1, input.length() - 1);
                    String[] split = input.split(",", 2);
                    int start = Integer.parseInt(split[0]);
                    int end = Integer.parseInt(split[1]);
                    if (end < start) {
                        return false;
                    }
                    return startInclusive && value == start || endInclusive && value == end || value < end && value > start;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    public static Predicate<Integer> intRange(PendingSearch search, String filter) {
        AtomicReference<Object> holder = new AtomicReference<Object>(null);
        search.setupUnfiltered(input -> {
            try {
                if (!input.startsWith(filter) || holder.get() != null) {
                    return null;
                }
                if ((input = input.substring(filter.length())).startsWith(">=")) {
                    int minValue = Integer.parseInt(input.substring(2));
                    return PredicateWithResult.create(v -> v >= minValue, holder);
                }
                if (input.startsWith(">")) {
                    int minValue = Integer.parseInt(input.substring(1));
                    return PredicateWithResult.create(v -> v > minValue, holder);
                }
                if (input.startsWith("<=")) {
                    int maxValue = Integer.parseInt(input.substring(2));
                    return PredicateWithResult.create(v -> v <= maxValue, holder);
                }
                if (input.startsWith("<")) {
                    int maxValue = Integer.parseInt(input.substring(1));
                    return PredicateWithResult.create(v -> v <= maxValue, holder);
                }
                if (input.startsWith("=")) {
                    int value = input.startsWith("==") ? Integer.parseInt(input.substring(2)) : Integer.parseInt(input.substring(1));
                    return PredicateWithResult.create(v -> v == value, holder);
                }
                if ((input.startsWith("[") || input.startsWith("(")) && (input.endsWith("]") || input.endsWith(")"))) {
                    boolean startInclusive = input.startsWith("[");
                    boolean endInclusive = input.endsWith("]");
                    input = input.substring(1, input.length() - 1);
                    String[] split = input.split(",", 2);
                    int start = Integer.parseInt(split[0]);
                    int end = Integer.parseInt(split[1]);
                    if (end < start) {
                        return null;
                    }
                    return PredicateWithResult.create(v -> startInclusive && v == start || endInclusive && v == end || v < end && v > start, holder);
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
        return Objects.requireNonNullElseGet(holder.get(), Predicates::alwaysTrue);
    }

    public static void longRange(PendingSearch search, String filter, long value) {
        search.processUnfiltered(FilterUtils.longRange(filter, value));
    }

    public static Predicate<String> longRange(String filter, long value) {
        return input -> {
            try {
                if (!input.startsWith(filter)) {
                    return false;
                }
                if ((input = input.substring(filter.length())).startsWith(">=")) {
                    return value >= Long.parseLong(input.substring(2));
                }
                if (input.startsWith(">")) {
                    return value > Long.parseLong(input.substring(1));
                }
                if (input.startsWith("<=")) {
                    return value <= Long.parseLong(input.substring(2));
                }
                if (input.startsWith("<")) {
                    return value < Long.parseLong(input.substring(1));
                }
                if (input.startsWith("=")) {
                    if (input.startsWith("==")) {
                        return value == Long.parseLong(input.substring(2));
                    }
                    return value == Long.parseLong(input.substring(1));
                }
                if ((input.startsWith("[") || input.startsWith("(")) && (input.endsWith("]") || input.endsWith(")"))) {
                    boolean startInclusive = input.startsWith("[");
                    boolean endInclusive = input.endsWith("]");
                    input = input.substring(1, input.length() - 1);
                    String[] split = input.split(",", 2);
                    long start = Long.parseLong(split[0]);
                    long end = Long.parseLong(split[1]);
                    if (end < start) {
                        return false;
                    }
                    return startInclusive && value == start || endInclusive && value == end || value < end && value > start;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    public static Predicate<Long> longRange(PendingSearch search, String filter) {
        AtomicReference holder = new AtomicReference();
        search.setupUnfiltered(input -> {
            try {
                if (!input.startsWith(filter)) {
                    return null;
                }
                if ((input = input.substring(filter.length())).startsWith(">=")) {
                    long minValue = Long.parseLong(input.substring(2));
                    return PredicateWithResult.create(v -> v >= minValue, holder);
                }
                if (input.startsWith(">")) {
                    long minValue = Long.parseLong(input.substring(1));
                    return PredicateWithResult.create(v -> v > minValue, holder);
                }
                if (input.startsWith("<=")) {
                    long maxValue = Long.parseLong(input.substring(2));
                    return PredicateWithResult.create(v -> v <= maxValue, holder);
                }
                if (input.startsWith("<")) {
                    long maxValue = Long.parseLong(input.substring(1));
                    return PredicateWithResult.create(v -> v <= maxValue, holder);
                }
                if (input.startsWith("=")) {
                    long value = input.startsWith("==") ? Long.parseLong(input.substring(2)) : Long.parseLong(input.substring(1));
                    return PredicateWithResult.create(v -> v == value, holder);
                }
                if ((input.startsWith("[") || input.startsWith("(")) && (input.endsWith("]") || input.endsWith(")"))) {
                    boolean startInclusive = input.startsWith("[");
                    boolean endInclusive = input.endsWith("]");
                    input = input.substring(1, input.length() - 1);
                    String[] split = input.split(",", 2);
                    long start = Long.parseLong(split[0]);
                    long end = Long.parseLong(split[1]);
                    if (end < start) {
                        return null;
                    }
                    return PredicateWithResult.create(v -> startInclusive && v == start || endInclusive && v == end || v < end && v > start, holder);
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
        return Objects.requireNonNullElseGet((Predicate)holder.get(), Predicates::alwaysTrue);
    }

    public static void floatRange(PendingSearch search, String filter, float value) {
        search.processUnfiltered(FilterUtils.floatRange(filter, value));
    }

    public static Predicate<String> floatRange(String filter, float value) {
        return input -> {
            try {
                if (!input.startsWith(filter)) {
                    return false;
                }
                if ((input = input.substring(filter.length())).startsWith(">=")) {
                    return value >= Float.parseFloat(input.substring(2));
                }
                if (input.startsWith(">")) {
                    return value > Float.parseFloat(input.substring(1));
                }
                if (input.startsWith("<=")) {
                    return value <= Float.parseFloat(input.substring(2));
                }
                if (input.startsWith("<")) {
                    return value < Float.parseFloat(input.substring(1));
                }
                if (input.startsWith("=")) {
                    if (input.startsWith("==")) {
                        return value == Float.parseFloat(input.substring(2));
                    }
                    return value == Float.parseFloat(input.substring(1));
                }
                if ((input.startsWith("[") || input.startsWith("(")) && (input.endsWith("]") || input.endsWith(")"))) {
                    boolean startInclusive = input.startsWith("[");
                    boolean endInclusive = input.endsWith("]");
                    input = input.substring(1, input.length() - 2);
                    String[] split = input.split(",", 2);
                    float start = Float.parseFloat(split[0]);
                    float end = Float.parseFloat(split[1]);
                    if (end < start) {
                        return false;
                    }
                    return startInclusive && value == start || endInclusive && value == end || value < end && value > start;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    public static Predicate<Float> floatRange(PendingSearch search, String filter) {
        AtomicReference holder = new AtomicReference();
        search.setupUnfiltered(input -> {
            try {
                if (!input.startsWith(filter)) {
                    return null;
                }
                if ((input = input.substring(filter.length())).startsWith(">=")) {
                    float minValue = Float.parseFloat(input.substring(2));
                    return PredicateWithResult.create(v -> v.floatValue() >= minValue, holder);
                }
                if (input.startsWith(">")) {
                    float minValue = Float.parseFloat(input.substring(1));
                    return PredicateWithResult.create(v -> v.floatValue() > minValue, holder);
                }
                if (input.startsWith("<=")) {
                    float maxValue = Float.parseFloat(input.substring(2));
                    return PredicateWithResult.create(v -> v.floatValue() <= maxValue, holder);
                }
                if (input.startsWith("<")) {
                    float maxValue = Float.parseFloat(input.substring(1));
                    return PredicateWithResult.create(v -> v.floatValue() <= maxValue, holder);
                }
                if (input.startsWith("=")) {
                    float value = input.startsWith("==") ? Float.parseFloat(input.substring(2)) : Float.parseFloat(input.substring(1));
                    return PredicateWithResult.create(v -> v.floatValue() == value, holder);
                }
                if ((input.startsWith("[") || input.startsWith("(")) && (input.endsWith("]") || input.endsWith(")"))) {
                    boolean startInclusive = input.startsWith("[");
                    boolean endInclusive = input.endsWith("]");
                    input = input.substring(1, input.length() - 1);
                    String[] split = input.split(",", 2);
                    float start = Float.parseFloat(split[0]);
                    float end = Float.parseFloat(split[1]);
                    if (end < start) {
                        return null;
                    }
                    return PredicateWithResult.create(v -> startInclusive && v.floatValue() == start || endInclusive && v.floatValue() == end || v.floatValue() < end && v.floatValue() > start, holder);
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
        return Objects.requireNonNullElseGet((Predicate)holder.get(), Predicates::alwaysTrue);
    }

    public static void checkStockCount(PendingSearch search, TraderData trader) {
        int stockCount = 0;
        TradeContext context = TradeContext.createStorageMode(trader);
        for (TradeData tradeData : trader.getTradeData()) {
            if (!tradeData.isValid() || !tradeData.hasStock(context)) continue;
            ++stockCount;
        }
        FilterUtils.intRange(search, "stock", stockCount);
    }

    public static Predicate<TradeData> getTradeFilter(PendingSearch search, TraderData trader) {
        TradeContext context = TradeContext.createStorageMode(trader);
        Predicate<Integer> stockTest = FilterUtils.intRange(search, "tradestock");
        return t -> stockTest.test(t.getStock(context));
    }
}

