/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.IOwnableBlockEntity;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxCollector;
import io.github.lightman314.lightmanscurrency.api.taxes.TaxAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderState;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockBase;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeableBlockEntity;
import io.github.lightman314.lightmanscurrency.network.message.trader.SPacketTaxInfo;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class TraderBlockEntity<D extends TraderData>
extends EasyBlockEntity
implements IOwnableBlockEntity,
IServerTicker,
IUpgradeableBlockEntity {
    private long traderID = -1L;
    private CompoundTag customTrader = null;
    private boolean ignoreCustomTrader = false;
    private boolean selfPickup = false;
    private boolean legitimateBreak = false;

    public long getTraderID() {
        return this.traderID;
    }

    @Deprecated
    public void setTraderID(long traderID) {
        this.traderID = traderID;
    }

    public void flagAsPickup() {
        this.selfPickup = true;
    }

    public boolean isSelfPickup() {
        return this.selfPickup;
    }

    public void flagAsLegitBreak() {
        this.legitimateBreak = true;
    }

    public boolean legitimateBreak() {
        return this.legitimateBreak;
    }

    public boolean supportsTraderPickup() {
        return true;
    }

    public ItemStack PickupTrader(@Nonnull Player player, @Nonnull TraderData trader) {
        if (!this.supportsTraderPickup() || trader.getID() != this.traderID) {
            return ItemStack.f_41583_;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Block block = state.m_60734_();
        if (block instanceof TraderBlockBase) {
            TraderBlockBase block2 = (TraderBlockBase)block;
            this.selfPickup = true;
            this.legitimateBreak = true;
            block2.removeAllBlocks(this.f_58857_, state, this.f_58858_);
            return new ItemStack((ItemLike)state.m_60734_());
        }
        return ItemStack.f_41583_;
    }

    public TraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private D buildTrader(Player owner, ItemStack placementStack) {
        D newTrader;
        if (this.customTrader != null && (newTrader = this.fullyBuildCustomTrader()) != null) {
            return newTrader;
        }
        newTrader = this.buildNewTrader();
        ((TraderData)newTrader).getOwner().SetOwner(PlayerOwner.of(owner));
        if (placementStack.m_41788_()) {
            ((TraderData)newTrader).setCustomName(placementStack.m_41786_().getString());
        }
        return newTrader;
    }

    protected final D initCustomTrader() {
        try {
            return this.castOrNullify(TraderData.Deserialize(false, this.customTrader));
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error while attempting to load the custom trader!", t);
            return null;
        }
    }

    protected final D fullyBuildCustomTrader() {
        try {
            D newTrader = this.initCustomTrader();
            this.moveCustomTrader(newTrader);
            return newTrader;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error while attempting to load the custom trader!", t);
            return null;
        }
    }

    protected final void moveCustomTrader(D customTrader) {
        if (customTrader != null) {
            ((TraderData)customTrader).move(this.f_58857_, this.f_58858_);
        }
    }

    @Nonnull
    protected abstract D buildNewTrader();

    public final void saveCurrentTraderAsCustomTrader() {
        D trader = this.getTraderData();
        if (trader != null) {
            this.customTrader = ((TraderData)trader).save();
            this.ignoreCustomTrader = true;
            this.markDirty();
        }
    }

    @Nullable
    private CompoundTag getCurrentTraderAsTag() {
        D trader = this.getTraderData();
        if (trader != null) {
            return ((TraderData)trader).save();
        }
        return null;
    }

    public void initialize(@Nonnull Player owner, @Nonnull ItemStack placementStack) {
        long traderID;
        TraderData trader;
        if (this.getTraderData() != null) {
            return;
        }
        CompoundTag tag = placementStack.m_41783_();
        if (tag != null && tag.m_128425_("StoredTrader", 4) && (trader = TraderAPI.API.GetTrader(this, traderID = tag.m_128454_("StoredTrader"))) != null && this.castOrNullify(trader) != null && trader.isRecoverable()) {
            this.traderID = traderID;
            this.markDirty();
            trader.move(this.f_58857_, this.f_58858_);
            trader.setState(TraderState.NORMAL);
            this.checkTaxes(owner, trader);
            return;
        }
        D newTrader = this.buildTrader(owner, placementStack);
        if (this.getCurrentVariant() != null) {
            ((TraderData)newTrader).setTraderBlockVariant(this.getCurrentVariant(), this.isVariantLocked());
        }
        this.traderID = TraderAPI.API.CreateTrader((TraderData)newTrader, owner);
        this.checkTaxes(owner, (TraderData)newTrader);
        this.markDirty();
    }

    private void checkTaxes(@Nonnull Player player, @Nonnull TraderData trader) {
        List<ITaxCollector> taxes = TaxAPI.API.AcknowledgeTaxCollectors(trader);
        if (!taxes.isEmpty()) {
            SPacketTaxInfo.sendPacket(taxes, player);
        }
    }

    public TraderData getRawTraderData() {
        return TraderAPI.API.GetTrader(this, this.traderID);
    }

    @Nullable
    public D getTraderData() {
        TraderData rawData = this.getRawTraderData();
        if (rawData == null) {
            return null;
        }
        return this.castOrNullify(rawData);
    }

    @Nullable
    protected abstract D castOrNullify(@Nonnull TraderData var1);

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128356_("TraderID", this.traderID);
        if (this.customTrader != null) {
            compound.m_128365_("CustomTrader", (Tag)this.customTrader);
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("TraderID", 4)) {
            this.traderID = compound.m_128454_("TraderID");
        }
        if (compound.m_128441_("CustomTrader")) {
            this.customTrader = compound.m_128469_("CustomTrader");
        }
    }

    @Override
    public void serverTick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.customTrader != null && !this.ignoreCustomTrader) {
            D customTrader = this.initCustomTrader();
            if (customTrader == null) {
                LightmansCurrency.LogWarning("The trader block at " + this.f_58858_.m_123344_() + " could not properly load it's custom trader.");
                this.customTrader = null;
            }
            if (((TraderData)customTrader).getLevel() == this.f_58857_.m_46472_() && this.f_58858_.equals((Object)((TraderData)customTrader).getPos())) {
                this.ignoreCustomTrader = true;
            } else {
                this.moveCustomTrader(customTrader);
                this.traderID = TraderAPI.API.CreateTrader((TraderData)customTrader, null);
                this.customTrader = null;
                this.ignoreCustomTrader = true;
                this.markDirty();
                LightmansCurrency.LogInfo("Successfully loaded custom trader at " + this.f_58858_.m_123344_());
            }
        }
    }

    public final void markDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this);
        }
    }

    @Override
    public void onLoad() {
        if (this.isServer()) {
            this.moveCustomTrader(this.getTraderData());
        }
        super.onLoad();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        D trader = this.getTraderData();
        if (trader != null) {
            Direction relativeSide = side;
            Block block = this.m_58900_().m_60734_();
            if (block instanceof IRotatableBlock) {
                IRotatableBlock block2 = (IRotatableBlock)block;
                relativeSide = IRotatableBlock.getRelativeSide(block2.getFacing(this.m_58900_()), side);
            }
            return ((TraderData)trader).getCapability(cap, relativeSide);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canBreak(@Nullable Player player) {
        D trader = this.getTraderData();
        if (trader != null) {
            return ((TraderData)trader).hasPermission(player, "breakTrader");
        }
        return true;
    }

    public void onBreak() {
        TraderAPI.API.DeleteTrader(this.traderID);
    }

    public AABB getRenderBoundingBox() {
        if (this.m_58900_() != null) {
            return this.m_58900_().m_60812_((BlockGetter)this.f_58857_, this.f_58858_).m_83215_().m_82338_(this.f_58858_);
        }
        return super.getRenderBoundingBox();
    }

    @Override
    @Nullable
    public IUpgradeable getUpgradeable() {
        return this.getTraderData();
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant, boolean locked) {
        super.setVariant(variant, locked);
        D t = this.getTraderData();
        if (t != null) {
            ((TraderData)t).setTraderBlockVariant(variant, locked);
        }
    }
}

