/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.settings;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsSubNode;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.NodeSelections;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextData;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface ISaveableSettingsHolder
extends IClientTracker {
    public List<SettingsNode> getAllSettingNodes();

    @Nullable
    public SettingsNode getNode(String var1);

    @Nullable
    public MutableComponent getName();

    public void buildLoadContext(LoadContext.Builder var1);

    default public NodeSelections defaultNodeSelections(@Nullable Player player) {
        NodeSelections selections = new NodeSelections();
        for (SettingsNode node : this.getAllSettingNodes()) {
            node.applyDefaultSelections(selections, player);
        }
        return selections;
    }

    default public SavedSettingData saveSettings() {
        return this.saveSettings(null, this.defaultNodeSelections(null));
    }

    default public SavedSettingData saveSettings(@Nullable Player player, NodeSelections selections) {
        SavedSettingData.Mutable builder = SavedSettingData.EMPTY.makeMutable();
        for (SettingsNode node : this.getAllSettingNodes()) {
            if (!selections.nodeSelected(node.key) || !node.allowSaving(player)) continue;
            node.saveSettings(builder.getNode(node.key));
            for (SettingsSubNode<?> subNode : node.getSubNodes()) {
                if (!selections.subNodeSelected(node.key, subNode.getSubKey()) || !subNode.allowSaving(player)) continue;
                subNode.saveSettings(builder.getNode(subNode.getFullKey()));
            }
        }
        return builder.makeImmutable();
    }

    default public PrettyTextData writePrettySettings(SavedSettingData data) {
        ArrayList text = new ArrayList();
        List<SettingsNode> allNodes = this.getAllSettingNodes();
        allNodes.sort(SettingsNode.SORTER);
        for (SettingsNode node : allNodes) {
            if (!data.hasNode(node.key)) continue;
            node.writeAsText(data, text::add);
            for (SettingsSubNode<?> subNode : node.getSubNodes()) {
                if (!data.hasNode(subNode.getFullKey())) continue;
                subNode.writeAsText(data, text::add);
            }
        }
        return new PrettyTextData((Component)LCText.DATA_NAME_FORMAT.get(this.getName()), (List<Component>)ImmutableList.copyOf(text));
    }

    default public void loadSettings(Player player, SavedSettingData data, NodeSelections selections) {
        LoadContext.Builder contextBuilder = LoadContext.builder(player, this);
        this.buildLoadContext(contextBuilder);
        LoadContext context = contextBuilder.build();
        ArrayList<SettingsNode> allNodes = new ArrayList<SettingsNode>(this.getAllSettingNodes());
        allNodes.sort(SettingsNode.SORTER);
        for (SettingsNode node : allNodes) {
            if (!selections.nodeSelected(node.key) || !data.hasNode(node.key) || !node.allowLoading(context)) continue;
            node.loadSettings(data.getNode(node.key), context);
            for (SettingsSubNode<?> subNode : node.getSubNodes()) {
                if (!selections.subNodeSelected(node.key, subNode.getSubKey()) || !data.hasNode(subNode.getFullKey()) || !subNode.allowLoading(context)) continue;
                subNode.loadSettings(data.getNode(subNode.getFullKey()), context);
            }
        }
    }
}

