/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ownership;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.ownership.OwnerType;
import io.github.lightman314.lightmanscurrency.api.ownership.OwnershipAPI;
import io.github.lightman314.lightmanscurrency.api.stats.StatKey;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class Owner
implements IClientTracker {
    public static final OwnerType NULL_TYPE = OwnerType.create(VersionUtil.lcResource("null"), t -> Owner.getNull());
    private IClientTracker parent = null;

    public static Owner getNull() {
        return new NullOwner();
    }

    public static Owner getNull(@Nonnull IClientTracker parent) {
        Owner owner = Owner.getNull();
        owner.setParent(parent);
        return owner;
    }

    @Override
    public final boolean isClient() {
        return this.parent == null || this.parent.isClient();
    }

    public final void setParent(@Nonnull IClientTracker parent) {
        this.parent = parent;
    }

    @Nonnull
    public abstract MutableComponent getName();

    @Nonnull
    public abstract MutableComponent getCommandLabel();

    public abstract boolean stillValid();

    public boolean alwaysValid() {
        return false;
    }

    public final boolean isNull() {
        return this instanceof NullOwner;
    }

    public abstract boolean isOnline();

    public abstract boolean isAdmin(@Nonnull PlayerReference var1);

    public abstract boolean isMember(@Nonnull PlayerReference var1);

    @Nonnull
    public abstract PlayerReference asPlayerReference();

    @Nullable
    public abstract BankReference asBankReference();

    public boolean hasNotificationLevels() {
        return false;
    }

    @Nonnull
    public static MutableComponent getOwnerLevelBlurb(int notificationLevel) {
        return switch (notificationLevel) {
            case 0 -> LCText.BLURB_OWNERSHIP_MEMBERS.get(new Object[0]);
            case 1 -> LCText.BLURB_OWNERSHIP_ADMINS.get(new Object[0]);
            default -> LCText.BLURB_OWNERSHIP_OWNER.get(new Object[0]);
        };
    }

    public static int validateNotificationLevel(int level) {
        return level % 3;
    }

    public abstract void pushNotification(@Nonnull Supplier<? extends Notification> var1, int var2, boolean var3);

    public <T> void incrementStat(@Nonnull StatKey<?, T> key, @Nonnull T addValue) {
    }

    @Nonnull
    public abstract OwnerType getType();

    @Nonnull
    public final CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", this.getType().getID().toString());
        this.saveAdditional(tag);
        return tag;
    }

    protected abstract void saveAdditional(@Nonnull CompoundTag var1);

    @Nullable
    public static Owner load(@Nonnull CompoundTag tag) {
        ResourceLocation id = VersionUtil.parseResource(tag.m_128461_("Type"));
        OwnerType type = OwnershipAPI.API.getOwnerType(id);
        if (type != null) {
            return type.load(tag);
        }
        LightmansCurrency.LogError("No owner type " + id + " is registered!\nCould not load the owner!");
        return null;
    }

    public abstract Owner copy();

    public boolean equals(Object obj) {
        if (obj instanceof Owner) {
            Owner o = (Owner)obj;
            return this.matches(o);
        }
        return false;
    }

    public abstract boolean matches(@Nonnull Owner var1);

    private static class NullOwner
    extends Owner {
        private NullOwner() {
        }

        @Override
        @Nonnull
        public MutableComponent getName() {
            return LCText.GUI_OWNER_NULL.get(new Object[0]);
        }

        @Override
        @Nonnull
        public MutableComponent getCommandLabel() {
            return LCText.COMMAND_LCADMIN_DATA_OWNER_CUSTOM.get(this.getName());
        }

        @Override
        public boolean stillValid() {
            return false;
        }

        @Override
        public boolean isOnline() {
            return false;
        }

        @Override
        public boolean isAdmin(@Nonnull PlayerReference player) {
            return false;
        }

        @Override
        public boolean isMember(@Nonnull PlayerReference player) {
            return false;
        }

        @Override
        @Nonnull
        public PlayerReference asPlayerReference() {
            return PlayerReference.NULL;
        }

        @Override
        @Nullable
        public BankReference asBankReference() {
            return null;
        }

        @Override
        public void pushNotification(@Nonnull Supplier<? extends Notification> notificationSource, int notificationLevel, boolean sendToChat) {
        }

        @Override
        @Nonnull
        public OwnerType getType() {
            return NULL_TYPE;
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag tag) {
        }

        @Override
        @Nonnull
        public Owner copy() {
            return NullOwner.getNull();
        }

        @Override
        public boolean matches(@Nonnull Owner other) {
            return other.isNull();
        }
    }
}

