/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.data.variables.permissions;

import io.github.lightman314.lightmanscurrency.api.misc.IPermissions;
import io.github.lightman314.lightmanscurrency.api.misc.data.variables.permissions.IVariablePermission;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LeveledPermissions {
    public static IVariablePermission hasPermission(String permission) {
        return (player, host) -> {
            if (host instanceof IPermissions) {
                IPermissions p = (IPermissions)((Object)host);
                return p.hasPermission(player, permission);
            }
            return false;
        };
    }

    public static IVariablePermission minPermission(String permission, int minLevel) {
        return (player, host) -> {
            if (host instanceof IPermissions) {
                IPermissions p = (IPermissions)((Object)host);
                return p.getPermissionLevel(player, permission) >= minLevel;
            }
            return false;
        };
    }

    public static IVariablePermission exactPermission(String permission, int exactLevel) {
        return (player, host) -> {
            if (host instanceof IPermissions) {
                IPermissions p = (IPermissions)((Object)host);
                return p.getPermissionLevel(player, permission) == exactLevel;
            }
            return false;
        };
    }
}

