/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringOption
extends ConfigOption<String> {
    public static final ConfigParser<String> PARSER = new Parser();

    protected StringOption(@Nonnull Supplier<String> defaultValue) {
        super(defaultValue);
    }

    @Nonnull
    public static StringOption create(@Nonnull String defaultValue) {
        return new StringOption(() -> defaultValue);
    }

    public static StringOption create(@Nonnull Supplier<String> defaultValue) {
        return new StringOption(defaultValue);
    }

    @Override
    @Nonnull
    protected ConfigParser<String> getParser() {
        return PARSER;
    }

    @Override
    @Nullable
    protected String bonusComment() {
        return "Default: " + PARSER.write((String)this.getDefaultValue());
    }

    private static class Parser
    implements ConfigParser<String> {
        private Parser() {
        }

        @Override
        @Nonnull
        public String tryParse(@Nonnull String cleanLine) throws ConfigParsingException {
            if (cleanLine.startsWith("\"") && cleanLine.endsWith("\"")) {
                return cleanLine.substring(1, cleanLine.length() - 1);
            }
            return cleanLine;
        }

        @Override
        @Nonnull
        public String write(@Nonnull String value) {
            return "\"" + value + "\"";
        }
    }
}

