/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.event.ConfigEvent;
import io.github.lightman314.lightmanscurrency.api.config.event.ConfigReloadAllEvent;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ConfigFile {
    private static final Map<ResourceLocation, ConfigFile> loadableFiles = new HashMap<ResourceLocation, ConfigFile>();
    private final ResourceLocation fileID;
    private final String fileName;
    private final List<Runnable> reloadListeners = new ArrayList<Runnable>();
    private ConfigSection root = null;
    public final LoadPhase loadPhase;
    private boolean reloading = false;
    private boolean loaded = false;

    public static Iterable<ConfigFile> getAvailableFiles() {
        return ImmutableList.copyOf(loadableFiles.values());
    }

    @Nullable
    public static ConfigFile lookupFile(ResourceLocation file) {
        return loadableFiles.get(file);
    }

    private static void registerConfig(ConfigFile file) {
        loadableFiles.put(file.fileID, file);
    }

    public static void loadClientFiles(LoadPhase phase) {
        ConfigFile.loadFiles(true, phase);
    }

    public static void loadServerFiles(LoadPhase phase) {
        ConfigFile.loadFiles(false, phase);
    }

    public static void loadFiles(boolean logicalClient, LoadPhase phase) {
        for (ConfigFile file : loadableFiles.values()) {
            try {
                if (file.isLoaded() || !file.shouldReload(logicalClient) || file.loadPhase != phase) continue;
                file.reload();
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LightmansCurrency.LogError("Error reloading config file!", e);
            }
        }
    }

    public static void reloadClientFiles() {
        ConfigFile.reloadFiles(true);
    }

    public static void reloadServerFiles() {
        ConfigFile.reloadFiles(false);
    }

    private static void reloadFiles(boolean logicalClient) {
        VersionUtil.postEvent(new ConfigReloadAllEvent.Pre(logicalClient));
        for (ConfigFile file : loadableFiles.values()) {
            try {
                if (!file.shouldReload(logicalClient)) continue;
                file.reload();
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LightmansCurrency.LogError("Error reloading config file!", e);
            }
        }
        VersionUtil.postEvent(new ConfigReloadAllEvent.Post(logicalClient));
    }

    protected String getConfigFolder() {
        return "config";
    }

    public ResourceLocation getFileID() {
        return this.fileID;
    }

    @Deprecated(since="2.2.5.1c")
    public String getFileName() {
        return this.fileName;
    }

    public final void addListener(Runnable listener) {
        if (!this.reloadListeners.contains(listener)) {
            this.reloadListeners.add(listener);
        }
    }

    protected String getFilePath() {
        return this.getConfigFolder() + "/" + this.fileName + ".txt";
    }

    private String getOldFilePath() {
        return this.getFilePath().replace(".txt", ".lcconfig");
    }

    protected final File getFile() {
        return new File(this.getFilePath());
    }

    private File getOldFile() {
        return new File(this.getOldFilePath());
    }

    public final void confirmSetup() {
        if (this.root == null) {
            ConfigBuilder builder = new ConfigBuilder();
            this.setup(builder);
            this.root = builder.build(this);
        }
    }

    protected final void forEach(Consumer<ConfigOption<?>> action) {
        this.confirmSetup();
        this.root.forEach(action);
    }

    public final Map<String, ConfigOption<?>> getAllOptions() {
        this.confirmSetup();
        HashMap results = new HashMap();
        this.collectOptionsFrom(this.root, results);
        return ImmutableMap.copyOf(results);
    }

    private void collectOptionsFrom(ConfigSection section, Map<String, ConfigOption<?>> resultMap) {
        section.options.forEach((? super K key, ? super V option) -> resultMap.put(section.fullNameOfChild((String)key), (ConfigOption<?>)option));
        section.sectionsInOrder.forEach((? super T s) -> this.collectOptionsFrom((ConfigSection)s, resultMap));
    }

    @Nullable
    protected final ConfigSection findSection(String sectionName) {
        String[] subSections = sectionName.split("\\.");
        ConfigSection currentSection = this.root;
        for (String ss : subSections) {
            if (!currentSection.sections.containsKey(ss)) {
                return null;
            }
            currentSection = currentSection.sections.get(ss);
        }
        return currentSection;
    }

    @Deprecated(since="2.2.5.1c")
    protected ConfigFile(String fileName) {
        this(ConfigFile.forceGenerateID(fileName), fileName, LoadPhase.SETUP);
    }

    protected ConfigFile(ResourceLocation fileID, String fileName) {
        this(fileID, fileName, LoadPhase.SETUP);
    }

    @Deprecated(since="2.2.5.1c")
    protected ConfigFile(String fileName, LoadPhase loadPhase) {
        this(ConfigFile.forceGenerateID(fileName), fileName, loadPhase);
    }

    protected ConfigFile(ResourceLocation fileID, String fileName, LoadPhase loadPhase) {
        this.fileID = fileID;
        this.fileName = fileName;
        this.loadPhase = loadPhase;
        ConfigFile.registerConfig(this);
    }

    public static ResourceLocation forceGenerateID(String fileName) {
        if (fileName.contains("-")) {
            String[] split = fileName.split("-", 2);
            return VersionUtil.modResource(ConfigFile.forceValidNamespace(split[0]), ConfigFile.forceValidPath(split[1]));
        }
        return VersionUtil.modResource("unknown", ConfigFile.forceValidPath(fileName));
    }

    private static String forceValidNamespace(String string) {
        Object namespace = string.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < ((String)namespace).length(); ++i) {
            if (ResourceLocation.m_135835_((char)((String)namespace).charAt(i))) continue;
            namespace = i == 0 ? ((String)namespace).substring(1) : ((String)namespace).substring(0, i) + ((String)namespace).substring(i + 1);
            --i;
        }
        return namespace;
    }

    private static String forceValidPath(String string) {
        Object namespace = string.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < ((String)namespace).length(); ++i) {
            if (ResourceLocation.m_135828_((char)((String)namespace).charAt(i))) continue;
            namespace = i == 0 ? ((String)namespace).substring(1) : ((String)namespace).substring(0, i) + ((String)namespace).substring(i + 1);
            --i;
        }
        return namespace;
    }

    public boolean isClientOnly() {
        return false;
    }

    public boolean isServerOnly() {
        return false;
    }

    protected abstract void setup(ConfigBuilder var1);

    public final boolean shouldReload(boolean isLogicalClient) {
        if (this.isClientOnly() && !isLogicalClient) {
            return false;
        }
        if (this.isServerOnly() && isLogicalClient) {
            return false;
        }
        return this.canReload(isLogicalClient);
    }

    protected boolean canReload(boolean isLogicalClient) {
        return true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public final void forceLoaded() {
        if (!this.loaded) {
            this.reload();
        }
    }

    public final void reload() {
        if (this.reloading) {
            return;
        }
        this.reloading = true;
        boolean isFirstLoad = !this.isLoaded();
        VersionUtil.postEvent(new ConfigEvent.ConfigReloadedEvent.Pre(this, isFirstLoad));
        try {
            LightmansCurrency.LogInfo("Reloading " + this.getFilePath());
            this.confirmSetup();
            List<String> lines = this.readLines();
            this.forEach(ConfigOption::clear);
            ConfigSection currentSection = this.root;
            for (String line : lines) {
                String cleanLine = ConfigFile.cleanStartingWhitespace(line);
                if (cleanLine.startsWith("#")) continue;
                int equalIndex = cleanLine.indexOf(61);
                if (equalIndex > 0) {
                    String optionName = cleanLine.substring(0, equalIndex);
                    String optionValue = "";
                    if (equalIndex < cleanLine.length() - 1) {
                        optionValue = cleanLine.substring(equalIndex + 1);
                    }
                    if (currentSection.options.containsKey(optionName)) {
                        currentSection.options.get(optionName).load(optionValue, ConfigOption.LoadSource.FILE);
                        continue;
                    }
                    LightmansCurrency.LogWarning("Option " + currentSection.fullName() + "." + optionName + " found in the file, but is not present in the config setup!");
                    continue;
                }
                if (!cleanLine.startsWith("[")) continue;
                String fullyCleaned = ConfigOption.cleanWhitespace(cleanLine);
                if (fullyCleaned.endsWith("]")) {
                    String section = fullyCleaned.substring(1, fullyCleaned.length() - 1);
                    ConfigSection query = this.findSection(section);
                    if (query != null) {
                        currentSection = query;
                        continue;
                    }
                    LightmansCurrency.LogWarning("Line " + (lines.indexOf(line) + 1) + " of " + this.fileName + " contained a section (" + section + ") that is not present in this config!");
                    currentSection = this.root;
                    continue;
                }
                LightmansCurrency.LogWarning("Line " + (lines.indexOf(line) + 1) + " of config '" + this.fileName + "' is missing the ']' for the section label!");
            }
            this.getAllOptions().forEach((? super K id, ? super V option) -> {
                if (!option.isLoaded()) {
                    option.loadDefault();
                    LightmansCurrency.LogWarning("Option " + id + " was missing from the config. Default value will be used instead.");
                }
            });
            this.loaded = true;
            this.writeToFile();
            this.afterReload();
            for (Runnable l : this.reloadListeners) {
                l.run();
            }
        }
        finally {
            this.reloading = false;
        }
        VersionUtil.postEvent(new ConfigEvent.ConfigReloadedEvent.Post(this, isFirstLoad));
    }

    public static String cleanStartingWhitespace(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return line.substring(i);
        }
        return line;
    }

    private List<String> readLines() {
        File file = this.getFile();
        if (!file.exists() && !(file = this.getOldFile()).exists()) {
            return new ArrayList<String>();
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            br.close();
            return lines;
        }
        catch (IOException e) {
            LightmansCurrency.LogError("Error loading config file '" + file.getPath() + "'!", e);
            return new ArrayList<String>();
        }
    }

    public final void onOptionChanged(ConfigOption<?> option) {
        this.writeToFile();
        this.afterOptionChanged(option);
    }

    public final void writeToFile() {
        File file = this.getFile();
        try {
            if (!file.exists()) {
                File folder = new File(file.getParent());
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                if (!file.createNewFile()) {
                    LightmansCurrency.LogError("Unable to create " + this.fileName + "!");
                    return;
                }
            }
            try (PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8);){
                this.confirmSetup();
                this.writeSection(writer, this.root);
            }
        }
        catch (IOException | SecurityException e) {
            LightmansCurrency.LogError("Error modifying " + this.fileName + "!", e);
        }
        File oldFile = this.getOldFile();
        if (oldFile.exists()) {
            try {
                oldFile.delete();
            }
            catch (SecurityException e) {
                LightmansCurrency.LogError("Error deleting expired config file", e);
            }
        }
    }

    private void writeSection(PrintWriter writer, ConfigSection section) {
        Consumer<String> w;
        if (section.parent != null) {
            w = section.parent.lineConsumer(writer);
            ConfigFile.writeComments(section.comments, w);
            w.accept("[" + section.fullName() + "]");
        }
        w = section.lineConsumer(writer);
        section.optionsInOrder.forEach((? super T pair) -> ((ConfigOption)pair.getSecond()).write((String)pair.getFirst(), w));
        section.sectionsInOrder.forEach((? super T s) -> this.writeSection(writer, (ConfigSection)s));
    }

    public static Consumer<String> lineConsumer(PrintWriter writer, int depth) {
        return s -> writer.println("\t".repeat(Math.max(0, depth)) + s);
    }

    public static void writeComments(List<String> comments, Consumer<String> writer) {
        for (String c : comments) {
            for (String c2 : c.split("\n")) {
                writer.accept("#" + c2);
            }
        }
    }

    protected void afterReload() {
    }

    protected void afterOptionChanged(ConfigOption<?> option) {
    }

    public static enum LoadPhase {
        NULL,
        SETUP,
        GAME_START;

    }

    protected static final class ConfigSection {
        private final ConfigSection parent;
        private final int depth;
        private final String name;
        private final List<String> comments;
        private final List<ConfigSection> sectionsInOrder;
        private final Map<String, ConfigSection> sections;
        private final List<Pair<String, ConfigOption<?>>> optionsInOrder;
        private final Map<String, ConfigOption<?>> options;

        private String fullName() {
            if (this.parent != null) {
                return this.parent.fullNameOfChild(this.name);
            }
            return this.name;
        }

        private String fullNameOfChild(String childName) {
            if (this.parent == null) {
                return childName;
            }
            return this.fullName() + "." + childName;
        }

        void forEach(Consumer<ConfigOption<?>> action) {
            this.optionsInOrder.forEach((? super T p) -> action.accept((ConfigOption)p.getSecond()));
            this.sectionsInOrder.forEach((? super T s) -> s.forEach(action));
        }

        Consumer<String> lineConsumer(PrintWriter writer) {
            return ConfigFile.lineConsumer(writer, this.depth);
        }

        private ConfigSection(ConfigSectionBuilder builder, ConfigSection parent, ConfigFile file) {
            this.name = builder.name;
            this.depth = builder.depth;
            this.parent = parent;
            this.comments = ImmutableList.copyOf(builder.comments);
            this.optionsInOrder = ImmutableList.copyOf(builder.optionsInOrder);
            this.options = ImmutableMap.copyOf(builder.options);
            this.options.forEach((? super K key, ? super V option) -> option.init(file, (String)key, this.fullNameOfChild((String)key)));
            ArrayList temp1 = new ArrayList();
            builder.sectionsInOrder.forEach((? super T b) -> temp1.add(b.build(this, file)));
            this.sectionsInOrder = ImmutableList.copyOf(temp1);
            HashMap temp2 = new HashMap();
            this.sectionsInOrder.forEach((? super T section) -> temp2.put(section.name, section));
            this.sections = ImmutableMap.copyOf(temp2);
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    protected static final class ConfigBuilder {
        private final ConfigSectionBuilder root = new ConfigSectionBuilder("root", 0, null);
        private final List<String> comments = new ArrayList<String>();
        private ConfigSectionBuilder currentSection = this.root;

        private ConfigSection build(ConfigFile file) {
            return this.root.build(null, file);
        }

        private ConfigBuilder() {
        }

        public ConfigBuilder push(String newSection) {
            if (ConfigBuilder.invalidName(newSection)) {
                throw new IllegalArgumentException("Illegal section name '" + newSection + "'!");
            }
            this.currentSection = this.currentSection.sections.containsKey(newSection) ? this.currentSection.sections.get(newSection) : this.currentSection.addChild(newSection);
            this.currentSection.comments.addAll(this.comments);
            this.comments.clear();
            return this;
        }

        public static boolean invalidName(String name) {
            if (name.equals("root")) {
                return false;
            }
            for (int i = 0; i < name.length(); ++i) {
                if (ConfigBuilder.validNameChar(name.charAt(i))) continue;
                return true;
            }
            return false;
        }

        public static boolean validNameChar(char c) {
            return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z';
        }

        public ConfigBuilder pop() {
            if (this.currentSection == this.root) {
                throw new IllegalArgumentException("Cannot pop the builder when we're already at root level!");
            }
            this.currentSection = this.currentSection.parent;
            return this;
        }

        public ConfigBuilder comment(String ... comment) {
            this.comments.addAll((Collection<String>)ImmutableList.copyOf((Object[])comment));
            return this;
        }

        public ConfigBuilder add(String optionName, ConfigOption<?> option) {
            if (ConfigBuilder.invalidName(optionName)) {
                throw new IllegalArgumentException("Illegal option name '" + optionName + "'!");
            }
            if (this.currentSection == null) {
                this.currentSection = this.root;
            }
            if (this.currentSection.options.containsKey(optionName)) {
                LightmansCurrency.LogError("Duplicate option '" + this.currentSection.fullNameOfChild(optionName) + "'!\nDuplicate option will be ignored!");
                return this;
            }
            this.currentSection.addOption(optionName, option);
            option.setComments(this.comments);
            this.comments.clear();
            return this;
        }
    }

    private static final class ConfigSectionBuilder {
        private final ConfigSectionBuilder parent;
        private final String name;
        private final int depth;
        private final List<String> comments = new ArrayList<String>();
        private final List<ConfigSectionBuilder> sectionsInOrder = new ArrayList<ConfigSectionBuilder>();
        private final Map<String, ConfigSectionBuilder> sections = new HashMap<String, ConfigSectionBuilder>();
        private final List<Pair<String, ConfigOption<?>>> optionsInOrder = new ArrayList();
        private final Map<String, ConfigOption<?>> options = new HashMap();

        private String fullName() {
            if (this.parent != null) {
                return this.parent.fullNameOfChild(this.name);
            }
            return this.name;
        }

        private String fullNameOfChild(String childName) {
            if (this.parent == null) {
                return childName;
            }
            return this.fullName() + "." + childName;
        }

        private ConfigSectionBuilder(String name, int depth, ConfigSectionBuilder parent) {
            this.name = name;
            this.depth = depth;
            this.parent = parent;
        }

        private void addOption(String name, ConfigOption<?> option) {
            this.optionsInOrder.add(Pair.of((Object)name, option));
            this.options.put(name, option);
        }

        private ConfigSectionBuilder addChild(String name) {
            ConfigSectionBuilder builder = new ConfigSectionBuilder(name, this.depth + 1, this);
            this.sectionsInOrder.add(builder);
            this.sections.put(name, builder);
            return builder;
        }

        private ConfigSection build(@Nullable ConfigSection parent, ConfigFile file) {
            return new ConfigSection(this, parent, file);
        }
    }
}

