/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.DrawerTile;
import com.buuz135.functionalstorage.client.FunctionalStorageClientConfig;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.util.MathUtils;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class DrawerRenderer
implements BlockEntityRenderer<DrawerTile> {
    public void render(DrawerTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (Minecraft.m_91087_().f_91074_ != null && !tile.m_58899_().m_123314_((Vec3i)Minecraft.m_91087_().f_91074_.m_20097_(), (double)FunctionalStorageClientConfig.DRAWER_RENDER_RANGE)) {
            return;
        }
        matrixStack.m_85836_();
        Direction facing = tile.getFacingDirection();
        matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        if (facing == Direction.NORTH) {
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f), 1.0f));
        } else if (facing == Direction.EAST) {
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, -90.0f, 0.0f), 1.0f));
        } else if (facing == Direction.SOUTH) {
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        } else if (facing == Direction.WEST) {
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 90.0f, 0.0f), 1.0f));
        }
        matrixStack.m_85837_(0.0, 0.0, -0.03125);
        combinedLightIn = LevelRenderer.m_109541_((BlockAndTintGetter)tile.m_58904_(), (BlockPos)tile.m_58899_().m_121945_(facing));
        DrawerRenderer.renderUpgrades(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_1) {
            this.render1Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_2) {
            this.render2Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_4) {
            this.render4Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        matrixStack.m_85849_();
    }

    public static void renderUpgrades(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ControllableDrawerTile<?> tile) {
        float scale = 0.0625f;
        if (tile.getDrawerOptions().isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_UPGRADES)) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.031, (double)0.031f, 0.0295);
            for (int i = 0; i < tile.getStorageUpgrades().getSlots(); ++i) {
                ItemStack stack = tile.getStorageUpgrades().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                matrixStack.m_85836_();
                matrixStack.m_85841_(scale, scale, scale);
                Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, tile.m_58904_(), 0);
                matrixStack.m_85849_();
                matrixStack.m_252880_(scale, 0.0f, 0.0f);
            }
            matrixStack.m_85849_();
        }
        if (tile.isVoid()) {
            matrixStack.m_85836_();
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.969f, 0.031f, 0.0293125f), new Vector3f(0.0f), scale));
            Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)FunctionalStorage.VOID_UPGRADE.get()), ItemDisplayContext.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, tile.m_58904_(), 0);
            matrixStack.m_85849_();
        }
    }

    public static void renderIndicator(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, float progress, ControllableDrawerTile.DrawerOptions options) {
        int indicatiorValue = options.getAdvancedValue(ConfigurationToolItem.ConfigurationAction.INDICATOR);
        if (indicatiorValue != 0) {
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("functionalstorage", "block/indicator"));
            VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110466_());
            Matrix4f posMat = matrixStack.m_85850_().m_252922_();
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            float alpha = 1.0f;
            float x1 = -0.25f;
            float x2 = x1 + 0.5f;
            float y1 = -0.415625f;
            float y2 = y1 + 0.078125f;
            float z2 = 0.0f;
            double bx1 = 0.0;
            double bx2 = 8.0;
            double bz1 = 0.0;
            double bz2 = 2.0;
            float u1 = still.m_118367_(bx1);
            float u2 = still.m_118367_(bx2);
            float v1 = still.m_118393_(bz1);
            float v2 = still.m_118393_(bz2);
            if (indicatiorValue != 3) {
                builder.m_252986_(posMat, x2, y1, z2).m_85950_(red, green, blue, alpha).m_7421_(u2, v1).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(posMat, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(u2, v2).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(posMat, x1, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(u1, v2).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(posMat, x1, y1, z2).m_85950_(red, green, blue, alpha).m_7421_(u1, v1).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            }
            u2 = still.m_118367_(bx2 * (double)progress);
            x2 = x1 + 0.5f * progress;
            z2 = 1.0E-4f;
            v1 = still.m_118393_(8.0);
            v2 = still.m_118393_(10.0);
            if (indicatiorValue == 1 || progress >= 1.0f) {
                builder.m_252986_(posMat, x2, y1, z2).m_85950_(red, green, blue, alpha).m_7421_(u2, v1).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(posMat, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(u2, v2).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(posMat, x1, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(u1, v2).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(posMat, x1, y1, z2).m_85950_(red, green, blue, alpha).m_7421_(u1, v1).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            }
        }
    }

    private void render1Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, DrawerTile tile) {
        BigInventoryHandler inventoryHandler = (BigInventoryHandler)tile.getStorage();
        if (!inventoryHandler.getStoredStacks().get(0).getStack().m_41619_()) {
            matrixStack.m_85837_(0.5, 0.5, (double)5.0E-4f);
            ItemStack stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(0).m_41613_(), inventoryHandler.getSlotLimit(0), 0.015f, tile.getDrawerOptions(), tile.m_58904_());
        }
    }

    private void render2Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, DrawerTile tile) {
        ItemStack stack;
        BigInventoryHandler inventoryHandler = (BigInventoryHandler)tile.getStorage();
        if (!inventoryHandler.getStoredStacks().get(0).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.5f, 0.27f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(0).m_41613_(), inventoryHandler.getSlotLimit(0), 0.02f, tile.getDrawerOptions(), tile.m_58904_());
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getStoredStacks().get(1).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.5f, 0.77f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(1).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(1).m_41613_(), inventoryHandler.getSlotLimit(1), 0.02f, tile.getDrawerOptions(), tile.m_58904_());
            matrixStack.m_85849_();
        }
    }

    private void render4Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, DrawerTile tile) {
        ItemStack stack;
        BigInventoryHandler inventoryHandler = (BigInventoryHandler)tile.getStorage();
        if (!inventoryHandler.getStoredStacks().get(0).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.75f, 0.27f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(0).m_41613_(), inventoryHandler.getSlotLimit(0), 0.02f, tile.getDrawerOptions(), tile.m_58904_());
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getStoredStacks().get(1).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.25f, 0.27f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(1).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(1).m_41613_(), inventoryHandler.getSlotLimit(1), 0.02f, tile.getDrawerOptions(), tile.m_58904_());
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getStoredStacks().get(2).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.75f, 0.77f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(2).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(2).m_41613_(), inventoryHandler.getSlotLimit(2), 0.02f, tile.getDrawerOptions(), tile.m_58904_());
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getStoredStacks().get(3).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.25f, 0.77f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(3).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(3).m_41613_(), inventoryHandler.getSlotLimit(3), 0.02f, tile.getDrawerOptions(), tile.m_58904_());
            matrixStack.m_85849_();
        }
    }

    public static void renderStack(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ItemStack stack, int amount, int maxAmount, float scale, ControllableDrawerTile.DrawerOptions options, Level level) {
        DrawerRenderer.renderIndicator(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, Math.min(1.0f, (float)amount / (float)maxAmount), options);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)Minecraft.m_91087_().f_91073_, null, 0);
        if (model.m_7539_()) {
            float thickness = (float)FunctionalStorageClientConfig.DRAWER_RENDER_THICKNESS;
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f), new Vector3f(0.75f, 0.75f, thickness)));
        } else {
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f), 0.4f));
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        if (options.isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_RENDER)) {
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, level, 0);
        }
        matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        if (!model.m_7539_()) {
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f), new Vector3f(1.25f, 1.25f, 1.0f)));
        } else {
            matrixStack.m_252931_(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f), 0.665f));
        }
        if (options.isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_NUMBERS)) {
            DrawerRenderer.renderText(matrixStack, bufferIn, combinedOverlayIn, (Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.WHITE) + NumberUtils.getFormatedBigNumber(amount))), Direction.NORTH, scale);
        }
    }

    public static void renderText(PoseStack matrix, MultiBufferSource renderer, int overlayLight, Component text, Direction side, float maxScale) {
        matrix.m_85837_(0.0, -0.745, 0.01);
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        Font font = Minecraft.m_91087_().f_91062_;
        int requiredWidth = Math.max(font.m_92852_((FormattedText)text), 1);
        Objects.requireNonNull(font);
        int requiredHeight = 9 + 2;
        float scaler = 0.4f;
        float scaleX = displayWidth / (float)requiredWidth;
        float scale = scaleX * scaler;
        if (maxScale > 0.0f) {
            scale = Math.min(scale, maxScale);
        }
        matrix.m_85841_(scale, -scale, scale);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - requiredHeight) / 2;
        font.m_272077_(text, (float)(offsetX - realWidth / 2), (float)(3 + offsetY - realHeight / 2), overlayLight, false, matrix.m_85850_().m_252922_(), renderer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

