/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;

public class IngredientCodec
implements Codec<Ingredient> {
    public static IngredientCodec INSTANCE = new IngredientCodec();
    private static Codec<List<ItemStack>> ITEM_LIST_CODEC = ItemAdapter.CODEC.listOf();

    public <T> DataResult<T> encode(Ingredient input, DynamicOps<T> ops, T prefix) {
        return ITEM_LIST_CODEC.encode(Arrays.asList(input.m_43908_()), ops, prefix);
    }

    public <T> DataResult<Pair<Ingredient, T>> decode(DynamicOps<T> ops, T input) {
        JsonElement j;
        JsonElement json = input instanceof JsonElement ? (j = (JsonElement)input) : (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input);
        try {
            return DataResult.success((Object)Pair.of((Object)CraftingHelper.getIngredient((JsonElement)json, (boolean)true), input));
        }
        catch (JsonSyntaxException ex) {
            return DataResult.error(ex::getMessage);
        }
    }
}

