/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.client.particle.forge;

import com.mojang.logging.LogUtils;
import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="architectury", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ParticleProviderRegistryImpl {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static List<Consumer<ParticleProviderRegistrar>> deferred = new ArrayList<Consumer<ParticleProviderRegistrar>>();

    private static <T extends ParticleOptions> void doRegister(ParticleProviderRegistrar registrar, ParticleType<T> type, ParticleProvider<T> provider) {
        registrar.register(type, provider);
    }

    private static <T extends ParticleOptions> void doRegister(ParticleProviderRegistrar registrar, ParticleType<T> type, ParticleProviderRegistry.DeferredParticleProvider<T> provider) {
        registrar.register(type, sprites -> provider.create(new ExtendedSpriteSetImpl(Minecraft.m_91087_().f_91061_, sprites)));
    }

    public static <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProvider<T> provider) {
        if (deferred == null) {
            LOGGER.warn("Something is attempting to register particle providers at a later point than intended! This might cause issues!", new Throwable());
            ParticleProviderRegistryImpl.doRegister(ParticleProviderRegistrar.ofFallback(), type, provider);
        } else {
            deferred.add(registrar -> ParticleProviderRegistryImpl.doRegister(registrar, type, provider));
        }
    }

    public static <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProviderRegistry.DeferredParticleProvider<T> provider) {
        if (deferred == null) {
            LOGGER.warn("Something is attempting to register particle providers at a later point than intended! This might cause issues!", new Throwable());
            ParticleProviderRegistryImpl.doRegister(ParticleProviderRegistrar.ofFallback(), type, provider);
        } else {
            deferred.add(registrar -> ParticleProviderRegistryImpl.doRegister(registrar, type, provider));
        }
    }

    @SubscribeEvent
    public static void onParticleFactoryRegister(RegisterParticleProvidersEvent event) {
        if (deferred != null) {
            ParticleProviderRegistrar registrar = ParticleProviderRegistrar.ofForge(event);
            for (Consumer<ParticleProviderRegistrar> consumer : deferred) {
                consumer.accept(registrar);
            }
            deferred = null;
        }
    }

    private static interface ParticleProviderRegistrar {
        public <T extends ParticleOptions> void register(ParticleType<T> var1, ParticleProvider<T> var2);

        public <T extends ParticleOptions> void register(ParticleType<T> var1, ParticleEngine.SpriteParticleRegistration<T> var2);

        public static ParticleProviderRegistrar ofForge(final RegisterParticleProvidersEvent event) {
            return new ParticleProviderRegistrar(){

                @Override
                public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProvider<T> provider) {
                    event.registerSpecial(type, provider);
                }

                @Override
                public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleEngine.SpriteParticleRegistration<T> registration) {
                    event.registerSpriteSet(type, registration);
                }
            };
        }

        public static ParticleProviderRegistrar ofFallback() {
            return new ParticleProviderRegistrar(){

                @Override
                public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProvider<T> provider) {
                    Minecraft.m_91087_().f_91061_.m_107381_(type, provider);
                }

                @Override
                public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleEngine.SpriteParticleRegistration<T> registration) {
                    Minecraft.m_91087_().f_91061_.m_107378_(type, registration);
                }
            };
        }
    }

    private static final class ExtendedSpriteSetImpl
    implements ParticleProviderRegistry.ExtendedSpriteSet {
        private final ParticleEngine engine;
        private final SpriteSet delegate;

        private ExtendedSpriteSetImpl(ParticleEngine engine, SpriteSet delegate) {
            this.engine = engine;
            this.delegate = delegate;
        }

        @Override
        public TextureAtlas getAtlas() {
            return this.engine.f_107296_;
        }

        @Override
        public List<TextureAtlasSprite> getSprites() {
            return ((ParticleEngine.MutableSpriteSet)this.delegate).f_107406_;
        }

        public TextureAtlasSprite m_5819_(int i, int j) {
            return this.delegate.m_5819_(i, j);
        }

        public TextureAtlasSprite m_213979_(RandomSource random) {
            return this.delegate.m_213979_(random);
        }
    }
}

