/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.util.json;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.probejs.util.json.IJsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class JObject
implements IJsonBuilder<JsonObject> {
    private final JsonObject base;
    private final Map<String, IJsonBuilder<?>> members = new HashMap();

    private JObject(JsonObject base) {
        this.base = base;
    }

    public static JObject create(JsonObject base) {
        return new JObject(base);
    }

    public static JObject create() {
        return JObject.create(new JsonObject());
    }

    public JObject ifThen(boolean condition, Consumer<JObject> action) {
        if (condition) {
            action.accept(this);
        }
        return this;
    }

    public JObject add(String key, IJsonBuilder<?> value) {
        if (value != null) {
            this.members.put(key, value);
        }
        return this;
    }

    public JObject addAll(Map<String, IJsonBuilder<?>> members) {
        members.forEach(this::add);
        return this;
    }

    public JObject addAll(Iterable<Pair<String, IJsonBuilder<?>>> members) {
        for (Pair<String, IJsonBuilder<?>> member : members) {
            if (member.getSecond() == null) continue;
            this.members.put((String)member.getFirst(), (IJsonBuilder)member.getSecond());
        }
        return this;
    }

    public JObject addAll(Stream<Pair<String, IJsonBuilder<?>>> members) {
        members.forEach(entry -> this.members.put((String)entry.getFirst(), (IJsonBuilder)entry.getSecond()));
        return this;
    }

    public JObject addAllEntry(Stream<Map.Entry<String, IJsonBuilder<?>>> members) {
        members.forEach(entry -> this.members.put((String)entry.getKey(), (IJsonBuilder)entry.getValue()));
        return this;
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = this.base;
        for (Map.Entry<String, IJsonBuilder<?>> entry : this.members.entrySet()) {
            String key = entry.getKey();
            IJsonBuilder<?> value = entry.getValue();
            object.add(key, value.serialize());
        }
        return object;
    }

    public String toString() {
        return this.serialize().toString();
    }
}

