/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.specials.special.recipe.component;

import com.probejs.docs.formatter.formatter.IFormatter;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.property.PropertyComment;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.jdoc.property.PropertyValue;
import com.probejs.specials.special.recipe.component.ComponentConverter;
import com.probejs.util.RLHelper;
import com.probejs.util.Util;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.TagKeyComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FormatterRecipeKey
implements IFormatter {
    private final RecipeKey<?> key;

    public FormatterRecipeKey(RecipeKey<?> key) {
        this.key = key;
    }

    public IFormatter getBuilder() {
        String methodName = Util.getSafeName(this.key.preferred);
        String paramName = Util.snakeToCamelCase(methodName);
        return (indent, stepIndent) -> List.of("%s%s(%s: %s): this".formatted(" ".repeat(indent), methodName, paramName.contains("\"") ? "arg" : paramName, Serde.getTypeFormatter(ComponentConverter.fromDescription(this.key.component.constructorDescription(ComponentConverter.PROBEJS_CONTEXT))).underscored().formatFirst()));
    }

    public PropertyComment getComments(RecipeSchemaType type) {
        PropertyValue<?, ?> formatter;
        PropertyComment comment = new PropertyComment();
        ArrayList<String> hints = new ArrayList<String>();
        if (this.key.optional != null && !((formatter = Serde.getValueProperty(this.key.optional.getDefaultValue(type))) instanceof PropertyValue.FallbackValue)) {
            hints.add("defaults to `%s`".formatted(Objects.requireNonNull(Serde.getValueFormatter(formatter)).formatFirst()));
        }
        if (!hints.isEmpty()) {
            comment.add("@param %s %s".formatted(Util.getSafeName(this.key.preferred), String.join((CharSequence)", ", hints)));
        }
        return comment;
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        Object name = Util.getSafeName(this.key.preferred);
        PropertyType.Native type = ComponentConverter.fromDescription(this.key.component.constructorDescription(ComponentConverter.PROBEJS_CONTEXT));
        RecipeComponent recipeComponent = this.key.component;
        if (recipeComponent instanceof TagKeyComponent) {
            TagKeyComponent tagKey = (TagKeyComponent)recipeComponent;
            if (type instanceof PropertyType.Parameterized) {
                type = new PropertyType.Native("`#${Special.%sTag}`".formatted(RLHelper.finalComponentToTitle(tagKey.registry().m_135782_().m_135815_())));
            }
        }
        if (this.key.optional != null) {
            name = (String)name + "?";
        }
        return List.of("%s: %s".formatted(name, Serde.getTypeFormatter(type).underscored().formatFirst()));
    }
}

