/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.java.type.TypeInfoClass;
import com.probejs.jdoc.property.AbstractProperty;
import com.probejs.jdoc.property.PropertyType;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class PropertyValue<T extends PropertyValue<T, J>, J>
extends AbstractProperty<T> {
    public static Map<Class<?>, Function<Object, PropertyValue<?, ?>>> VALUES_REGISTRY = new HashMap();
    protected J value;

    public PropertyValue() {
    }

    public PropertyValue(J value) {
        this.value = value;
    }

    public abstract JsonElement serializeValue();

    public abstract J deserializeValue(JsonElement var1);

    public J getValue() {
        return this.value;
    }

    @Override
    public final JsonObject serialize() {
        JsonObject object = super.serialize();
        JsonElement value = this.serializeValue();
        if (value != null) {
            object.add("value", value);
        }
        return object;
    }

    @Override
    public final void deserialize(JsonObject object) {
        super.deserialize(object);
        if (object.has("value")) {
            this.value = this.deserializeValue(object.get("value"));
        }
    }

    public static <T extends PropertyValue<T, J>, J> void addValueTransformer(Class<J> clazz, Function<J, PropertyValue<T, J>> constructor) {
        VALUES_REGISTRY.put(clazz, value -> (PropertyValue)constructor.apply(value));
    }

    public static void init() {
        PropertyValue.addValueTransformer(Number.class, NumberValue::new);
        PropertyValue.addValueTransformer(Boolean.class, BooleanValue::new);
        PropertyValue.addValueTransformer(String.class, StringValue::new);
        PropertyValue.addValueTransformer(Character.class, CharacterValue::new);
        PropertyValue.addValueTransformer(Map.class, MapValue::new);
        PropertyValue.addValueTransformer(List.class, ListValue::new);
        PropertyValue.addValueTransformer(ScriptableObject.class, ObjectValue::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyValue that = (PropertyValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public static class ObjectValue
    extends PropertyValue<ObjectValue, ScriptableObject> {
        private Map<PropertyValue<?, ?>, PropertyValue<?, ?>> keyValues = new HashMap();
        private String typeName;

        public ObjectValue() {
        }

        private ObjectValue(Map<PropertyValue<?, ?>, PropertyValue<?, ?>> keyValues) {
            this.keyValues = keyValues;
        }

        public ObjectValue(ScriptableObject value) {
            super(value);
            PropertyValue<?, ?> propertyValue;
            PropertyValue<?, ?> key;
            Scriptable prototype = value.getPrototype(null);
            ScriptManager manager = ServerScriptManager.getScriptManager();
            Object object = prototype.get(manager.context, "constructor", prototype);
            if (object instanceof BaseFunction) {
                BaseFunction fun = (BaseFunction)object;
                this.typeName = fun.getFunctionName();
                if (!this.typeName.isEmpty() && this.typeName.equals("Object")) {
                    return;
                }
            }
            for (Object id : value.getIds(null)) {
                key = Serde.getValueProperty(id);
                propertyValue = Serde.getValueProperty(value.get(manager.context, key));
                this.keyValues.put(key, propertyValue);
            }
            for (Object id : prototype.getIds(null)) {
                key = Serde.getValueProperty(id);
                propertyValue = Serde.getValueProperty(value.get(manager.context, key));
                this.keyValues.put(key, propertyValue);
            }
        }

        @Override
        public ObjectValue copy() {
            return new ObjectValue(this.keyValues);
        }

        @Override
        public JsonElement serializeValue() {
            JsonObject object = new JsonObject();
            JsonArray keyValuePairs = new JsonArray();
            for (Map.Entry<PropertyValue<?, ?>, PropertyValue<?, ?>> entry : this.keyValues.entrySet()) {
                PropertyValue<?, ?> key = entry.getKey();
                PropertyValue<?, ?> memberValue = entry.getValue();
                JsonObject pair = new JsonObject();
                pair.add("key", (JsonElement)key.serialize());
                pair.add("value", (JsonElement)memberValue.serialize());
                keyValuePairs.add((JsonElement)pair);
            }
            if (!this.keyValues.isEmpty()) {
                object.add("members", (JsonElement)keyValuePairs);
            }
            if (this.typeName != null) {
                object.addProperty("typeName", this.typeName);
            }
            return object;
        }

        @Override
        public ScriptableObject deserializeValue(JsonElement value) {
            JsonObject object = value.getAsJsonObject();
            if (object.has("members")) {
                for (JsonElement element : object.get("members").getAsJsonArray()) {
                    PropertyValue key = (PropertyValue)Serde.deserializeProperty(element.getAsJsonObject().get("key").getAsJsonObject());
                    PropertyValue memberValue = (PropertyValue)Serde.deserializeProperty(element.getAsJsonObject().get("value").getAsJsonObject());
                    this.keyValues.put(key, memberValue);
                }
            }
            if (object.has("typeName")) {
                this.typeName = object.get("typeName").getAsString();
            }
            return null;
        }

        public Map<PropertyValue<?, ?>, PropertyValue<?, ?>> getKeyValues() {
            return this.keyValues;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    public static class ListValue
    extends PropertyValue<ListValue, List<?>> {
        public ListValue() {
        }

        public ListValue(List<?> value) {
            super(value);
        }

        @Override
        public JsonElement serializeValue() {
            JsonArray array = new JsonArray();
            ((List)this.value).forEach(v -> array.add((JsonElement)Serde.getValueProperty(v).serialize()));
            return array;
        }

        @Override
        public List<?> deserializeValue(JsonElement value) {
            ArrayList values = new ArrayList();
            for (JsonElement element : value.getAsJsonArray()) {
                PropertyValue valueProperty = (PropertyValue)Serde.deserializeProperty(element.getAsJsonObject());
                if (valueProperty == null) continue;
                values.add(valueProperty.value);
            }
            return values;
        }

        @Override
        public ListValue copy() {
            return new ListValue((List)this.value);
        }
    }

    public static class MapValue
    extends PropertyValue<MapValue, Map<?, ?>> {
        public MapValue() {
        }

        public MapValue(Map<?, ?> value) {
            super(value);
        }

        @Override
        public JsonElement serializeValue() {
            JsonArray array = new JsonArray();
            for (Map.Entry entry : ((Map)this.value).entrySet()) {
                PropertyValue<?, ?> keyObj = Serde.getValueProperty(entry.getKey());
                PropertyValue<?, ?> valueObj = Serde.getValueProperty(entry.getValue());
                JsonObject object = new JsonObject();
                object.add("key", (JsonElement)keyObj.serialize());
                object.add("value", (JsonElement)valueObj.serialize());
                array.add((JsonElement)object);
            }
            return array;
        }

        @Override
        public Map<?, ?> deserializeValue(JsonElement value) {
            HashMap map = new HashMap();
            for (JsonElement element : value.getAsJsonArray()) {
                JsonObject keyValue = element.getAsJsonObject();
                PropertyValue keyProperty = (PropertyValue)Serde.deserializeProperty(keyValue.get("key").getAsJsonObject());
                PropertyValue valueProperty = (PropertyValue)Serde.deserializeProperty(keyValue.get("value").getAsJsonObject());
                if (keyProperty == null || valueProperty == null) continue;
                map.put(keyProperty.value, valueProperty.value);
            }
            return map;
        }

        @Override
        public MapValue copy() {
            return new MapValue((Map)this.value);
        }
    }

    public static class NullValue
    extends PropertyValue<NullValue, Object> {
        @Override
        public NullValue copy() {
            return new NullValue();
        }

        @Override
        public JsonElement serializeValue() {
            return new JsonPrimitive("null");
        }

        @Override
        public Object deserializeValue(JsonElement value) {
            return null;
        }
    }

    public static class FallbackValue
    extends PropertyValue<FallbackValue, Object> {
        public FallbackValue() {
        }

        public FallbackValue(Object value) {
            super(value);
            if (!(value instanceof PropertyType)) {
                this.value = Serde.deserializeFromJavaType(new TypeInfoClass(value.getClass()));
            }
        }

        public PropertyType<?> getType() {
            return (PropertyType)this.value;
        }

        @Override
        public JsonElement serializeValue() {
            return this.getType().serialize();
        }

        @Override
        public Object deserializeValue(JsonElement value) {
            return Serde.deserializeProperty(value.getAsJsonObject());
        }

        @Override
        public FallbackValue copy() {
            return new FallbackValue(this.value);
        }
    }

    public static class CharacterValue
    extends PropertyValue<CharacterValue, Character> {
        public CharacterValue() {
        }

        public CharacterValue(Character value) {
            super(value);
        }

        @Override
        public JsonElement serializeValue() {
            return new JsonPrimitive((Character)this.value);
        }

        @Override
        public Character deserializeValue(JsonElement value) {
            return Character.valueOf(value.getAsString().charAt(0));
        }

        @Override
        public CharacterValue copy() {
            return new CharacterValue((Character)this.value);
        }
    }

    public static class StringValue
    extends PropertyValue<StringValue, String> {
        public StringValue() {
        }

        public StringValue(String value) {
            super(value);
        }

        @Override
        public JsonElement serializeValue() {
            return new JsonPrimitive((String)this.value);
        }

        @Override
        public String deserializeValue(JsonElement value) {
            return value.getAsString();
        }

        @Override
        public StringValue copy() {
            return new StringValue((String)this.value);
        }
    }

    public static class BooleanValue
    extends PropertyValue<BooleanValue, Boolean> {
        public BooleanValue() {
        }

        public BooleanValue(Boolean value) {
            super(value);
        }

        @Override
        public JsonElement serializeValue() {
            return new JsonPrimitive((Boolean)this.value);
        }

        @Override
        public Boolean deserializeValue(JsonElement value) {
            return value.getAsBoolean();
        }

        @Override
        public BooleanValue copy() {
            return new BooleanValue((Boolean)this.value);
        }
    }

    public static class NumberValue
    extends PropertyValue<NumberValue, Number> {
        public NumberValue() {
        }

        public NumberValue(Number value) {
            super(value);
        }

        @Override
        public JsonElement serializeValue() {
            return new JsonPrimitive((Number)this.value);
        }

        @Override
        public Integer deserializeValue(JsonElement value) {
            return value.getAsInt();
        }

        @Override
        public NumberValue copy() {
            return new NumberValue((Number)this.value);
        }
    }
}

