/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.java.type;

import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.InfoTypeResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TypeInfoParameterized
implements ITypeInfo {
    private ITypeInfo rawType;
    private List<ITypeInfo> paramTypes;

    public static boolean test(Type type) {
        return type instanceof ParameterizedType;
    }

    public TypeInfoParameterized(Type type, Function<Type, Type> typeTransformer) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parType = (ParameterizedType)type;
            this.rawType = InfoTypeResolver.resolveType(parType.getRawType(), typeTransformer);
            this.paramTypes = Arrays.stream(parType.getActualTypeArguments()).map(param -> InfoTypeResolver.resolveType(param, typeTransformer)).collect(Collectors.toList());
        }
    }

    public TypeInfoParameterized(ITypeInfo rawType, List<ITypeInfo> paramTypes) {
        this.rawType = rawType;
        this.paramTypes = paramTypes;
    }

    @Override
    public ITypeInfo getBaseType() {
        return this.rawType;
    }

    @Override
    public Class<?> getResolvedClass() {
        return this.rawType.getResolvedClass();
    }

    public List<ITypeInfo> getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public String getTypeName() {
        return this.rawType.getTypeName() + "<%s>".formatted(this.paramTypes.stream().map(ITypeInfo::getTypeName).collect(Collectors.joining(", ")));
    }

    @Override
    public ITypeInfo copy() {
        return new TypeInfoParameterized(this.rawType.copy(), this.paramTypes.stream().map(ITypeInfo::copy).collect(Collectors.toList()));
    }

    @Override
    public boolean assignableFrom(ITypeInfo info) {
        if (info instanceof TypeInfoParameterized) {
            TypeInfoParameterized parType = (TypeInfoParameterized)info;
            if (parType.rawType.assignableFrom(this.rawType) && parType.paramTypes.size() == this.paramTypes.size()) {
                for (int i = 0; i < this.paramTypes.size(); ++i) {
                    if (parType.paramTypes.get(i).assignableFrom(this.paramTypes.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equalsTo(ITypeInfo info) {
        if (info instanceof TypeInfoParameterized) {
            TypeInfoParameterized parameterized = (TypeInfoParameterized)info;
            if (parameterized.rawType.equalsTo(this.rawType) && parameterized.paramTypes.size() == this.paramTypes.size()) {
                for (int i = 0; i < this.paramTypes.size(); ++i) {
                    if (parameterized.paramTypes.get(i).equalsTo(this.paramTypes.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void setParamTypes(List<ITypeInfo> paramTypes) {
        this.paramTypes = paramTypes;
    }

    public void setRawType(ITypeInfo rawType) {
        this.rawType = rawType;
    }

    @Override
    public String getExplicitName() {
        return this.getBaseType().getExplicitName();
    }
}

