/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.features.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.ProbeJS;
import com.probejs.ProbeJSEvents;
import com.probejs.features.server.Commands;
import java.net.InetSocketAddress;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class Server
extends WebSocketServer {
    public Server(int port) {
        super(new InetSocketAddress(port));
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
    }

    public void onMessage(WebSocket conn, String message) {
        Commands.Payload payload = (Commands.Payload)ProbeJS.GSON.fromJson(message, Commands.Payload.class);
        JsonObject response = new JsonObject();
        ProbeJSEvents.CURRENT_SERVER.execute(() -> {
            try {
                JsonElement result = Commands.process(payload);
                response.addProperty("flag", "success");
                response.add("result", result);
            }
            catch (Throwable e) {
                response.addProperty("flag", "error");
                response.addProperty("error", e.getMessage());
            }
            response.addProperty("id", payload.id);
            conn.send(ProbeJS.GSON.toJson((JsonElement)response));
        });
    }

    public void onError(WebSocket conn, Exception ex) {
    }

    public void onStart() {
    }
}

