/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.features.rich;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.probejs.util.PlatformSpecial;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

public class ImageHelper {
    private static Matrix4f createTranslateMatrix(float x, float y, float z) {
        return new Matrix4f().m00(1.0f).m11(1.0f).m22(1.0f).m33(1.0f).m03(x).m13(y).m23(z);
    }

    public static RenderTarget init() {
        TextureTarget frameBuffer = new TextureTarget(32, 32, true, false);
        frameBuffer.m_83956_();
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)frameBuffer.f_83915_, (int)frameBuffer.f_83916_, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        return frameBuffer;
    }

    public static NativeImage getFromItem(ItemStack stack, RenderTarget fbo) {
        fbo.m_83947_(true);
        ImageHelper.renderItem(stack);
        NativeImage image = ImageHelper.fromRenderTarget(fbo);
        fbo.m_83970_();
        return image;
    }

    public static NativeImage getFromFluid(Fluid fluid, RenderTarget fbo) {
        fbo.m_83947_(true);
        ImageHelper.renderFluid(fluid);
        NativeImage image = ImageHelper.fromRenderTarget(fbo);
        fbo.m_83970_();
        return image;
    }

    public static NativeImage fromRenderTarget(RenderTarget frame) {
        NativeImage img = new NativeImage(frame.f_83915_, frame.f_83916_, false);
        RenderSystem.bindTexture((int)frame.m_83975_());
        img.m_85045_(0, false);
        img.m_85122_();
        return img;
    }

    public static GuiGraphics createGuiGraphics() {
        Minecraft mc = Minecraft.m_91087_();
        return new GuiGraphics(mc, mc.m_91269_().m_110104_());
    }

    public static void renderItem(ItemStack itemStack) {
        GuiGraphics graphics = ImageHelper.createGuiGraphics();
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, null, null, 0);
        ImageHelper.renderGuiItem(graphics.m_280168_(), itemStack, 0, 0, model);
    }

    public static void renderFluid(Fluid fluid) {
        Matrix4f backup;
        TextureAtlasSprite sprite = PlatformSpecial.INSTANCE.get().getFluidSprite(fluid);
        if (sprite == null) {
            return;
        }
        VertexSorting sorting = RenderSystem.getVertexSorting();
        try {
            backup = (Matrix4f)RenderSystem.getProjectionMatrix().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        Matrix4f projection = new Matrix4f().setOrtho(0.0f, 16.0f, 0.0f, 16.0f, -150.0f, 150.0f);
        Matrix4f modelView = ImageHelper.createTranslateMatrix(1.0E-4f, 1.0E-4f, 0.0f);
        projection.mul((Matrix4fc)modelView);
        RenderSystem.setProjectionMatrix((Matrix4f)projection, (VertexSorting)sorting);
        ImageHelper.renderFluidSprite(sprite);
        RenderSystem.setProjectionMatrix((Matrix4f)backup, (VertexSorting)sorting);
    }

    public static void renderFluidSprite(TextureAtlasSprite sprite) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        PoseStack matrices = RenderSystem.getModelViewStack();
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_5752_();
        buffer.m_252986_(matrix, 16.0f, 16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_5752_();
        buffer.m_252986_(matrix, 16.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_5752_();
        tesselator.m_85914_();
    }

    public static void renderGuiItem(PoseStack poseStack, ItemStack itemStack, int i, int j, BakedModel bakedModel) {
        boolean flag;
        float scale = 1.0f;
        poseStack.m_85836_();
        poseStack.m_85841_(scale / 16.0f, scale / 16.0f, 1.0f);
        poseStack.m_252880_((float)i, (float)j, 100.0f);
        poseStack.m_252880_(8.0f, 8.0f, 0.0f);
        poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !bakedModel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        PoseStack poseStack1 = RenderSystem.getModelViewStack();
        poseStack1.m_85836_();
        poseStack1.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        Minecraft.m_91087_().m_91291_().m_115143_(itemStack, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        poseStack1.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }
}

