/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.features.repl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.probejs.features.repl.Evaluator;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Undefined;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class EvalManager {
    public static EvalManager STARTUP_SCRIPTS = new EvalManager(KubeJS::getStartupScriptManager);
    public static EvalManager CLIENT_SCRIPTS = new EvalManager(KubeJS::getClientScriptManager);
    public static EvalManager SERVER_SCRIPTS = new EvalManager(ServerScriptManager::getScriptManager);
    private final Map<String, Evaluator> scriptPacks = new HashMap<String, Evaluator>();
    private Supplier<ScriptManager> scriptManager;
    private boolean loaded = false;

    public static JsonElement jsToJson(Context context, Object obj) {
        obj = context == null ? obj : Context.jsToJava((Context)context, (Object)obj, Object.class);
        return EvalManager.jsToJsonInternal(context, obj, true);
    }

    private static JsonElement jsToJsonInternal(Context context, Object obj, boolean deep) {
        JsonObject jsonObject;
        if (obj == null) {
            return JsonNull.INSTANCE;
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return new JsonPrimitive(number);
        }
        if (obj instanceof String) {
            String string = (String)obj;
            return new JsonPrimitive(string);
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return new JsonPrimitive(bool);
        }
        if (Undefined.isUndefined((Object)obj)) {
            return new JsonPrimitive("$$ProbeJS$$undefined$$ProbeJS$$");
        }
        if (obj.getClass().isArray()) {
            Object[] arrayObject = (Object[])obj;
            obj = Arrays.asList(arrayObject);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            JsonArray array = new JsonArray(list.size());
            for (Object o : list) {
                array.add(EvalManager.jsToJsonInternal(context, o, deep));
            }
            return array;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            jsonObject = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                jsonObject.add(key.toString(), EvalManager.jsToJsonInternal(context, value, deep));
            }
        }
        if (deep && obj instanceof BaseFunction) {
            return new JsonPrimitive("$$ProbeJS$$Function$$ProbeJS$$");
        }
        if (obj instanceof NativeJavaObject) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)obj;
            if (deep) {
                jsonObject = new JsonObject();
                for (Object id : nativeJavaObject.getIds(context)) {
                    String idString;
                    Object property;
                    if (!(id instanceof String) || (property = nativeJavaObject.get(context, idString = (String)id, (Scriptable)nativeJavaObject)) instanceof BaseFunction) continue;
                    jsonObject.add(idString, EvalManager.jsToJsonInternal(context, property, false));
                }
                return jsonObject;
            }
            obj = nativeJavaObject.unwrap();
        }
        if (obj instanceof ScriptableObject) {
            ScriptableObject scriptable = (ScriptableObject)obj;
            if (!(obj instanceof BaseFunction)) {
                jsonObject = new JsonObject();
                for (Object id : scriptable.getIds(context)) {
                    if (!(id instanceof String)) continue;
                    String idString = (String)id;
                    jsonObject.add(idString, EvalManager.jsToJsonInternal(context, scriptable.get(context, idString, (Scriptable)scriptable), false));
                }
                return jsonObject;
            }
        }
        return new JsonPrimitive("$$ProbeJS$$%s$$ProbeJS$$".formatted(obj.toString()));
    }

    private EvalManager(Supplier<ScriptManager> manager) {
        this.scriptManager = manager;
    }

    private static EvalManager getManager(String type) {
        return switch (type) {
            case "startup_scripts" -> STARTUP_SCRIPTS;
            case "client_scripts" -> CLIENT_SCRIPTS;
            case "server_scripts" -> SERVER_SCRIPTS;
            default -> throw new RuntimeException("Unknown script manager %s.".formatted(type));
        };
    }

    public static JsonElement evaluate(JsonObject payload) {
        String type = payload.get("type").getAsString();
        String pack = payload.get("pack").getAsString();
        String input = payload.get("input").getAsString();
        EvalManager manager = EvalManager.getManager(type);
        Evaluator evaluator = manager.getEvaluator(pack);
        return EvalManager.jsToJson(evaluator.getContext(), evaluator.evaluate(input));
    }

    public static JsonElement getPacks(JsonObject payload) {
        String type = payload.get("type").getAsString();
        return EvalManager.jsToJson(null, EvalManager.getManager(type).getScriptPacks());
    }

    public static JsonElement getGlobals(JsonObject payload) {
        String type = payload.get("type").getAsString();
        String pack = payload.get("pack").getAsString();
        return EvalManager.jsToJson(null, EvalManager.getManager(type).getEvaluator(pack).getTopLevelVariables());
    }

    private void tryLoad() {
        if (!this.loaded) {
            ScriptManager manager = this.scriptManager.get();
            if (manager == null) {
                throw new RuntimeException("Script manager is not loaded yet.");
            }
            manager.packs.forEach((s, scriptPack) -> this.scriptPacks.put((String)s, new Evaluator((ScriptPack)scriptPack)));
        }
    }

    public Evaluator getEvaluator(String scriptPack) {
        this.tryLoad();
        if (!this.scriptPacks.containsKey(scriptPack)) {
            throw new RuntimeException("Script pack %s not found.".formatted(scriptPack));
        }
        return this.scriptPacks.get(scriptPack);
    }

    public List<String> getScriptPacks() {
        this.tryLoad();
        return this.scriptPacks.keySet().stream().toList();
    }

    public void setScriptManager(Supplier<ScriptManager> manager) {
        this.scriptManager = manager;
        this.reset();
    }

    public void reset() {
        this.scriptPacks.clear();
        this.loaded = false;
    }
}

