/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.mixin.accessor.GameTestHelperAccessor;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CreateGameTestHelper
extends GameTestHelper {
    public static final int TICKS_PER_SECOND = 20;
    public static final int TEN_SECONDS = 200;
    public static final int FIFTEEN_SECONDS = 300;
    public static final int TWENTY_SECONDS = 400;

    private CreateGameTestHelper(GameTestInfo testInfo) {
        super(testInfo);
    }

    public static CreateGameTestHelper of(GameTestHelper original) {
        GameTestHelperAccessor access = (GameTestHelperAccessor)original;
        CreateGameTestHelper helper = new CreateGameTestHelper(access.getTestInfo());
        GameTestHelperAccessor newAccess = (GameTestHelperAccessor)((Object)helper);
        newAccess.setFinalCheckAdded(access.getFinalCheckAdded());
        return helper;
    }

    public void flipBlock(BlockPos pos) {
        BlockState original = this.m_177232_(pos);
        if (!original.m_61138_((Property)BlockStateProperties.f_61372_)) {
            this.m_177284_("FACING property not in block: " + String.valueOf(ForgeRegistries.BLOCKS.getKey((Object)original.m_60734_())));
        }
        Direction facing = (Direction)original.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockState reversed = (BlockState)original.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing.m_122424_());
        this.m_177252_(pos, reversed);
    }

    public void assertNixiePower(BlockPos pos, int strength) {
        NixieTubeBlockEntity nixie = (NixieTubeBlockEntity)this.getBlockEntity((BlockEntityType)AllBlockEntityTypes.NIXIE_TUBE.get(), pos);
        int actualStrength = nixie.getRedstoneStrength();
        if (actualStrength != strength) {
            this.m_177284_("Expected nixie tube at %s to have power of %s, got %s".formatted(pos, strength, actualStrength));
        }
    }

    public void powerLever(BlockPos pos) {
        this.m_177208_(Blocks.f_50164_, pos);
        if (!((Boolean)this.m_177232_(pos).m_61143_((Property)LeverBlock.f_54622_)).booleanValue()) {
            this.m_177421_(pos);
        }
    }

    public void unpowerLever(BlockPos pos) {
        this.m_177208_(Blocks.f_50164_, pos);
        if (((Boolean)this.m_177232_(pos).m_61143_((Property)LeverBlock.f_54622_)).booleanValue()) {
            this.m_177421_(pos);
        }
    }

    public void setTunnelMode(BlockPos pos, BrassTunnelBlockEntity.SelectionMode mode) {
        ScrollValueBehaviour behavior = (ScrollValueBehaviour)this.getBehavior(pos, ScrollOptionBehaviour.TYPE);
        behavior.setValue(mode.ordinal());
    }

    public void assertSpeedometerSpeed(BlockPos speedometer, float value) {
        SpeedGaugeBlockEntity be = (SpeedGaugeBlockEntity)this.getBlockEntity((BlockEntityType)AllBlockEntityTypes.SPEEDOMETER.get(), speedometer);
        this.assertInRange(be.getSpeed(), (double)value - 0.01, (double)value + 0.01);
    }

    public void assertStressometerCapacity(BlockPos stressometer, float value) {
        StressGaugeBlockEntity be = (StressGaugeBlockEntity)this.getBlockEntity((BlockEntityType)AllBlockEntityTypes.STRESSOMETER.get(), stressometer);
        this.assertInRange(be.getNetworkCapacity(), (double)value - 0.01, (double)value + 0.01);
    }

    public void toggleActorsOfType(Contraption contraption, ItemLike item) {
        AtomicBoolean toggled = new AtomicBoolean(false);
        contraption.getInteractors().forEach((localPos, behavior) -> {
            if (toggled.get() || !(behavior instanceof ContraptionControlsMovingInteraction)) {
                return;
            }
            ContraptionControlsMovingInteraction controls = (ContraptionControlsMovingInteraction)behavior;
            MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor = contraption.getActorAt((BlockPos)localPos);
            if (actor == null) {
                return;
            }
            ItemStack filter = ContraptionControlsMovement.getFilter((MovementContext)actor.right);
            if (filter != null && filter.m_150930_(item.m_5456_())) {
                controls.handlePlayerInteraction(this.m_177368_(), InteractionHand.MAIN_HAND, (BlockPos)localPos, contraption.entity);
                toggled.set(true);
            }
        });
    }

    public <T extends BlockEntity> T getBlockEntity(BlockEntityType<T> type, BlockPos pos) {
        BlockEntityType actualType;
        BlockEntity be = this.m_177347_(pos);
        BlockEntityType blockEntityType = actualType = be == null ? null : be.m_58903_();
        if (actualType != type) {
            String actualId = actualType == null ? "null" : CatnipServices.REGISTRIES.getKeyOrThrow(actualType).toString();
            String error = "Expected block entity at pos [%s] with type [%s], got [%s]".formatted(pos, CatnipServices.REGISTRIES.getKeyOrThrow(type), actualId);
            this.m_177284_(error);
        }
        return (T)be;
    }

    public <T extends BlockEntity> T getControllerBlockEntity(BlockEntityType<T> type, BlockPos anySegment) {
        Object be = ((IMultiBlockEntityContainer)this.getBlockEntity(type, anySegment)).getControllerBE();
        if (be == null) {
            this.m_177284_("Could not get block entity controller with type [%s] from pos [%s]".formatted(CatnipServices.REGISTRIES.getKeyOrThrow(type), anySegment));
        }
        return be;
    }

    public <T extends BlockEntityBehaviour> T getBehavior(BlockPos pos, BehaviourType<T> type) {
        T behavior = BlockEntityBehaviour.get((BlockGetter)this.m_177100_(), this.m_177449_(pos), type);
        if (behavior == null) {
            this.m_177284_("Behavior at " + String.valueOf(pos) + " missing, expected " + type.getName());
        }
        return behavior;
    }

    public ItemEntity spawnItem(BlockPos pos, ItemStack stack) {
        Vec3 spawn = Vec3.m_82512_((Vec3i)this.m_177449_(pos));
        ServerLevel level = this.m_177100_();
        ItemEntity item = new ItemEntity((Level)level, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, stack, 0.0, 0.0, 0.0);
        level.m_7967_((Entity)item);
        return item;
    }

    public void spawnItems(BlockPos pos, Item item, int amount) {
        while (amount > 0) {
            int toSpawn = Math.min(amount, item.m_41459_());
            amount -= toSpawn;
            ItemStack stack = new ItemStack((ItemLike)item, toSpawn);
            this.spawnItem(pos, stack);
        }
    }

    public <T extends Entity> T getFirstEntity(EntityType<T> type, BlockPos pos) {
        List<T> list = this.getEntitiesBetween(type, pos.m_122012_().m_122029_().m_7494_(), pos.m_122019_().m_122024_().m_7495_());
        if (list.isEmpty()) {
            this.m_177284_("No entities at pos: " + String.valueOf(pos));
        }
        return (T)((Entity)list.get(0));
    }

    public <T extends Entity> List<T> getEntitiesBetween(EntityType<T> type, BlockPos pos1, BlockPos pos2) {
        BoundingBox box = BoundingBox.m_162375_((Vec3i)this.m_177449_(pos1), (Vec3i)this.m_177449_(pos2));
        List entities = this.m_177100_().m_143280_(type, e -> box.m_71051_((Vec3i)e.m_20183_()));
        return entities;
    }

    public IFluidHandler fluidStorageAt(BlockPos pos) {
        Optional handler;
        BlockEntity be = this.m_177347_(pos);
        if (be == null) {
            this.m_177284_("BlockEntity not present");
        }
        if ((handler = be.getCapability(ForgeCapabilities.FLUID_HANDLER).resolve()).isEmpty()) {
            this.m_177284_("handler not present");
        }
        return (IFluidHandler)handler.get();
    }

    public FluidStack getTankContents(BlockPos tank) {
        IFluidHandler handler = this.fluidStorageAt(tank);
        return handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
    }

    public long getTankCapacity(BlockPos pos) {
        IFluidHandler handler = this.fluidStorageAt(pos);
        long total = 0L;
        for (int i = 0; i < handler.getTanks(); ++i) {
            total += (long)handler.getTankCapacity(i);
        }
        return total;
    }

    public long getFluidInTanks(BlockPos ... tanks) {
        long total = 0L;
        for (BlockPos tank : tanks) {
            total += (long)this.getTankContents(tank).getAmount();
        }
        return total;
    }

    public void assertFluidPresent(FluidStack fluid, BlockPos pos) {
        FluidStack contained = this.getTankContents(pos);
        if (!fluid.isFluidEqual(contained)) {
            this.m_177284_("Different fluids");
        }
        if (fluid.getAmount() != contained.getAmount()) {
            this.m_177284_("Different amounts");
        }
    }

    public void assertTankEmpty(BlockPos pos) {
        this.assertFluidPresent(FluidStack.EMPTY, pos);
    }

    public void assertTanksEmpty(BlockPos ... tanks) {
        for (BlockPos tank : tanks) {
            this.assertTankEmpty(tank);
        }
    }

    public IItemHandler itemStorageAt(BlockPos pos) {
        Optional handler;
        BlockEntity be = this.m_177347_(pos);
        if (be == null) {
            this.m_177284_("BlockEntity not present");
        }
        if ((handler = be.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve()).isEmpty()) {
            this.m_177284_("handler not present");
        }
        return (IItemHandler)handler.get();
    }

    public Object2LongMap<Item> getItemContent(BlockPos pos) {
        IItemHandler handler = this.itemStorageAt(pos);
        Object2LongArrayMap map = new Object2LongArrayMap();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            long amount = map.getLong((Object)item);
            map.put((Object)item, amount += (long)stack.m_41613_());
        }
        return map;
    }

    public long getTotalItems(BlockPos pos) {
        IItemHandler storage = this.itemStorageAt(pos);
        long total = 0L;
        for (int i = 0; i < storage.getSlots(); ++i) {
            total += (long)storage.getStackInSlot(i).m_41613_();
        }
        return total;
    }

    public void assertAnyContained(BlockPos pos, Item ... items) {
        IItemHandler handler = this.itemStorageAt(pos);
        boolean noneFound = true;
        block0: for (int i = 0; i < handler.getSlots(); ++i) {
            for (Item item : items) {
                if (!handler.getStackInSlot(i).m_150930_(item)) continue;
                noneFound = false;
                continue block0;
            }
        }
        if (noneFound) {
            this.m_177284_("No matching items " + Arrays.toString(items) + " found in handler at pos: " + String.valueOf(pos));
        }
    }

    public void assertContentPresent(Object2LongMap<Item> content, BlockPos pos) {
        IItemHandler handler = this.itemStorageAt(pos);
        Object2LongArrayMap map = new Object2LongArrayMap(content);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            long amount = map.getLong((Object)item);
            if ((amount -= (long)stack.m_41613_()) == 0L) {
                map.removeLong((Object)item);
                continue;
            }
            map.put((Object)item, amount);
        }
        if (!map.isEmpty()) {
            this.m_177284_("Storage missing content: " + String.valueOf(map));
        }
    }

    public void assertContainersEmpty(List<BlockPos> positions) {
        for (BlockPos pos : positions) {
            this.m_177440_(pos);
        }
    }

    public void m_177440_(@NotNull BlockPos pos) {
        IItemHandler storage = this.itemStorageAt(pos);
        for (int i = 0; i < storage.getSlots(); ++i) {
            if (storage.getStackInSlot(i).m_41619_()) continue;
            this.m_177284_("Storage not empty");
        }
    }

    public void assertContainerContains(BlockPos pos, ItemLike item) {
        this.m_177242_(pos, item.m_5456_());
    }

    public void m_177242_(@NotNull BlockPos pos, @NotNull Item item) {
        this.assertContainerContains(pos, new ItemStack((ItemLike)item));
    }

    public void assertContainerContains(BlockPos pos, ItemStack item) {
        IItemHandler storage = this.itemStorageAt(pos);
        ItemStack extracted = ItemHelper.extract(storage, stack -> ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)item), item.m_41613_(), true);
        if (extracted.m_41619_()) {
            this.m_177284_("item not present: " + String.valueOf(item));
        }
    }

    public void assertSecondsPassed(int seconds) {
        if (this.m_177436_() < (long)seconds * 20L) {
            this.m_177284_("Waiting for %s seconds to pass".formatted(seconds));
        }
    }

    public long secondsPassed() {
        return this.m_177436_() % 20L;
    }

    public void whenSecondsPassed(int seconds, Runnable run) {
        this.m_177306_((long)seconds * 20L, run);
    }

    public void assertCloseEnoughTo(double value, double expected) {
        this.assertInRange(value, expected - 1.0, expected + 1.0);
    }

    public void assertInRange(double value, double min, double max) {
        if (value < min) {
            this.m_177284_("Value %s below expected min of %s".formatted(value, min));
        }
        if (value > max) {
            this.m_177284_("Value %s greater than expected max of %s".formatted(value, max));
        }
    }

    @Contract(value="_->fail")
    public void m_177284_(@NotNull String exceptionMessage) {
        super.m_177284_(exceptionMessage);
    }
}

