/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.girder.GirderBlock;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;

public class TrackPaver {
    public static int paveStraight(Level level, BlockPos startPos, Vec3 direction, int extent, Block block, boolean simulate, Set<BlockPos> visited) {
        int itemsNeeded = 0;
        BlockState defaultBlockState = block.m_49966_();
        boolean slabLike = defaultBlockState.m_61138_((Property)SlabBlock.f_56353_);
        boolean wallLike = TrackPaver.isWallLike(defaultBlockState);
        if (slabLike) {
            defaultBlockState = (BlockState)defaultBlockState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
        }
        if (defaultBlockState.m_60734_() instanceof GirderBlock) {
            for (Direction d : Iterate.horizontalDirections) {
                if (!Vec3.m_82528_((Vec3i)d.m_122436_()).equals((Object)direction)) continue;
                defaultBlockState = (BlockState)((BlockState)((BlockState)((BlockState)defaultBlockState.m_61124_((Property)GirderBlock.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GirderBlock.BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_(GirderBlock.AXIS, (Comparable)d.m_122434_())).m_61124_((Property)(d.m_122434_() == Direction.Axis.X ? GirderBlock.X : GirderBlock.Z), (Comparable)Boolean.valueOf(true));
            }
        }
        HashSet<BlockPos> toPlaceOn = new HashSet<BlockPos>();
        Vec3 start = VecHelper.getCenterOf((Vec3i)startPos);
        Vec3 mainNormal = direction.m_82537_(new Vec3(0.0, 1.0, 0.0));
        Vec3 normalizedNormal = mainNormal.m_82541_();
        Vec3 normalizedDirection = direction.m_82541_();
        float diagFiller = 0.45f;
        for (int i = 0; i < extent; ++i) {
            Vec3 offset = direction.m_82490_((double)i);
            Vec3 mainPos = start.m_82520_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            toPlaceOn.add(BlockPos.m_274446_((Position)mainPos.m_82549_(mainNormal)));
            toPlaceOn.add(BlockPos.m_274446_((Position)mainPos.m_82546_(mainNormal)));
            if (wallLike) continue;
            toPlaceOn.add(BlockPos.m_274446_((Position)mainPos));
            if (i < extent - 1) {
                for (int x : Iterate.positiveAndNegative) {
                    toPlaceOn.add(BlockPos.m_274446_((Position)mainPos.m_82549_(normalizedNormal.m_82490_((double)((float)x * diagFiller))).m_82549_(normalizedDirection.m_82490_((double)diagFiller))));
                }
            }
            if (i <= 0) continue;
            for (int x : Iterate.positiveAndNegative) {
                toPlaceOn.add(BlockPos.m_274446_((Position)mainPos.m_82549_(normalizedNormal.m_82490_((double)((float)x * diagFiller))).m_82549_(normalizedDirection.m_82490_((double)(-diagFiller)))));
            }
        }
        BlockState state = defaultBlockState;
        for (BlockPos p : toPlaceOn) {
            if (!visited.add(p) || !TrackPaver.placeBlockIfFree(level, p, state, simulate)) continue;
            itemsNeeded += slabLike ? 2 : 1;
        }
        visited.addAll(toPlaceOn);
        return itemsNeeded;
    }

    public static int paveCurve(Level level, BezierConnection bc, Block block, boolean simulate, Set<BlockPos> visited) {
        int itemsNeeded = 0;
        BlockState defaultBlockState = block.m_49966_();
        boolean slabLike = defaultBlockState.m_61138_((Property)SlabBlock.f_56353_);
        if (slabLike) {
            defaultBlockState = (BlockState)defaultBlockState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
        }
        if (TrackPaver.isWallLike(defaultBlockState)) {
            if (AllBlocks.METAL_GIRDER.has(defaultBlockState)) {
                return (bc.getSegmentCount() + 1) / 2 * 2;
            }
            return 0;
        }
        HashMap<Pair, Double> yLevels = new HashMap<Pair, Double>();
        BlockPos tePosition = (BlockPos)bc.bePositions.getFirst();
        Vec3 end1 = ((Vec3)bc.starts.getFirst()).m_82546_(Vec3.m_82528_((Vec3i)tePosition)).m_82520_(0.0, 0.1875, 0.0);
        Vec3 end2 = ((Vec3)bc.starts.getSecond()).m_82546_(Vec3.m_82528_((Vec3i)tePosition)).m_82520_(0.0, 0.1875, 0.0);
        Vec3 axis1 = (Vec3)bc.axes.getFirst();
        Vec3 axis2 = (Vec3)bc.axes.getSecond();
        double handleLength = bc.getHandleLength();
        Vec3 finish1 = axis1.m_82490_(handleLength).m_82549_(end1);
        Vec3 finish2 = axis2.m_82490_(handleLength).m_82549_(end2);
        Vec3 faceNormal1 = (Vec3)bc.normals.getFirst();
        Vec3 faceNormal2 = (Vec3)bc.normals.getSecond();
        int segCount = bc.getSegmentCount();
        float[] lut = bc.getStepLUT();
        for (int i = 0; i < segCount; ++i) {
            float t = i == segCount ? 1.0f : (float)i * lut[i] / (float)segCount;
            Vec3 result = VecHelper.bezier((Vec3)end1, (Vec3)end2, (Vec3)finish1, (Vec3)finish2, (float)(t += 0.5f / (float)segCount));
            Vec3 derivative = VecHelper.bezierDerivative((Vec3)end1, (Vec3)end2, (Vec3)finish1, (Vec3)finish2, (float)t).m_82541_();
            Vec3 faceNormal = faceNormal1.equals((Object)faceNormal2) ? faceNormal1 : VecHelper.slerp((float)t, (Vec3)faceNormal1, (Vec3)faceNormal2);
            Vec3 normal = faceNormal.m_82537_(derivative).m_82541_();
            Vec3 below = result.m_82549_(faceNormal.m_82490_(-1.125));
            Vec3 rail1 = below.m_82549_(normal.m_82490_((double)0.97f));
            Vec3 rail2 = below.m_82546_(normal.m_82490_((double)0.97f));
            Vec3 railMiddle = rail1.m_82549_(rail2).m_82490_(0.5);
            for (Vec3 vec : new Vec3[]{rail1, rail2, railMiddle}) {
                BlockPos pos = BlockPos.m_274446_((Position)vec);
                Pair key = Pair.of((Object)pos.m_123341_(), (Object)pos.m_123343_());
                if (yLevels.containsKey(key) && !((Double)yLevels.get(key) > vec.f_82480_)) continue;
                yLevels.put(key, vec.f_82480_);
            }
        }
        for (Map.Entry entry : yLevels.entrySet()) {
            BlockState stateToPlace;
            double yValue = (Double)entry.getValue();
            int floor = Mth.m_14107_((double)yValue);
            boolean placeSlab = slabLike && yValue - (double)floor >= 0.5;
            BlockPos targetPos = new BlockPos(((Integer)((Pair)entry.getKey()).getFirst()).intValue(), floor, ((Integer)((Pair)entry.getKey()).getSecond()).intValue());
            targetPos = targetPos.m_121955_((Vec3i)tePosition).m_6630_(placeSlab ? 1 : 0);
            BlockState blockState = stateToPlace = placeSlab ? (BlockState)defaultBlockState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM) : defaultBlockState;
            if (!visited.add(targetPos)) continue;
            if (TrackPaver.placeBlockIfFree(level, targetPos, stateToPlace, simulate)) {
                itemsNeeded += !placeSlab ? 2 : 1;
            }
            if (!placeSlab || !visited.add(targetPos.m_7495_())) continue;
            BlockState topSlab = (BlockState)stateToPlace.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
            if (!TrackPaver.placeBlockIfFree(level, targetPos.m_7495_(), topSlab, simulate)) continue;
            ++itemsNeeded;
        }
        return itemsNeeded;
    }

    private static boolean isWallLike(BlockState defaultBlockState) {
        return defaultBlockState.m_60734_() instanceof WallBlock || AllBlocks.METAL_GIRDER.has(defaultBlockState);
    }

    private static boolean placeBlockIfFree(Level level, BlockPos pos, BlockState state, boolean simulate) {
        BlockState stateAtPos = level.m_8055_(pos);
        if (stateAtPos.m_60734_() != state.m_60734_() && stateAtPos.m_247087_()) {
            if (!simulate) {
                level.m_7731_(pos, ProperWaterloggedBlock.withWater((LevelAccessor)level, state, pos), 3);
            }
            return true;
        }
        return false;
    }
}

