/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.CargoThresholdCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class FluidThresholdCondition
extends CargoThresholdCondition {
    private FilterItemStack compareStack = FilterItemStack.empty();

    @Override
    protected Component getUnit() {
        return Component.m_237113_((String)"b");
    }

    @Override
    protected ItemStack getIcon() {
        return this.compareStack.item();
    }

    @Override
    protected boolean test(Level level, Train train, CompoundTag context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        int target = this.getThreshold();
        int foundFluid = 0;
        for (Carriage carriage : train.carriages) {
            MountedFluidStorageWrapper fluids = carriage.storage.getFluids();
            for (int i = 0; i < fluids.getTanks(); ++i) {
                FluidStack fluidInTank = fluids.getFluidInTank(i);
                if (!this.compareStack.test(level, fluidInTank)) continue;
                foundFluid += fluidInTank.getAmount();
            }
        }
        this.requestStatusToUpdate(foundFluid / 1000, context);
        return operator.test(foundFluid, target * 1000);
    }

    @Override
    protected void writeAdditional(CompoundTag tag) {
        super.writeAdditional(tag);
        tag.m_128365_("Bucket", (Tag)this.compareStack.serializeNBT());
    }

    @Override
    protected void readAdditional(CompoundTag tag) {
        super.readAdditional(tag);
        if (tag.m_128441_("Bucket")) {
            this.compareStack = FilterItemStack.of(tag.m_128469_("Bucket"));
        }
    }

    @Override
    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        return super.tickCompletion(level, train, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    private FluidStack loadFluid() {
        return this.compareStack.fluid((Level)Minecraft.m_91087_().f_91073_);
    }

    @Override
    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule.condition.threshold.train_holds", CreateLang.translateDirect("schedule.condition.threshold." + Lang.asId((String)this.getOperator().name()), new Object[0])), (Object)CreateLang.translateDirect("schedule.condition.threshold.x_units_of_item", this.getThreshold(), CreateLang.translateDirect("schedule.condition.threshold.buckets", new Object[0]), this.compareStack.isEmpty() ? CreateLang.translateDirect("schedule.condition.threshold.anything", new Object[0]) : (this.compareStack.isFilterItem() ? CreateLang.translateDirect("schedule.condition.threshold.matching_content", new Object[0]) : this.loadFluid().getDisplayName())).m_130940_(ChatFormatting.DARK_AQUA));
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.compareStack = FilterItemStack.of(stack);
    }

    @Override
    public ItemStack getItem(int slot) {
        return this.compareStack.item();
    }

    @Override
    public ResourceLocation getId() {
        return Create.asResource("fluid_threshold");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List<? extends Component>)ImmutableList.of((Object)CreateLang.translateDirect("schedule.condition.threshold.buckets", new Object[0]))).titled(null), "Measure");
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        int lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1) {
            return Component.m_237119_();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return CreateLang.translateDirect("schedule.condition.threshold.status", lastDisplaySnapshot, Math.max(0, this.getThreshold() + offset), CreateLang.translateDirect("schedule.condition.threshold.buckets", new Object[0]));
    }
}

