/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.display;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTickAccess;

public class FlapDisplayBlock
extends HorizontalKineticBlock
implements IBE<FlapDisplayBlockEntity>,
IWrenchable,
ICogWheel,
SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public FlapDisplayBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{UP, DOWN, BlockStateProperties.f_61362_}));
    }

    @Override
    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.MEDIUM;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        BlockPos clickedPos = context.m_8083_();
        BlockPos placedOnPos = clickedPos.m_121945_(face.m_122424_());
        Level level = context.m_43725_();
        BlockState blockState = level.m_8055_(placedOnPos);
        BlockState stateForPlacement = this.m_49966_();
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (blockState.m_60734_() != this || context.m_43723_() != null && context.m_43723_().m_6144_()) {
            stateForPlacement = super.m_5573_(context);
        } else {
            Direction otherFacing = (Direction)blockState.m_61143_(HORIZONTAL_FACING);
            stateForPlacement = (BlockState)stateForPlacement.m_61124_(HORIZONTAL_FACING, (Comparable)otherFacing);
        }
        return this.updateColumn(level, clickedPos, (BlockState)stateForPlacement.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_)), true);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        String tagElement;
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        FlapDisplayBlockEntity flapBE = (FlapDisplayBlockEntity)this.getBlockEntity((BlockGetter)world, pos);
        if (flapBE == null) {
            return InteractionResult.PASS;
        }
        if ((flapBE = flapBE.getController()) == null) {
            return InteractionResult.PASS;
        }
        double yCoord = ray.m_82450_().m_82549_((Vec3)Vec3.m_82528_((Vec3i)ray.m_82434_().m_122424_().m_122436_()).m_82490_((double)0.125)).f_82480_;
        int lineIndex = flapBE.getLineIndexAt(yCoord);
        if (heldItem.m_41619_()) {
            if (!flapBE.isSpeedRequirementFulfilled()) {
                return InteractionResult.PASS;
            }
            flapBE.applyTextManually(lineIndex, null);
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41720_() == Items.f_151056_) {
            if (!world.f_46443_) {
                world.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                flapBE.setGlowing(lineIndex);
            }
            return InteractionResult.SUCCESS;
        }
        boolean display = heldItem.m_41720_() == Items.f_42656_ && heldItem.m_41788_() || AllBlocks.CLIPBOARD.isIn(heldItem);
        DyeColor dye = DyeColor.getColor((ItemStack)heldItem);
        if (!display && dye == null) {
            return InteractionResult.PASS;
        }
        if (dye == null && !flapBE.isSpeedRequirementFulfilled()) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = heldItem.m_41737_("display");
        String string = tagElement = tag != null && tag.m_128425_("Name", 8) ? tag.m_128461_("Name") : null;
        if (display) {
            if (AllBlocks.CLIPBOARD.isIn(heldItem)) {
                List<ClipboardEntry> entries = ClipboardEntry.getLastViewedEntries(heldItem);
                int line = lineIndex;
                for (ClipboardEntry entry : entries) {
                    for (String string2 : entry.text.getString().split("\n")) {
                        flapBE.applyTextManually(line++, Component.Serializer.m_130703_((Component)Component.m_237113_((String)string2)));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            flapBE.applyTextManually(lineIndex, tagElement);
        }
        if (dye != null) {
            world.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
            flapBE.setColour(lineIndex, dye);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.FLAP_DISPLAY.get((Direction)pState.m_61143_(HORIZONTAL_FACING));
    }

    @Override
    public Class<FlapDisplayBlockEntity> getBlockEntityClass() {
        return FlapDisplayBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends FlapDisplayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.FLAP_DISPLAY.get();
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.85f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.75f;
    }

    private BlockState updateColumn(Level level, BlockPos pos, BlockState state, boolean present) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        Direction.Axis axis = this.getConnectionAxis(state);
        for (Direction connection : Iterate.directionsInAxis((Direction.Axis)Direction.Axis.Y)) {
            boolean connect = true;
            block1: for (Direction movement : Iterate.directionsInAxis((Direction.Axis)axis)) {
                currentPos.m_122190_((Vec3i)pos);
                for (int i = 0; i < 1000 && level.m_46749_((BlockPos)currentPos); ++i) {
                    BlockState other1 = currentPos.equals((Object)pos) ? state : level.m_8055_((BlockPos)currentPos);
                    BlockState other2 = level.m_8055_(currentPos.m_121945_(connection));
                    boolean col1 = this.canConnect(state, other1);
                    boolean col2 = this.canConnect(state, other2);
                    currentPos.m_122173_(movement);
                    if (!col1 && !col2) continue block1;
                    if (col1 && col2) continue;
                    connect = false;
                    break block1;
                }
            }
            state = FlapDisplayBlock.setConnection(state, connection, connect);
        }
        return state;
    }

    @Override
    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (pOldState.m_60734_() == this) {
            return;
        }
        LevelTickAccess blockTicks = pLevel.m_183326_();
        if (!blockTicks.m_183582_(pPos, (Object)this)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pState.m_60734_() != this) {
            return;
        }
        BlockPos belowPos = pPos.m_121945_(Direction.m_122387_((Direction.Axis)this.getConnectionAxis(pState), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
        BlockState belowState = pLevel.m_8055_(belowPos);
        if (!this.canConnect(pState, belowState)) {
            KineticBlockEntity.switchToBlockState((Level)pLevel, pPos, this.updateColumn((Level)pLevel, pPos, pState, true));
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, FlapDisplayBlockEntity::updateControllerStatus);
    }

    public BlockState m_7417_(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return this.updatedShapeInner(state, pDirection, pNeighborState, pLevel, pCurrentPos);
    }

    private BlockState updatedShapeInner(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (!this.canConnect(state, pNeighborState)) {
            return FlapDisplayBlock.setConnection(state, pDirection, false);
        }
        if (pDirection.m_122434_() == this.getConnectionAxis(state)) {
            return (BlockState)this.m_152465_(pNeighborState).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)));
        }
        return FlapDisplayBlock.setConnection(state, pDirection, FlapDisplayBlock.getConnection(pNeighborState, pDirection.m_122424_()));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    protected boolean canConnect(BlockState state, BlockState other) {
        return other.m_60734_() == this && state.m_61143_(HORIZONTAL_FACING) == other.m_61143_(HORIZONTAL_FACING);
    }

    protected Direction.Axis getConnectionAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122427_().m_122434_();
    }

    public static boolean getConnection(BlockState state, Direction side) {
        BooleanProperty property = side == Direction.DOWN ? DOWN : (side == Direction.UP ? UP : null);
        return property != null && (Boolean)state.m_61143_((Property)property) != false;
    }

    public static BlockState setConnection(BlockState state, Direction side, boolean connect) {
        BooleanProperty property;
        Object object = side == Direction.DOWN ? DOWN : (property = side == Direction.UP ? UP : null);
        if (property != null) {
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(connect));
        }
        return state;
    }

    @Override
    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        if (pIsMoving || pNewState.m_60734_() == this) {
            return;
        }
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.getConnectionAxis(pState))) {
            BlockPos relative = pPos.m_121945_(d);
            BlockState adjacent = pLevel.m_8055_(relative);
            if (!this.canConnect(pState, adjacent)) continue;
            KineticBlockEntity.switchToBlockState(pLevel, relative, this.updateColumn(pLevel, relative, adjacent, false));
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> AllBlocks.DISPLAY_BOARD.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> AllBlocks.DISPLAY_BOARD.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_(), dir -> world.m_8055_(pos.m_121945_(dir)).m_247087_());
            return directions.isEmpty() ? PlacementOffset.fail() : PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> ((FlapDisplayBlock)AllBlocks.DISPLAY_BOARD.get()).updateColumn(world, pos.m_121945_((Direction)directions.get(0)), (BlockState)s.m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)((Direction)state.m_61143_(HORIZONTAL_FACING))), true));
        }
    }
}

