/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagePort;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlock;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public abstract class PackagePortTarget {
    public BlockPos relativePos;
    private String typeKey;

    public PackagePortTarget(String typeKey, BlockPos relativePos) {
        this.typeKey = typeKey;
        this.relativePos = relativePos;
    }

    public abstract boolean export(LevelAccessor var1, BlockPos var2, ItemStack var3, boolean var4);

    public void setup(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
    }

    public void register(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
    }

    public void deregister(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
    }

    public abstract Vec3 getExactTargetLocation(PackagePortBlockEntity var1, LevelAccessor var2, BlockPos var3);

    public abstract ItemStack getIcon();

    public abstract boolean canSupport(BlockEntity var1);

    public boolean depositImmediately() {
        return false;
    }

    public CompoundTag write() {
        CompoundTag compoundTag = new CompoundTag();
        this.writeInternal(compoundTag);
        compoundTag.m_128359_("Type", this.typeKey);
        compoundTag.m_128365_("RelativePos", (Tag)NbtUtils.m_129224_((BlockPos)this.relativePos));
        return compoundTag;
    }

    public static PackagePortTarget read(CompoundTag tag) {
        PackagePortTarget target;
        if (tag.m_128456_()) {
            return null;
        }
        BlockPos relativePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("RelativePos"));
        switch (tag.m_128461_("Type")) {
            case "ChainConveyor": {
                PackagePortTarget packagePortTarget = new ChainConveyorFrogportTarget(relativePos, 0.0f, null);
                break;
            }
            case "TrainStation": {
                PackagePortTarget packagePortTarget = new TrainStationFrogportTarget(relativePos);
                break;
            }
            default: {
                PackagePortTarget packagePortTarget = target = null;
            }
        }
        if (target == null) {
            return null;
        }
        target.readInternal(tag);
        return target;
    }

    protected abstract void writeInternal(CompoundTag var1);

    protected abstract void readInternal(CompoundTag var1);

    public BlockEntity be(LevelAccessor level, BlockPos portPos) {
        Level l;
        if (level instanceof Level && !(l = (Level)level).m_46749_(portPos.m_121955_((Vec3i)this.relativePos))) {
            return null;
        }
        return level.m_7702_(portPos.m_121955_((Vec3i)this.relativePos));
    }

    public static class ChainConveyorFrogportTarget
    extends PackagePortTarget {
        public float chainPos;
        public BlockPos connection;
        public boolean flipped;

        public ChainConveyorFrogportTarget(BlockPos relativePos, float chainPos, @Nullable BlockPos connection) {
            super("ChainConveyor", relativePos);
            this.chainPos = chainPos;
            this.connection = connection;
        }

        @Override
        public void setup(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
            BlockEntity blockEntity = this.be(level, portPos);
            if (blockEntity instanceof ChainConveyorBlockEntity) {
                ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
                this.flipped = clbe.getSpeed() < 0.0f;
            }
        }

        @Override
        public ItemStack getIcon() {
            return AllBlocks.CHAIN_CONVEYOR.asStack();
        }

        @Override
        public boolean export(LevelAccessor level, BlockPos portPos, ItemStack box, boolean simulate) {
            BlockEntity blockEntity = this.be(level, portPos);
            if (!(blockEntity instanceof ChainConveyorBlockEntity)) {
                return false;
            }
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
            if (this.connection != null && !clbe.connections.contains(this.connection)) {
                return false;
            }
            if (simulate) {
                return clbe.getSpeed() != 0.0f && clbe.canAcceptPackagesFor(this.connection);
            }
            ChainConveyorPackage box2 = new ChainConveyorPackage(this.chainPos, box.m_41777_());
            if (this.connection == null) {
                return clbe.addLoopingPackage(box2);
            }
            return clbe.addTravellingPackage(box2, this.connection);
        }

        @Override
        public void register(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
            BlockEntity blockEntity = this.be(level, portPos);
            if (!(blockEntity instanceof ChainConveyorBlockEntity)) {
                return;
            }
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
            ChainConveyorBlockEntity actualBe = clbe;
            if (this.connection != null && clbe.getSpeed() < 0.0f != this.flipped) {
                this.deregister(ppbe, level, portPos);
                actualBe = (ChainConveyorBlockEntity)((ChainConveyorBlock)AllBlocks.CHAIN_CONVEYOR.get()).getBlockEntity((BlockGetter)level, clbe.m_58899_().m_121955_((Vec3i)this.connection));
                if (actualBe == null) {
                    return;
                }
                clbe.prepareStats();
                ChainConveyorBlockEntity.ConnectionStats stats = clbe.connectionStats.get(this.connection);
                if (stats != null) {
                    this.chainPos = stats.chainLength() - this.chainPos;
                }
                this.connection = this.connection.m_142393_(-1);
                this.flipped = !this.flipped;
                this.relativePos = actualBe.m_58899_().m_121996_((Vec3i)portPos);
                ppbe.notifyUpdate();
            }
            if (this.connection != null && !actualBe.connections.contains(this.connection)) {
                return;
            }
            String portFilter = ppbe.getFilterString();
            if (portFilter == null) {
                return;
            }
            actualBe.routingTable.receivePortInfo(portFilter, this.connection == null ? BlockPos.f_121853_ : this.connection);
            Map<BlockPos, ChainConveyorBlockEntity.ConnectedPort> portMap = this.connection == null ? actualBe.loopPorts : actualBe.travelPorts;
            portMap.put(this.relativePos.m_142393_(-1), new ChainConveyorBlockEntity.ConnectedPort(this.chainPos, this.connection, portFilter));
        }

        @Override
        public void deregister(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
            BlockEntity blockEntity = this.be(level, portPos);
            if (!(blockEntity instanceof ChainConveyorBlockEntity)) {
                return;
            }
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
            clbe.loopPorts.remove(this.relativePos.m_142393_(-1));
            clbe.travelPorts.remove(this.relativePos.m_142393_(-1));
            String portFilter = ppbe.getFilterString();
            if (portFilter == null) {
                return;
            }
            clbe.routingTable.entriesByDistance.removeIf(e -> e.endOfRoute() && e.port().equals(portFilter));
            clbe.routingTable.changed = true;
        }

        @Override
        protected void writeInternal(CompoundTag tag) {
            tag.m_128350_("ChainPos", this.chainPos);
            if (this.connection != null) {
                tag.m_128365_("Connection", (Tag)NbtUtils.m_129224_((BlockPos)this.connection));
                tag.m_128379_("Flipped", this.flipped);
            }
        }

        @Override
        protected void readInternal(CompoundTag tag) {
            this.chainPos = tag.m_128457_("ChainPos");
            if (tag.m_128441_("Connection")) {
                this.connection = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Connection"));
                this.flipped = tag.m_128471_("Flipped");
            }
        }

        @Override
        public Vec3 getExactTargetLocation(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
            BlockEntity blockEntity = this.be(level, portPos);
            if (!(blockEntity instanceof ChainConveyorBlockEntity)) {
                return Vec3.f_82478_;
            }
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
            return clbe.getPackagePosition(this.chainPos, this.connection);
        }

        @Override
        public boolean canSupport(BlockEntity be) {
            return AllBlockEntityTypes.PACKAGE_FROGPORT.is(be);
        }
    }

    public static class TrainStationFrogportTarget
    extends PackagePortTarget {
        public TrainStationFrogportTarget(BlockPos relativePos) {
            super("TrainStation", relativePos);
        }

        @Override
        public ItemStack getIcon() {
            return AllBlocks.TRACK_STATION.asStack();
        }

        @Override
        public boolean export(LevelAccessor level, BlockPos portPos, ItemStack box, boolean simulate) {
            return false;
        }

        @Override
        public Vec3 getExactTargetLocation(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
            return Vec3.m_82512_((Vec3i)portPos.m_121955_((Vec3i)this.relativePos));
        }

        @Override
        public void register(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
            BlockEntity blockEntity = this.be(level, portPos);
            if (blockEntity instanceof StationBlockEntity) {
                StationBlockEntity sbe = (StationBlockEntity)blockEntity;
                sbe.attachPackagePort(ppbe);
            }
        }

        @Override
        public void deregister(PackagePortBlockEntity ppbe, LevelAccessor level, BlockPos portPos) {
            BlockEntity blockEntity = this.be(level, portPos);
            if (blockEntity instanceof StationBlockEntity) {
                StationBlockEntity sbe = (StationBlockEntity)blockEntity;
                sbe.removePackagePort(ppbe);
            }
        }

        @Override
        public boolean depositImmediately() {
            return true;
        }

        @Override
        protected void writeInternal(CompoundTag tag) {
        }

        @Override
        protected void readInternal(CompoundTag tag) {
        }

        @Override
        public boolean canSupport(BlockEntity be) {
            return AllBlockEntityTypes.PACKAGE_POSTBOX.is(be);
        }
    }
}

