/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.mechanicalArm;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmPlacementPacket;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ArmInteractionPointHandler {
    static List<ArmInteractionPoint> currentSelection = new ArrayList<ArmInteractionPoint>();
    static ItemStack currentItem;
    static long lastBlockPos;

    @SubscribeEvent
    public static void rightClickingBlocksSelectsThem(PlayerInteractEvent.RightClickBlock event) {
        if (currentItem == null) {
            return;
        }
        BlockPos pos = event.getPos();
        Level world = event.getLevel();
        if (!world.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        if (player != null && player.m_5833_()) {
            return;
        }
        ArmInteractionPoint selected = ArmInteractionPointHandler.getSelected(pos);
        BlockState state = world.m_8055_(pos);
        if (selected == null) {
            ArmInteractionPoint point = ArmInteractionPoint.create(world, pos, state);
            if (point == null) {
                return;
            }
            selected = point;
            ArmInteractionPointHandler.put(point);
        }
        selected.cycleMode();
        if (player != null) {
            ArmInteractionPoint.Mode mode = selected.getMode();
            CreateLang.builder().translate(mode.getTranslationKey(), new Object[]{CreateLang.blockName(state).style(ChatFormatting.WHITE)}).color(mode.getColor()).sendStatus(player);
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    @SubscribeEvent
    public static void leftClickingBlocksDeselectsThem(PlayerInteractEvent.LeftClickBlock event) {
        if (currentItem == null) {
            return;
        }
        if (!event.getLevel().f_46443_) {
            return;
        }
        BlockPos pos = event.getPos();
        if (ArmInteractionPointHandler.remove(pos) != null) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static void flushSettings(BlockPos pos) {
        if (currentSelection == null) {
            return;
        }
        int removed = 0;
        Iterator<ArmInteractionPoint> iterator = currentSelection.iterator();
        while (iterator.hasNext()) {
            ArmInteractionPoint point = iterator.next();
            if (point.getPos().m_123314_((Vec3i)pos, (double)ArmBlockEntity.getRange())) continue;
            iterator.remove();
            ++removed;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (removed > 0) {
            CreateLang.builder().translate("mechanical_arm.points_outside_range", new Object[]{removed}).style(ChatFormatting.RED).sendStatus((Player)player);
        } else {
            int inputs = 0;
            int outputs = 0;
            for (ArmInteractionPoint armInteractionPoint : currentSelection) {
                if (armInteractionPoint.getMode() == ArmInteractionPoint.Mode.DEPOSIT) {
                    ++outputs;
                    continue;
                }
                ++inputs;
            }
            if (inputs + outputs > 0) {
                CreateLang.builder().translate("mechanical_arm.summary", new Object[]{inputs, outputs}).style(ChatFormatting.WHITE).sendStatus((Player)player);
            }
        }
        AllPackets.getChannel().sendToServer((Object)new ArmPlacementPacket(currentSelection, pos));
        currentSelection.clear();
        currentItem = null;
    }

    public static void tick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.m_21205_();
        if (!AllBlocks.MECHANICAL_ARM.isIn(heldItemMainhand)) {
            currentItem = null;
        } else {
            if (heldItemMainhand != currentItem) {
                currentSelection.clear();
                currentItem = heldItemMainhand;
            }
            ArmInteractionPointHandler.drawOutlines(currentSelection);
        }
        ArmInteractionPointHandler.checkForWrench(heldItemMainhand);
    }

    private static void checkForWrench(ItemStack heldItem) {
        if (!AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        HitResult objectMouseOver = Minecraft.m_91087_().f_91077_;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        BlockPos pos = result.m_82425_();
        BlockEntity be = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (!(be instanceof ArmBlockEntity)) {
            lastBlockPos = -1L;
            currentSelection.clear();
            return;
        }
        if (lastBlockPos == -1L || lastBlockPos != pos.m_121878_()) {
            currentSelection.clear();
            ArmBlockEntity arm = (ArmBlockEntity)be;
            arm.inputs.forEach(ArmInteractionPointHandler::put);
            arm.outputs.forEach(ArmInteractionPointHandler::put);
            lastBlockPos = pos.m_121878_();
        }
        if (lastBlockPos != -1L) {
            ArmInteractionPointHandler.drawOutlines(currentSelection);
        }
    }

    private static void drawOutlines(Collection<ArmInteractionPoint> selection) {
        Iterator<ArmInteractionPoint> iterator = selection.iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            ArmInteractionPoint point = iterator.next();
            if (!point.isValid()) {
                iterator.remove();
                continue;
            }
            Level level = point.getLevel();
            BlockState state = level.m_8055_(pos = point.getPos());
            VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
            if (shape.m_83281_()) continue;
            int color = point.getMode().getColor();
            Outliner.getInstance().showAABB((Object)point, shape.m_83215_().m_82338_(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    private static void put(ArmInteractionPoint point) {
        currentSelection.add(point);
    }

    private static ArmInteractionPoint remove(BlockPos pos) {
        ArmInteractionPoint result = ArmInteractionPointHandler.getSelected(pos);
        if (result != null) {
            currentSelection.remove(result);
        }
        return result;
    }

    private static ArmInteractionPoint getSelected(BlockPos pos) {
        for (ArmInteractionPoint point : currentSelection) {
            if (!point.getPos().equals((Object)pos)) continue;
            return point;
        }
        return null;
    }

    static {
        lastBlockPos = -1L;
    }
}

