/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.fan;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.kinetics.fan.AirFlowParticle;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AirFlowParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<AirFlowParticleData> {
    public static final Codec<AirFlowParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("x").forGetter(p -> p.posX), (App)Codec.INT.fieldOf("y").forGetter(p -> p.posY), (App)Codec.INT.fieldOf("z").forGetter(p -> p.posZ)).apply((Applicative)i, AirFlowParticleData::new));
    public static final ParticleOptions.Deserializer<AirFlowParticleData> DESERIALIZER = new ParticleOptions.Deserializer<AirFlowParticleData>(){

        public AirFlowParticleData fromCommand(ParticleType<AirFlowParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int x = reader.readInt();
            reader.expect(' ');
            int y = reader.readInt();
            reader.expect(' ');
            int z = reader.readInt();
            return new AirFlowParticleData(x, y, z);
        }

        public AirFlowParticleData fromNetwork(ParticleType<AirFlowParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new AirFlowParticleData(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
    };
    final int posX;
    final int posY;
    final int posZ;

    public AirFlowParticleData(Vec3i pos) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public AirFlowParticleData(int posX, int posY, int posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public AirFlowParticleData() {
        this(0, 0, 0);
    }

    public ParticleType<?> m_6012_() {
        return AllParticleTypes.AIR_FLOW.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.posX);
        buffer.writeInt(this.posY);
        buffer.writeInt(this.posZ);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d %d", AllParticleTypes.AIR_FLOW.parameter(), this.posX, this.posY, this.posZ);
    }

    @Override
    public ParticleOptions.Deserializer<AirFlowParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    public Codec<AirFlowParticleData> getCodec(ParticleType<AirFlowParticleData> type) {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<AirFlowParticleData> getMetaFactory() {
        return AirFlowParticle.Factory::new;
    }
}

