/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.chainConveyor;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.IHaveBigOutline;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChainConveyorBlock
extends KineticBlock
implements IBE<ChainConveyorBlockEntity>,
IHaveBigOutline {
    public ChainConveyorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public VoxelShape m_6079_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return AllShapes.CHAIN_CONVEYOR_INTERACTION;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.CHAIN_CONVEYOR_INTERACTION;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_() && pPlayer != null && pPlayer.m_21120_(pHand).m_150930_(Items.f_42026_)) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer != null && AllBlocks.PACKAGE_FROGPORT.isIn(pPlayer.m_21120_(pHand))) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (pLevel.m_5776_()) {
            return;
        }
        if (!pPlayer.m_7500_()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> {
            be.cancelDrops = true;
        });
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return super.onSneakWrenched(state, context);
        }
        this.withBlockEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), be -> {
            be.cancelDrops = true;
            if (player.m_7500_()) {
                return;
            }
            for (BlockPos targetPos : be.connections) {
                for (int chainCost = ChainConveyorBlockEntity.getChainCost(targetPos); chainCost > 0; chainCost -= 64) {
                    player.m_150109_().m_150079_(new ItemStack((ItemLike)Items.f_42026_, Math.min(chainCost, 64)));
                }
            }
        });
        return super.onSneakWrenched(state, context);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (pContext.m_43725_().m_8055_(pContext.m_8083_().m_7918_(x, 0, z)).m_60734_() != this) continue;
                return null;
            }
        }
        return super.m_5573_(pContext);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83144_();
    }

    @Override
    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        IBE.onRemove(pState, pLevel, pPos, pNewState);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == this.getRotationAxis(state);
    }

    @Override
    public Class<ChainConveyorBlockEntity> getBlockEntityClass() {
        return ChainConveyorBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ChainConveyorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.CHAIN_CONVEYOR.get();
    }
}

