/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pipes;

import com.simibubi.create.content.contraptions.StructureTransform;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FluidPipeBlockRotation {
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = PipeBlock.f_55154_;

    public static BlockState rotate(BlockState state, Rotation rotation) {
        BlockState rotated = state;
        for (Direction direction : Iterate.horizontalDirections) {
            rotated = (BlockState)rotated.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(rotation.m_55954_(direction)), (Comparable)((Boolean)state.m_61143_((Property)FACING_TO_PROPERTY_MAP.get(direction))));
        }
        return rotated;
    }

    public static BlockState mirror(BlockState state, Mirror mirror) {
        BlockState mirrored = state;
        for (Direction direction : Iterate.horizontalDirections) {
            mirrored = (BlockState)mirrored.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(mirror.m_54848_(direction)), (Comparable)((Boolean)state.m_61143_((Property)FACING_TO_PROPERTY_MAP.get(direction))));
        }
        return mirrored;
    }

    public static BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = FluidPipeBlockRotation.mirror(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            return FluidPipeBlockRotation.rotate(state, transform.rotation);
        }
        BlockState rotated = state;
        for (Direction direction : Iterate.directions) {
            rotated = (BlockState)rotated.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(transform.rotateFacing(direction)), (Comparable)((Boolean)state.m_61143_((Property)FACING_TO_PROPERTY_MAP.get(direction))));
        }
        return rotated;
    }
}

