/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderInfo;
import com.simibubi.create.foundation.render.BlockEntityRenderHelper;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.Pair;

public class ContraptionEntityRenderer<C extends AbstractContraptionEntity>
extends EntityRenderer<C> {
    public ContraptionEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(C entity) {
        return null;
    }

    public boolean shouldRender(C entity, Frustum frustum, double cameraX, double cameraY, double cameraZ) {
        if (((AbstractContraptionEntity)((Object)entity)).getContraption() == null) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isAliveOrStale()) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isReadyForRender()) {
            return false;
        }
        return super.m_5523_(entity, frustum, cameraX, cameraY, cameraZ);
    }

    public void render(C entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int overlay) {
        super.m_7392_(entity, yaw, partialTicks, poseStack, buffers, overlay);
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        if (contraption == null) {
            return;
        }
        Level level = entity.m_9236_();
        ContraptionRenderInfo renderInfo = ContraptionRenderInfo.get(contraption);
        VirtualRenderWorld renderWorld = renderInfo.getRenderWorld();
        ContraptionMatrices matrices = renderInfo.getMatrices();
        matrices.setup(poseStack, (AbstractContraptionEntity)((Object)entity));
        if (!VisualizationManager.supportsVisualization((LevelAccessor)level)) {
            for (RenderType renderType : RenderType.m_110506_()) {
                SuperByteBuffer sbb = renderInfo.getBuffer(renderType);
                if (sbb.isEmpty()) continue;
                VertexConsumer vc = buffers.m_6299_(renderType);
                ((SuperByteBuffer)sbb.transform(matrices.getModel())).useLevelLight((BlockAndTintGetter)level, matrices.getWorld()).renderInto(poseStack, vc);
            }
        }
        ContraptionEntityRenderer.renderBlockEntities(level, renderWorld, contraption, matrices, buffers);
        ContraptionEntityRenderer.renderActors(level, renderWorld, contraption, matrices, buffers);
        matrices.clear();
    }

    private static void renderBlockEntities(Level level, VirtualRenderWorld renderWorld, Contraption c, ContraptionMatrices matrices, MultiBufferSource buffer) {
        BlockEntityRenderHelper.renderBlockEntities(level, renderWorld, c.getRenderedBEs(), matrices.getModelViewProjection(), matrices.getLight(), buffer);
    }

    private static void renderActors(Level level, VirtualRenderWorld renderWorld, Contraption c, ContraptionMatrices matrices, MultiBufferSource buffer) {
        PoseStack m = matrices.getModel();
        for (Pair pair : c.getActors()) {
            StructureTemplate.StructureBlockInfo blockInfo;
            MovementBehaviour movementBehaviour;
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = level;
            }
            if ((movementBehaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)(blockInfo = (StructureTemplate.StructureBlockInfo)pair.getLeft()).f_74676_())) == null || c.isHiddenInPortal(blockInfo.f_74675_())) continue;
            m.m_85836_();
            TransformStack.of((PoseStack)m).translate((Vec3i)blockInfo.f_74675_());
            movementBehaviour.renderInContraption(context, renderWorld, matrices, buffer);
            m.m_85849_();
        }
    }
}

