/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.core.misc.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gumillea.cosmopolitan.common.block.FrozenDessertTubBlock;
import com.gumillea.cosmopolitan.common.blockEntity.FrozenDessertTubBlockEntity;
import com.gumillea.cosmopolitan.core.reg.CosmoFluids;
import com.gumillea.cosmopolitan.core.reg.CosmoRecipes;
import com.gumillea.cosmopolitan.core.util.CosmoBlockTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class TubInteractingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient itemIngredient;
    private final FluidStack fluidIngredient;
    private final FluidStack result;
    private final int baseCount;
    private final boolean requiresCooling;

    public TubInteractingRecipe(ResourceLocation id, Ingredient itemIngredient, FluidStack fluidIngredient, FluidStack result, int baseCount, boolean requiresCooling) {
        this.id = id;
        this.itemIngredient = itemIngredient;
        this.fluidIngredient = fluidIngredient;
        this.result = result;
        this.baseCount = baseCount;
        this.requiresCooling = requiresCooling;
    }

    public FluidStack getResult() {
        return this.result.copy();
    }

    public boolean requiresCooling() {
        return this.requiresCooling;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CosmoRecipes.TUB_INTERACTING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CosmoRecipes.TUB_INTERACTING_TYPE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.itemIngredient);
        return list;
    }

    @Nullable
    public static FluidStack tryApply(Level level, FrozenDessertTubBlockEntity tub, BlockPos pos, BlockState state) {
        List recipes = level.m_7465_().m_44013_((RecipeType)CosmoRecipes.TUB_INTERACTING_TYPE.get());
        FluidStack currentFluid = tub.getFluidHandler().getFluidInTank(0);
        AABB area = new AABB(pos).m_82400_(0.5);
        List items = level.m_45976_(ItemEntity.class, area);
        for (TubInteractingRecipe recipe : recipes) {
            ItemStack item;
            if (recipe.requiresCooling() && !TubInteractingRecipe.hasCoolingSource(level, pos) || !currentFluid.getFluid().m_6212_(recipe.fluidIngredient.getFluid())) continue;
            int multiplier = (int)Math.ceil((double)currentFluid.getAmount() / 1000.0);
            int required = recipe.baseCount * multiplier;
            ArrayList<ItemEntity> entities = new ArrayList<ItemEntity>();
            int total = 0;
            for (ItemEntity entity : items) {
                ItemStack stack = entity.m_32055_();
                if (!recipe.itemIngredient.test(stack)) continue;
                entities.add(entity);
                if ((total += stack.m_41613_()) < required) continue;
                break;
            }
            if (total < required) continue;
            if (!entities.isEmpty() && (item = ((ItemEntity)entities.get(0)).m_32055_()).hasCraftingRemainingItem()) {
                ItemStack remaining = new ItemStack((ItemLike)item.getCraftingRemainingItem().m_41720_(), required);
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)remaining);
            }
            int remaining = required;
            for (ItemEntity entity : entities) {
                ItemStack stack = entity.m_32055_();
                int deduct = Math.min(stack.m_41613_(), remaining);
                stack.m_41774_(deduct);
                remaining -= deduct;
                if (stack.m_41619_()) {
                    entity.m_146870_();
                }
                if (remaining != 0) continue;
                break;
            }
            FluidStack newFluid = recipe.result.copy();
            if (currentFluid.getFluid() == CosmoFluids.CREAM.get() || currentFluid.hasTag() && currentFluid.getTag().m_128471_("has_cream")) {
                CompoundTag tag = newFluid.getOrCreateTag();
                tag.m_128379_("has_cream", true);
            }
            newFluid.setAmount(currentFluid.getAmount());
            tub.getTank().setFluid(newFluid);
            level.m_7260_(pos, state, state, 3);
            FrozenDessertTubBlock.contentApply(level, pos);
            return newFluid;
        }
        return null;
    }

    private static boolean hasCoolingSource(Level level, BlockPos pos) {
        return BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 2, 1)).anyMatch(checkPos -> {
            BlockState state = level.m_8055_(checkPos);
            return state.m_204336_(CosmoBlockTags.COOLING_SOURCES);
        });
    }

    public static class Serializer
    implements RecipeSerializer<TubInteractingRecipe> {
        public TubInteractingRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredient");
            Ingredient itemIngredient = Ingredient.f_43901_;
            FluidStack fluidIngredient = FluidStack.EMPTY;
            for (JsonElement element : ingredients) {
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("item") || obj.has("tag")) {
                    itemIngredient = Ingredient.m_43917_((JsonElement)obj);
                    continue;
                }
                if (!obj.has("fluid")) continue;
                JsonObject fluidObj = obj.getAsJsonObject("fluid");
                ResourceLocation fluidId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)fluidObj, (String)"name"));
                int amount = GsonHelper.m_13824_((JsonObject)fluidObj, (String)"amount", (int)1);
                fluidIngredient = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(fluidId)), amount);
            }
            JsonObject resultJson = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            FluidStack result = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)resultJson, (String)"fluid")))), GsonHelper.m_13824_((JsonObject)resultJson, (String)"amount", (int)1));
            int baseCount = GsonHelper.m_13824_((JsonObject)json, (String)"baseCount", (int)1);
            boolean requiresCooling = GsonHelper.m_13855_((JsonObject)json, (String)"requiresCooling", (boolean)false);
            return new TubInteractingRecipe(id, itemIngredient, fluidIngredient, result, baseCount, requiresCooling);
        }

        public TubInteractingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf byteBuf) {
            Ingredient itemIngredient = Ingredient.m_43940_((FriendlyByteBuf)byteBuf);
            FluidStack fluidIngredient = FluidStack.readFromPacket((FriendlyByteBuf)byteBuf);
            FluidStack result = FluidStack.readFromPacket((FriendlyByteBuf)byteBuf);
            int baseCount = byteBuf.m_130242_();
            boolean requiresCooling = byteBuf.readBoolean();
            return new TubInteractingRecipe(id, itemIngredient, fluidIngredient, result, baseCount, requiresCooling);
        }

        public void toNetwork(FriendlyByteBuf byteBuf, TubInteractingRecipe recipe) {
            recipe.itemIngredient.m_43923_(byteBuf);
            recipe.fluidIngredient.writeToPacket(byteBuf);
            recipe.result.writeToPacket(byteBuf);
            byteBuf.m_130130_(recipe.baseCount);
            byteBuf.writeBoolean(recipe.requiresCooling());
        }
    }
}

