/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.core.data;

import com.cosmicgelatin.peculiars.core.registry.PeculiarsBlocks;
import com.cosmicgelatin.peculiars.core.registry.PeculiarsItems;
import com.cosmicgelatin.seasonals.core.registry.SeasonalsBlocks;
import com.cosmicgelatin.seasonals.core.registry.SeasonalsItems;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gumillea.cosmopolitan.core.misc.CosmoBlockFamilies;
import com.gumillea.cosmopolitan.core.reg.CosmoBlocks;
import com.gumillea.cosmopolitan.core.reg.CosmoFluids;
import com.gumillea.cosmopolitan.core.reg.CosmoItems;
import com.gumillea.cosmopolitan.core.reg.CosmoRecipes;
import com.gumillea.cosmopolitan.core.util.CosmoCompat;
import com.gumillea.cosmopolitan.core.util.CosmoItemTags;
import com.gumillea.exquisito.core.reg.ExquisitoBlocks;
import com.gumillea.exquisito.core.reg.ExquisitoItems;
import com.gumillea.exquisito.core.util.tags.ExquisitoItemTags;
import com.sammy.minersdelight.setup.MDItems;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericItemTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanItemTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brnbrd.delightful.common.block.DelightfulBlocks;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.data.tags.DelightfulItemTags;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ItemExistsCondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.hiedacamellia.seeddelight.registry.ItemRegistry;
import org.jetbrains.annotations.NotNull;
import twilightforest.init.TFItems;
import umpaz.brewinandchewin.client.recipebook.FermentingRecipeBookTab;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.data.builder.KegFermentingRecipeBuilder;
import umpaz.brewinandchewin.data.builder.KegPouringRecipeBuilder;
import umpaz.farmersrespite.common.registry.FRItems;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class CosmoRecipeProvider
extends BlueprintRecipeProvider {
    public CosmoRecipeProvider(PackOutput output) {
        super("cosmopolitan", output);
    }

    public void m_245200_(@NotNull Consumer<FinishedRecipe> finished) {
        this.cookieTilesRecipe(finished, CosmoBlockFamilies.BIRCH_COOKIE_FAMILY);
        this.cookieTilesRecipe(finished, CosmoBlockFamilies.HERBAL_COOKIE_FAMILY);
        this.cookieTilesRecipe(finished, CosmoBlockFamilies.PAW_COOKIE_FAMILY);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CosmoItems.GOLDEN_ARBUTUS_BERRIES.get())).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('B'), (ItemLike)CosmoItems.ARBUTUS_BERRIES.get()).m_126130_("AAA").m_126130_("ABA").m_126130_("AAA").m_126132_("has_arbutus_berries", (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)((ItemLike)CosmoItems.ARBUTUS_BERRIES.get()))).m_176498_(finished);
        this.shapelessRecipe(finished, RecipeCategory.FOOD, (ItemLike)CosmoItems.LUSH_CONFITURE_BOTTLE.get(), 1, Items.f_42590_, CosmoItems.ARBUTUS_BERRIES.get(), CosmoItems.ARBUTUS_BERRIES.get(), Items.f_151079_, Items.f_151079_, Items.f_151079_, Items.f_42501_);
        this.shapelessRecipe(finished, RecipeCategory.FOOD, (ItemLike)CosmoItems.TUBER_PUREE.get(), 1, Items.f_42399_, CosmoItems.ROASTED_TUBER.get(), CosmoItems.ROASTED_TUBER.get(), ForgeTags.MILK);
        this.shapelessRecipe(finished, RecipeCategory.FOOD, (ItemLike)CosmoItems.TUBER_PUREE_CONE.get(), 3, CosmoItems.TUBER_PUREE.get(), CosmoItems.WAFER_CONE.get(), CosmoItems.WAFER_CONE.get(), CosmoItems.WAFER_CONE.get());
        this.shapelessRecipe(finished, RecipeCategory.FOOD, (ItemLike)CosmoItems.TUBER_PUREE_CONE.get(), 3, CosmoItems.ROASTED_TUBER.get(), CosmoItems.ROASTED_TUBER.get(), ForgeTags.MILK, CosmoItems.WAFER_CONE.get(), CosmoItems.WAFER_CONE.get(), CosmoItems.WAFER_CONE.get());
        this.shapelessRecipe(finished, RecipeCategory.FOOD, (ItemLike)CosmoItems.TUBER_PUREE_WITH_CONFITURE.get(), 1, CosmoItems.LUSH_CONFITURE_BOTTLE.get(), CosmoItems.TUBER_PUREE.get());
        this.shapelessRecipe(finished, RecipeCategory.FOOD, (ItemLike)CosmoItems.TUBER_PUREE_WITH_CONFITURE.get(), 1, Items.f_42399_, CosmoItems.ROASTED_TUBER.get(), CosmoItems.ROASTED_TUBER.get(), ForgeTags.MILK, CosmoItems.LUSH_CONFITURE_BOTTLE.get());
        this.shapelessRecipe(finished, RecipeCategory.FOOD, (ItemLike)CosmoItems.TUBER_PUREE_CONE_WITH_CONFITURE.get(), 3, CosmoItems.TUBER_PUREE_WITH_CONFITURE.get(), CosmoItems.WAFER_CONE.get(), CosmoItems.WAFER_CONE.get(), CosmoItems.WAFER_CONE.get());
        this.shapelessRecipe(finished, RecipeCategory.FOOD, (ItemLike)CosmoItems.TUBER_PUREE_CONE_WITH_CONFITURE.get(), 3, CosmoItems.TUBER_PUREE_CONE.get(), CosmoItems.TUBER_PUREE_CONE.get(), CosmoItems.TUBER_PUREE_CONE.get(), CosmoItems.LUSH_CONFITURE_BOTTLE.get());
        this.shapelessRecipe(finished, RecipeCategory.FOOD, (ItemLike)CosmoItems.WOODLAND_SUB.get(), 1, ForgeTags.BREAD, CosmoItems.BAKED_FIDDLEHEAD.get(), CosmoItems.BAKED_FIDDLEHEAD.get(), ForgeTags.COOKED_FISHES_SALMON);
        CosmoRecipeProvider.foodCookingRecipes(finished, (ItemLike)((ItemLike)CosmoItems.TUBER.get()), (ItemLike)((ItemLike)CosmoItems.ROASTED_TUBER.get()));
        this.createFillingRecipe(finished, (Fluid)CosmoFluids.VANILLA_ICE_CREAM.get(), 250, (ItemLike)CosmoItems.SPRING_SODA.get(), (ItemLike)CosmoItems.ICE_CREAM_FLOAT.get(), new ICondition[]{new ModLoadedCondition("neapolitan"), new ModLoadedCondition("farmersdelight")});
        this.kegPouringRecipe(finished, (Fluid)CosmoFluids.CONDENSED_MILK.get(), 250, (ItemLike)CosmoItems.CONDENSED_MILK_BOTTLE.get());
        this.kegPouringRecipe(finished, (Fluid)CosmoFluids.CONDENSED_MILK.get(), 1000, (ItemLike)CosmoItems.CONDENSED_MILK_BUCKET.get());
        this.kegPouringRecipe(finished, (Fluid)CosmoFluids.BIRCH_SAP.get(), 250, (ItemLike)CosmoItems.BIRCH_SAP_BOTTLE.get());
        this.kegPouringRecipe(finished, (Fluid)CosmoFluids.BERRY_SYRUP.get(), 250, (ItemLike)CosmoItems.BERRY_SYRUP_BOTTLE.get());
        this.kegPouringRecipe(finished, (Fluid)CosmoFluids.STEELEAF_NECTAR.get(), 250, (ItemLike)CosmoItems.STEELEAF_NECTAR.get());
        this.kegPouringRecipe(finished, (Fluid)CosmoFluids.ROOT_BEER.get(), 250, (ItemLike)CosmoItems.ROOT_BEER.get());
        this.kegPouringRecipe(finished, (Fluid)CosmoFluids.WILDBERRY_PUNCH.get(), 250, (ItemLike)CosmoItems.WILDBERRY_PUNCH.get());
        this.kegPouringRecipe(finished, (Fluid)CosmoFluids.SMOGGY_APEROL.get(), 250, (ItemLike)CosmoItems.SMOGGY_APEROL.get());
        this.kegPouringRecipe(finished, (Fluid)CosmoFluids.TWILIGHT_CHARTREUSE.get(), 250, (ItemLike)CosmoItems.TWILIGHT_CHARTREUSE.get());
        KegFermentingRecipeBuilder.kegFermentingRecipe((Fluid)((Fluid)CosmoFluids.ROOT_BEER.get()), (int)1000, (int)9600, (float)1.0f).addFluidIngredient((Fluid)CosmoFluids.BIRCH_SAP.get(), 1000).addIngredient((ItemLike)Items.f_151017_).addIngredient((ItemLike)ModItems.TREE_BARK.get()).addIngredient((ItemLike)Items.f_42405_).setRecipeBookTab(FermentingRecipeBookTab.DRINKS).unlockedByItems("has_tankard", new ItemLike[]{(ItemLike)BnCItems.TANKARD.get()}).unlockedByItems("has_wheat", new ItemLike[]{Items.f_42405_}).unlockedByItems("has_hanging_roots", new ItemLike[]{Items.f_151017_}).unlockedByItems("has_birch_sap_bottle", new ItemLike[]{(ItemLike)CosmoItems.BIRCH_SAP_BOTTLE.get()}).build(finished, CosmoCompat.id("cosmopolitan", "brewinandchewin/fermenting/root_beer"));
        KegFermentingRecipeBuilder.kegFermentingRecipe((Fluid)((Fluid)CosmoFluids.WILDBERRY_PUNCH.get()), (int)1000, (int)9600, (float)1.0f, (int)2).addFluidIngredient((Fluid)CosmoFluids.BERRY_SYRUP.get(), 1000).addIngredient(CosmoItemTags.FRUITS).addIngredient(CosmoItemTags.FRUITS).setRecipeBookTab(FermentingRecipeBookTab.DRINKS).unlockedByItems("has_tankard", new ItemLike[]{(ItemLike)BnCItems.TANKARD.get()}).unlockedByItems("has_berry_syrup_bottle", new ItemLike[]{(ItemLike)CosmoItems.BERRY_SYRUP_BOTTLE.get()}).build(finished, CosmoCompat.id("cosmopolitan", "brewinandchewin/fermenting/wildberry_punch"));
        this.registerFourStorageRecipe(finished, (ItemLike)CosmoItems.BERRY_SYRUP_BOTTLE.get(), (ItemLike)CosmoBlocks.BERRY_SYRUP_BLOCK.get());
        this.registerFourStorageRecipe(finished, (ItemLike)CosmoItems.BIRCH_SAP_BOTTLE.get(), (ItemLike)CosmoBlocks.BIRCH_SAP_BLOCK.get());
        this.registerFourStorageRecipe(finished, (ItemLike)CosmoItems.STEELEAF_NECTAR.get(), (ItemLike)CosmoBlocks.STEELEAF_NECTAR_BLOCK.get());
        this.registerNineStorageRecipe(finished, (ItemLike)CosmoItems.WILDBERRY.get(), (ItemLike)CosmoBlocks.WILDBERRIES_BASKET.get());
        this.registerNineStorageRecipe(finished, (ItemLike)CosmoItems.ARBUTUS_BERRIES.get(), (ItemLike)CosmoBlocks.ARBUTUS_BERRIES_BASKET.get());
        this.registerNineStorageRecipe(finished, (ItemLike)CosmoItems.GOLDEN_ARBUTUS_BERRIES.get(), (ItemLike)CosmoBlocks.GOLDEN_ARBUTUS_BERRIES_BASKET.get());
        this.registerNineStorageRecipe(finished, (ItemLike)CosmoItems.FIDDLEHEAD.get(), (ItemLike)CosmoBlocks.FIDDLEHEAD_CRATE.get());
        this.registerNineStorageRecipe(finished, (ItemLike)CosmoItems.IRON_FIDDLEHEAD.get(), (ItemLike)CosmoBlocks.IRON_FIDDLEHEAD_CRATE.get());
        this.registerNineStorageRecipe(finished, (ItemLike)CosmoItems.TUBER.get(), (ItemLike)CosmoBlocks.TUBER_CRATE.get());
        this.registerConeRecipe(finished, CosmoItemTags.CHERRY, (ItemLike)ItemRegistry.CherryIceCream.get(), (ItemLike)CosmoItems.CHERRY_ICE_CREAM_CONE.get());
        this.registerConeRecipe(finished, (ItemLike)FRItems.GREEN_TEA_LEAVES.get(), (ItemLike)CosmoCompat.GREEN_TEA_ICE_CREAM, (ItemLike)CosmoItems.GREEN_TEA_ICE_CREAM_CONE.get());
        this.registerConeRecipe(finished, (ItemLike)FRItems.YELLOW_TEA_LEAVES.get(), (ItemLike)CosmoCompat.YELLOW_TEA_ICE_CREAM, (ItemLike)CosmoItems.YELLOW_TEA_ICE_CREAM_CONE.get());
        this.registerConeRecipe(finished, (ItemLike)FRItems.BLACK_TEA_LEAVES.get(), (ItemLike)CosmoCompat.BLACK_TEA_ICE_CREAM, (ItemLike)CosmoItems.BLACK_TEA_ICE_CREAM_CONE.get());
        this.registerConeRecipe(finished, (ItemLike)FRItems.COFFEE_BEANS.get(), (ItemLike)CosmoCompat.COFFEE_ICE_CREAM, (ItemLike)CosmoItems.COFFEE_ICE_CREAM_CONE.get());
        this.registerIceCreamBlocksRecipe(finished, (ItemLike)ItemRegistry.CherryIceCream.get(), (ItemLike)CosmoBlocks.CHERRY_ICE_CREAM_BLOCK.get());
        this.registerIceCreamBlocksRecipe(finished, (ItemLike)CosmoCompat.PHYTOCHEMICAL_ICE_CREAM, (ItemLike)CosmoBlocks.PHYTOCHEMICAL_ICE_CREAM_BLOCK.get());
        this.registerIceCreamBlocksRecipe(finished, (ItemLike)CosmoCompat.GLACIER_ICE_CREAM, (ItemLike)CosmoBlocks.GLACIER_ICE_CREAM_BLOCK.get());
        this.registerIceCreamBlocksRecipe(finished, (ItemLike)CosmoCompat.AURORA_ICE_CREAM, (ItemLike)CosmoBlocks.AURORA_ICE_CREAM_BLOCK.get());
        this.registerIceCreamBlocksRecipe(finished, (ItemLike)CosmoCompat.TORCHBERRY_ICE_CREAM, (ItemLike)CosmoBlocks.TORCHBERRY_ICE_CREAM_BLOCK.get());
        this.registerIceCreamBlocksRecipe(finished, (ItemLike)CosmoItems.APPLE_ICE_CREAM.get(), (ItemLike)CosmoBlocks.APPLE_ICE_CREAM_BLOCK.get());
        this.registerIceCreamBlocksRecipe(finished, (ItemLike)CosmoItems.CARROT_ICE_CREAM.get(), (ItemLike)CosmoBlocks.CARROT_ICE_CREAM_BLOCK.get());
        this.registerIceCreamBlocksRecipe(finished, (ItemLike)CosmoItems.GLOW_BERRY_ICE_CREAM.get(), (ItemLike)CosmoBlocks.GLOW_BERRY_ICE_CREAM_BLOCK.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)NeapolitanBlocks.STRAWBERRY_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.STRAWBERRY_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)NeapolitanBlocks.VANILLA_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.VANILLA_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)NeapolitanBlocks.CHOCOLATE_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.CHOCOLATE_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)NeapolitanBlocks.ADZUKI_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.ADZUKI_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)NeapolitanBlocks.MINT_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.MINT_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)NeapolitanBlocks.BANANA_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.BANANA_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)DelightfulBlocks.SALMONBERRY_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.SALMONBERRY_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)DelightfulBlocks.MATCHA_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.MATCHA_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CRBlocks.POMEGRANATE_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.POMEGRANATE_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CRBlocks.LIME_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.LIME_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ExquisitoBlocks.CHORUS_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.CHORUS_FRUIT_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ExquisitoBlocks.WARZIPAN_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.WARZIPAN_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ExquisitoBlocks.ZURE_BERRY_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.AZURE_BERRY_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ExquisitoBlocks.JELLY_RING_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.JELLY_RING_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ExquisitoBlocks.NIGHTSHADE_BERRY_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.MIDNIGHT_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ExquisitoBlocks.ETHER_BULB_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.STARCLOUD_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)SeasonalsBlocks.BEETROOT_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.BEETROOT_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)SeasonalsBlocks.SWEET_BERRY_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.SWEET_BERRY_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)SeasonalsBlocks.PUMPKIN_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.PUMPKIN_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)PeculiarsBlocks.ALOE_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.ALOE_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)PeculiarsBlocks.PASSION_FRUIT_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.PASSION_FRUIT_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)PeculiarsBlocks.YUCCA_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.YUCCA_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ForgeRegistries.BLOCKS.getValue(CosmoCompat.id("respiteful", "green_tea_ice_cream_block")), (ItemLike)CosmoBlocks.GREEN_TEA_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ForgeRegistries.BLOCKS.getValue(CosmoCompat.id("respiteful", "yellow_tea_ice_cream_block")), (ItemLike)CosmoBlocks.YELLOW_TEA_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ForgeRegistries.BLOCKS.getValue(CosmoCompat.id("respiteful", "black_tea_ice_cream_block")), (ItemLike)CosmoBlocks.BLACK_TEA_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)ForgeRegistries.BLOCKS.getValue(CosmoCompat.id("respiteful", "coffee_ice_cream_block")), (ItemLike)CosmoBlocks.COFFEE_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.CHERRY_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.CHERRY_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.AURORA_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.AURORA_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.PHYTOCHEMICAL_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.PHYTOCHEMICAL_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.GLACIER_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.GLACIER_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.TORCHBERRY_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.TORCHBERRY_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.APPLE_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.APPLE_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.CARROT_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.CARROT_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.GLOW_BERRY_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.GLOW_BERRY_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.SOURCE_BERRY_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.SOURCE_BERRY_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.ENCHANTED_FRUIT_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.ENCHANTED_FRUIT_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.KABLOOM_ICE_CREAM_BLOCK.get(), (ItemLike)CosmoBlocks.KABLOOM_ICE_CREAM_BRICKS.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.STRAWBERRY_ICE_CREAM_BRICKS.get(), (ItemLike)CosmoBlocks.CHISELED_STRAWBERRY_ICE_CREAM_BLOCK.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.VANILLA_ICE_CREAM_BRICKS.get(), (ItemLike)CosmoBlocks.CHISELED_VANILLA_ICE_CREAM_BLOCK.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.CHOCOLATE_ICE_CREAM_BRICKS.get(), (ItemLike)CosmoBlocks.CHISELED_CHOCOLATE_ICE_CREAM_BLOCK.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.ADZUKI_ICE_CREAM_BRICKS.get(), (ItemLike)CosmoBlocks.CHISELED_ADZUKI_ICE_CREAM_BLOCK.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.MINT_ICE_CREAM_BRICKS.get(), (ItemLike)CosmoBlocks.CHISELED_MINT_ICE_CREAM_BLOCK.get());
        this.registerFourBlocksRecipe(finished, (ItemLike)CosmoBlocks.BANANA_ICE_CREAM_BRICKS.get(), (ItemLike)CosmoBlocks.CHISELED_BANANA_ICE_CREAM_BLOCK.get());
        this.registerBoth(finished, Items.f_42447_, Items.f_42446_, (Fluid)Fluids.f_76193_, 1000);
        this.registerBoth(finished, Items.f_42448_, Items.f_42446_, (Fluid)Fluids.f_76195_, 1000);
        this.registerBoth(finished, Items.f_42455_, Items.f_42446_, (Fluid)ForgeRegistries.FLUIDS.getValue(CosmoCompat.id("minecraft", "milk")), 1000);
        this.registerBoth(finished, (Item)NeapolitanItems.MILK_BOTTLE.get(), Items.f_42590_, (Fluid)ForgeRegistries.FLUIDS.getValue(CosmoCompat.id("minecraft", "milk")), 250);
        this.registerBoth(finished, (Item)MDItems.MILK_CUP.get(), (Item)MDItems.COPPER_CUP.get(), (Fluid)ForgeRegistries.FLUIDS.getValue(CosmoCompat.id("minecraft", "milk")), 500);
        this.registerBoth(finished, (Item)CCItems.GOLDEN_MILK_BUCKET.get(), (Item)CCItems.GOLDEN_BUCKET.get(), (Fluid)ForgeRegistries.FLUIDS.getValue(CosmoCompat.id("minecraft", "milk")), 1000);
        this.registerBoth(finished, (Item)CosmoItems.CONDENSED_MILK_BUCKET.get(), Items.f_42446_, (Fluid)CosmoFluids.CONDENSED_MILK.get(), 1000);
        this.registerBoth(finished, (Item)CosmoItems.CONDENSED_MILK_BOTTLE.get(), Items.f_42590_, (Fluid)CosmoFluids.CONDENSED_MILK.get(), 250);
        this.registerBoth(finished, (Item)CosmoItems.CREAM_BUCKET.get(), Items.f_42446_, (Fluid)CosmoFluids.CREAM.get(), 1000);
        this.registerBoth(finished, (Item)CosmoItems.CREAM.get(), Items.f_42399_, (Fluid)CosmoFluids.CREAM.get(), 250);
        this.registerFlavorRecipesWithoutMilkshake(finished, (Item)ItemRegistry.CherryIceCream.get(), null, (Fluid)CosmoFluids.CHERRY_ICE_CREAM.get(), "seeddelight");
        this.registerFlavorRecipesWithoutMilkshake(finished, CosmoCompat.GREEN_TEA_ICE_CREAM, null, (Fluid)CosmoFluids.GREEN_TEA_ICE_CREAM.get(), "respiteful");
        this.registerFlavorRecipes(finished, CosmoCompat.YELLOW_TEA_ICE_CREAM, null, (Fluid)CosmoFluids.YELLOW_TEA_ICE_CREAM.get(), "respiteful");
        this.registerFlavorRecipesWithoutMilkshake(finished, CosmoCompat.BLACK_TEA_ICE_CREAM, null, (Fluid)CosmoFluids.BLACK_TEA_ICE_CREAM.get(), "respiteful");
        this.registerFlavorRecipesWithoutMilkshake(finished, CosmoCompat.COFFEE_ICE_CREAM, null, (Fluid)CosmoFluids.COFFEE_ICE_CREAM.get(), "respiteful");
        this.registerFlavorRecipes(finished, (Item)NeapolitanItems.VANILLA_ICE_CREAM.get(), (Item)NeapolitanItems.VANILLA_MILKSHAKE.get(), (Fluid)CosmoFluids.VANILLA_ICE_CREAM.get(), "neapolitan");
        this.registerFlavorRecipes(finished, (Item)NeapolitanItems.STRAWBERRY_ICE_CREAM.get(), (Item)NeapolitanItems.STRAWBERRY_MILKSHAKE.get(), (Fluid)CosmoFluids.STRAWBERRY_ICE_CREAM.get(), "neapolitan");
        this.registerFlavorRecipes(finished, (Item)NeapolitanItems.CHOCOLATE_ICE_CREAM.get(), (Item)NeapolitanItems.CHOCOLATE_MILKSHAKE.get(), (Fluid)CosmoFluids.CHOCOLATE_ICE_CREAM.get(), "neapolitan");
        this.registerFlavorRecipes(finished, (Item)NeapolitanItems.BANANA_ICE_CREAM.get(), (Item)NeapolitanItems.BANANA_MILKSHAKE.get(), (Fluid)CosmoFluids.BANANA_ICE_CREAM.get(), "neapolitan");
        this.registerFlavorRecipes(finished, (Item)NeapolitanItems.ADZUKI_ICE_CREAM.get(), (Item)NeapolitanItems.ADZUKI_MILKSHAKE.get(), (Fluid)CosmoFluids.ADZUKI_ICE_CREAM.get(), "neapolitan");
        this.registerFlavorRecipes(finished, (Item)NeapolitanItems.MINT_ICE_CREAM.get(), (Item)NeapolitanItems.MINT_MILKSHAKE.get(), (Fluid)CosmoFluids.MINT_ICE_CREAM.get(), "neapolitan");
        this.registerFlavorRecipes(finished, (Item)CosmoItems.APPLE_ICE_CREAM.get(), (Item)CosmoItems.APPLE_MILKSHAKE.get(), (Fluid)CosmoFluids.APPLE_ICE_CREAM.get(), "neapolitan");
        this.registerFlavorRecipes(finished, (Item)CosmoItems.CARROT_ICE_CREAM.get(), (Item)CosmoItems.CARROT_MILKSHAKE.get(), (Fluid)CosmoFluids.CARROT_ICE_CREAM.get(), "neapolitan");
        this.registerFlavorRecipes(finished, (Item)CosmoItems.GLOW_BERRY_ICE_CREAM.get(), (Item)CosmoItems.GLOW_BERRY_MILKSHAKE.get(), (Fluid)CosmoFluids.GLOW_BERRY_ICE_CREAM.get(), "neapolitan");
        this.registerFlavorRecipes(finished, (Item)CosmoItems.ENCHANTED_FRUIT_ICE_CREAM.get(), (Item)CosmoItems.ENCHANTED_FRUIT_MILKSHAKE.get(), (Fluid)CosmoFluids.ENCHANTED_FRUIT_ICE_CREAM.get(), "neapolitan", "quark");
        this.registerFlavorRecipes(finished, (Item)CosmoItems.SOURCE_BERRY_ICE_CREAM.get(), (Item)CosmoItems.SOURCE_BERRY_MILKSHAKE.get(), (Fluid)CosmoFluids.SOURCE_BERRY_ICE_CREAM.get(), "neapolitan", "ars_nouveau");
        this.registerFlavorRecipes(finished, (Item)CosmoItems.KABLOOM_ICE_CREAM.get(), (Item)CosmoItems.KABLOOM_MILKSHAKE.get(), (Fluid)CosmoFluids.KABLOOM_ICE_CREAM.get(), "neapolitan", "habitat");
        this.registerFlavorRecipes(finished, (Item)DelightfulItems.MATCHA_ICE_CREAM.get(), (Item)DelightfulItems.MATCHA_MILKSHAKE.get(), (Fluid)CosmoFluids.MATCHA_ICE_CREAM.get(), "neapolitan", "delightful");
        this.registerFlavorRecipes(finished, (Item)DelightfulItems.SALMONBERRY_ICE_CREAM.get(), (Item)DelightfulItems.SALMONBERRY_MILKSHAKE.get(), (Fluid)CosmoFluids.SALMONBERRY_ICE_CREAM.get(), "neapolitan", "delightful");
        this.registerFlavorRecipes(finished, (Item)CRItems.LIME_ICE_CREAM.get(), (Item)CRItems.LIME_MILKSHAKE.get(), (Fluid)CosmoFluids.LIME_ICE_CREAM.get(), "neapolitan", "collectorsreap");
        this.registerFlavorRecipes(finished, (Item)CRItems.POMEGRANATE_ICE_CREAM.get(), (Item)CRItems.POMEGRANATE_MILKSHAKE.get(), (Fluid)CosmoFluids.POMEGRANATE_ICE_CREAM.get(), "neapolitan", "collectorsreap");
        this.registerFlavorRecipes(finished, CosmoCompat.AURORA_ICE_CREAM, CosmoCompat.AURORA_MILKSHAKE, (Fluid)CosmoFluids.AURORA_ICE_CREAM.get(), "neapolitan", "twilightdelight");
        this.registerFlavorRecipes(finished, CosmoCompat.GLACIER_ICE_CREAM, CosmoCompat.GLACIER_MILKSHAKE, (Fluid)CosmoFluids.GLACIER_ICE_CREAM.get(), "neapolitan", "twilightdelight");
        this.registerFlavorRecipes(finished, CosmoCompat.PHYTOCHEMICAL_ICE_CREAM, CosmoCompat.PHYTOCHEMICAL_MILKSHAKE, (Fluid)CosmoFluids.PHYTOCHEMICAL_ICE_CREAM.get(), "neapolitan", "twilightdelight");
        this.registerFlavorRecipes(finished, CosmoCompat.TORCHBERRY_ICE_CREAM, CosmoCompat.TORCHBERRY_MILKSHAKE, (Fluid)CosmoFluids.TORCHBERRY_ICE_CREAM.get(), "neapolitan", "twilightdelight");
        this.registerFlavorRecipes(finished, (Item)ExquisitoItems.CHORUS_ICE_CREAM.get(), (Item)ExquisitoItems.CHORUS_MILKSHAKE.get(), (Fluid)CosmoFluids.CHORUS_FRUIT_ICE_CREAM.get(), "exquisito");
        this.registerFlavorRecipes(finished, (Item)ExquisitoItems.WARZIPAN_ICE_CREAM.get(), (Item)ExquisitoItems.WARZIPAN_MILKSHAKE.get(), (Fluid)CosmoFluids.WARZIPAN_ICE_CREAM.get(), "exquisito");
        this.registerFlavorRecipes(finished, (Item)ExquisitoItems.ETHER_BULB_ICE_CREAM.get(), (Item)ExquisitoItems.ETHER_BULB_MILKSHAKE.get(), (Fluid)CosmoFluids.STARCLOUD_ICE_CREAM.get(), "exquisito");
        this.registerFlavorRecipes(finished, (Item)ExquisitoItems.NIGHTSHADE_BERRY_ICE_CREAM.get(), (Item)ExquisitoItems.NIGHTSHADE_BERRY_MILKSHAKE.get(), (Fluid)CosmoFluids.MIDNIGHT_ICE_CREAM.get(), "exquisito");
        this.registerFlavorRecipes(finished, (Item)ExquisitoItems.JELLY_RING_ICE_CREAM.get(), (Item)ExquisitoItems.JELLY_RING_MILKSHAKE.get(), (Fluid)CosmoFluids.JELLY_RING_ICE_CREAM.get(), "exquisito", "enlightened_end");
        this.registerFlavorRecipes(finished, (Item)ExquisitoItems.ZURE_BERRY_ICE_CREAM.get(), (Item)ExquisitoItems.ZURE_BERRY_MILKSHAKE.get(), (Fluid)CosmoFluids.AZURE_BERRY_ICE_CREAM.get(), "exquisito", "enlightened_end");
        this.registerFlavorRecipes(finished, (Item)PeculiarsItems.ALOE_ICE_CREAM.get(), (Item)PeculiarsItems.ALOE_MILKSHAKE.get(), (Fluid)CosmoFluids.ALOE_ICE_CREAM.get(), "peculiars");
        this.registerFlavorRecipes(finished, (Item)PeculiarsItems.PASSIONFRUIT_ICE_CREAM.get(), (Item)PeculiarsItems.PASSIONFRUIT_MILKSHAKE.get(), (Fluid)CosmoFluids.PASSION_FRUIT_ICE_CREAM.get(), "peculiars");
        this.registerFlavorRecipes(finished, (Item)PeculiarsItems.YUCCA_ICE_CREAM.get(), (Item)PeculiarsItems.YUCCA_MILKSHAKE.get(), (Fluid)CosmoFluids.YUCCA_ICE_CREAM.get(), "peculiars");
        this.registerFlavorRecipes(finished, (Item)SeasonalsItems.BEETROOT_ICE_CREAM.get(), (Item)SeasonalsItems.BEETROOT_MILKSHAKE.get(), (Fluid)CosmoFluids.BEETROOT_ICE_CREAM.get(), "seasonals");
        this.registerFlavorRecipes(finished, (Item)SeasonalsItems.PUMPKIN_ICE_CREAM.get(), (Item)SeasonalsItems.PUMPKIN_MILKSHAKE.get(), (Fluid)CosmoFluids.PUMPKIN_ICE_CREAM.get(), "seasonals");
        this.registerFlavorRecipes(finished, (Item)SeasonalsItems.SWEET_BERRY_ICE_CREAM.get(), (Item)SeasonalsItems.SWEET_BERRY_MILKSHAKE.get(), (Fluid)CosmoFluids.SWEET_BERRY_ICE_CREAM.get(), "seasonals");
        this.registerIceCreamInteraction(finished, (TagKey<Item>)NeapolitanItemTags.FRUITS_STRAWBERRY, (Fluid)CosmoFluids.STRAWBERRY_ICE_CREAM.get());
        this.registerIceCreamInteraction(finished, CosmoItemTags.CHOCOLATE, (Fluid)CosmoFluids.CHOCOLATE_ICE_CREAM.get());
        this.registerIceCreamInteraction(finished, (Item)NeapolitanItems.DRIED_VANILLA_PODS.get(), (Fluid)CosmoFluids.VANILLA_ICE_CREAM.get());
        this.registerIceCreamInteraction(finished, (TagKey<Item>)DelightfulItemTags.FRUITS_BANANA, (Fluid)CosmoFluids.BANANA_ICE_CREAM.get());
        this.registerIceCreamInteraction(finished, (Item)NeapolitanItems.MINT_LEAVES.get(), (Fluid)CosmoFluids.MINT_ICE_CREAM.get());
        this.registerIceCreamInteraction(finished, (Item)NeapolitanItems.ROASTED_ADZUKI_BEANS.get(), (Fluid)CosmoFluids.ADZUKI_ICE_CREAM.get());
        this.registerIceCreamInteraction(finished, CosmoItemTags.APPLE, (Fluid)CosmoFluids.APPLE_ICE_CREAM.get());
        this.registerIceCreamInteraction(finished, CosmoItemTags.CARROT, (Fluid)CosmoFluids.CARROT_ICE_CREAM.get());
        this.registerIceCreamInteraction(finished, CosmoItemTags.GLOW_BERRY, (Fluid)CosmoFluids.GLOW_BERRY_ICE_CREAM.get());
        this.registerIceCreamInteraction(finished, CosmoCompat.KABLOOM, (Fluid)CosmoFluids.KABLOOM_ICE_CREAM.get(), "neapolitan", "habitat");
        this.registerIceCreamInteraction(finished, CosmoCompat.SOURCEBERRY, (Fluid)CosmoFluids.SOURCE_BERRY_ICE_CREAM.get(), "neapolitan", "ars_nouveau");
        this.registerIceCreamInteraction(finished, (Item)ForgeRegistries.ITEMS.getValue(CosmoCompat.id("quark", "ancient_fruit")), (Fluid)CosmoFluids.ENCHANTED_FRUIT_ICE_CREAM.get(), "neapolitan", "quark");
        this.registerIceCreamInteraction(finished, (Item)SeasonalsItems.ROASTED_BEETROOT.get(), (Fluid)CosmoFluids.BEETROOT_ICE_CREAM.get(), "seasonals");
        this.registerIceCreamInteraction(finished, (Item)SeasonalsItems.PUMPKIN_PUREE.get(), (Fluid)CosmoFluids.PUMPKIN_ICE_CREAM.get(), "seasonals");
        this.registerIceCreamInteraction(finished, CosmoItemTags.SWEET_BERRY, (Fluid)CosmoFluids.SWEET_BERRY_ICE_CREAM.get(), "seasonals");
        this.registerIceCreamInteraction(finished, (Item)AtmosphericItems.ALOE_LEAVES.get(), (Fluid)CosmoFluids.ALOE_ICE_CREAM.get(), "peculiars");
        this.registerIceCreamInteraction(finished, (TagKey<Item>)AtmosphericItemTags.FRUITS_PASSION_FRUIT, (Fluid)CosmoFluids.PASSION_FRUIT_ICE_CREAM.get(), "peculiars");
        this.registerIceCreamInteraction(finished, (Item)AtmosphericItems.YUCCA_FRUIT.get(), (Fluid)CosmoFluids.YUCCA_ICE_CREAM.get(), "peculiars");
        this.registerIceCreamInteraction(finished, CosmoItemTags.CHORUS, (Fluid)CosmoFluids.CHORUS_FRUIT_ICE_CREAM.get(), "exquisito");
        this.registerIceCreamInteraction(finished, (Item)ExquisitoItems.WARZIPAN.get(), (Fluid)CosmoFluids.WARZIPAN_ICE_CREAM.get(), "exquisito");
        this.registerIceCreamInteraction(finished, (TagKey<Item>)ExquisitoItemTags.MIDNIGHT_INGREDIENTS, (Fluid)CosmoFluids.MIDNIGHT_ICE_CREAM.get(), "exquisito");
        this.registerIceCreamInteraction(finished, (TagKey<Item>)ExquisitoItemTags.STARCLOUD_INGREDIENTS, (Fluid)CosmoFluids.STARCLOUD_ICE_CREAM.get(), "exquisito");
        this.registerIceCreamInteraction(finished, (Item)ExquisitoItems.JELLY_RING.get(), (Fluid)CosmoFluids.JELLY_RING_ICE_CREAM.get(), "exquisito", "enlightened_end");
        this.registerIceCreamInteraction(finished, (Item)ForgeRegistries.ITEMS.getValue(CosmoCompat.id("enlightened_end", "azure_berries")), (Fluid)CosmoFluids.AZURE_BERRY_ICE_CREAM.get(), "exquisito", "enlightened_end");
        this.registerIceCreamInteraction(finished, (TagKey<Item>)DelightfulItemTags.MATCHA, (Fluid)CosmoFluids.MATCHA_ICE_CREAM.get(), "neapolitan", "delightful");
        this.registerIceCreamInteraction(finished, (TagKey<Item>)DelightfulItemTags.FRUITS_SALMONBERRIES, (Fluid)CosmoFluids.SALMONBERRY_ICE_CREAM.get(), "neapolitan", "delightful");
        this.registerIceCreamInteraction(finished, (TagKey<Item>)DelightfulItemTags.FRUITS_LIME, (Fluid)CosmoFluids.LIME_ICE_CREAM.get(), "neapolitan", "collectorsreap");
        this.registerIceCreamInteraction(finished, (TagKey<Item>)DelightfulItemTags.FRUITS_POMEGRANATE, (Fluid)CosmoFluids.POMEGRANATE_ICE_CREAM.get(), "neapolitan", "collectorsreap");
        this.registerIceCreamInteraction(finished, (Item)TFItems.TORCHBERRIES.get(), (Fluid)CosmoFluids.TORCHBERRY_ICE_CREAM.get(), "neapolitan", "twilightdelight");
        this.registerIceCreamInteraction(finished, (Item)FRItems.GREEN_TEA_LEAVES.get(), (Fluid)CosmoFluids.GREEN_TEA_ICE_CREAM.get(), "neapolitan", "respiteful");
        this.registerIceCreamInteraction(finished, (Item)FRItems.YELLOW_TEA_LEAVES.get(), (Fluid)CosmoFluids.YELLOW_TEA_ICE_CREAM.get(), "neapolitan", "respiteful");
        this.registerIceCreamInteraction(finished, (Item)FRItems.BLACK_TEA_LEAVES.get(), (Fluid)CosmoFluids.BLACK_TEA_ICE_CREAM.get(), "neapolitan", "respiteful");
        this.registerIceCreamInteraction(finished, (Item)FRItems.COFFEE_BEANS.get(), (Fluid)CosmoFluids.COFFEE_ICE_CREAM.get(), "neapolitan", "respiteful");
        this.registerIceCreamInteraction(finished, CosmoItemTags.CHERRY, (Fluid)CosmoFluids.CHERRY_ICE_CREAM.get(), "neapolitan", "seeddelight");
        this.iceCreamCreateRecipe(finished, (Fluid)CosmoFluids.GREEN_TEA_ICE_CREAM.get(), 750, (ItemLike)FRItems.GREEN_TEA_LEAVES.get(), (ItemLike)CosmoCompat.GREEN_TEA_ICE_CREAM);
        this.iceCreamCreateRecipe(finished, (Fluid)CosmoFluids.YELLOW_TEA_ICE_CREAM.get(), 750, (ItemLike)FRItems.YELLOW_TEA_LEAVES.get(), (ItemLike)CosmoCompat.YELLOW_TEA_ICE_CREAM);
        this.iceCreamCreateRecipe(finished, (Fluid)CosmoFluids.BLACK_TEA_ICE_CREAM.get(), 750, (ItemLike)FRItems.BLACK_TEA_LEAVES.get(), (ItemLike)CosmoCompat.BLACK_TEA_ICE_CREAM);
        this.iceCreamCreateRecipe(finished, (Fluid)CosmoFluids.COFFEE_ICE_CREAM.get(), 750, (ItemLike)FRItems.COFFEE_BEANS.get(), (ItemLike)CosmoCompat.COFFEE_ICE_CREAM);
        this.iceCreamCreateRecipe(finished, (Fluid)CosmoFluids.CHERRY_ICE_CREAM.get(), 750, CosmoItemTags.CHERRY, (ItemLike)ItemRegistry.CherryIceCream.get());
    }

    public static Consumer<FinishedRecipe> withModCondition(Consumer<FinishedRecipe> finished, String id) {
        return recipe -> ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(id)).addRecipe(recipe).build(finished, recipe.m_6445_());
    }

    private void cookieTilesRecipe(Consumer<FinishedRecipe> finished, BlockFamily family) {
        CosmoRecipeProvider.m_176580_(CosmoRecipeProvider.withModCondition(finished, "cookielicious"), (BlockFamily)family);
        ResourceLocation cookie_tiles = ForgeRegistries.BLOCKS.getKey((Object)family.m_175951_());
        String path = cookie_tiles.m_135815_();
        Item cookie = (Item)ForgeRegistries.ITEMS.getValue(CosmoCompat.id("cosmopolitan", path.replace("_tiles", "")));
        ResourceLocation id = CosmoCompat.id("cosmopolitan", "neapolitan/cookielicious/block/" + path);
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)family.m_175951_(), (int)4).m_126127_(Character.valueOf('#'), (ItemLike)cookie).m_126130_("##").m_126130_("##").m_126132_("has_" + cookie_tiles.m_135815_(), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)cookie));
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("cookielicious")).addRecipe(consumer -> builder.m_126140_(consumer, id)).build(finished, id);
    }

    private void shapelessRecipe(Consumer<FinishedRecipe> finished, RecipeCategory category, ItemLike result, int count, Object ... ingredients) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)result, (int)count);
        LinkedHashSet<ItemLike> itemUnlocks = new LinkedHashSet<ItemLike>();
        LinkedHashSet<TagKey> tagUnlocks = new LinkedHashSet<TagKey>();
        for (Object ingredient : ingredients) {
            TagKey tag;
            if (ingredient instanceof ItemLike) {
                ItemLike item = (ItemLike)ingredient;
                builder.m_126209_(item);
                itemUnlocks.add(item);
            }
            if (!(ingredient instanceof TagKey) || !(tag = (TagKey)ingredient).f_203867_().equals((Object)Registries.f_256913_)) continue;
            builder.m_206419_(tag);
            tagUnlocks.add(tag);
        }
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)((Item)itemUnlocks.stream().findFirst().get()));
        ResourceLocation resultKey = ForgeRegistries.ITEMS.getKey((Object)((Item)result));
        for (ItemLike item : itemUnlocks) {
            builder.m_126132_("has_" + BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()).m_135815_(), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)item));
        }
        for (TagKey tag : tagUnlocks) {
            builder.m_126132_("has_" + tag.f_203868_().m_135815_(), (CriterionTriggerInstance)CosmoRecipeProvider.m_206406_((TagKey)tag));
        }
        builder.m_126140_(finished, CosmoCompat.id("cosmopolitan", resultKey.m_135815_() + "_from_" + key.m_135815_()));
    }

    private void kegPouringRecipe(Consumer<FinishedRecipe> finished, Fluid fluid, int i, ItemLike item) {
        ResourceLocation key2 = ForgeRegistries.ITEMS.getKey((Object)((Item)item));
        KegPouringRecipeBuilder.kegPouringRecipe((Fluid)fluid, (int)i, (ItemLike)item).build(finished, CosmoCompat.id("cosmopolitan", "brewinandchewin/pouring/" + key2.m_135815_()));
        this.createEmptyingAndFillingRecipe(finished, fluid, i, item, (ItemLike)((Item)item).m_41469_(), new ICondition[0]);
    }

    private void iceCreamCreateRecipe(Consumer<FinishedRecipe> finished, Fluid fluid, int i, TagKey<Item> item, ItemLike iceCream) {
        ResourceLocation iceCreamKey = ForgeRegistries.ITEMS.getKey((Object)((Item)iceCream));
        ICondition[] conditions = new ICondition[]{new ModLoadedCondition("neapolitan"), new ItemExistsCondition(iceCreamKey.toString()), new NotCondition((ICondition)new TagEmptyCondition(item.f_203868_()))};
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(MixingRecipe::new, CosmoCompat.id("cosmopolitan", "create/" + iceCreamKey.m_135815_())).require(item).require(DelightfulItemTags.ICE_CUBES).require((ItemLike)Items.f_42501_).require((Fluid)ForgeRegistries.FLUIDS.getValue(CosmoCompat.id("minecraft", "milk")), i).output(fluid, i);
        for (ICondition condition : conditions) {
            builder.withCondition(condition);
        }
        Item Cone = (Item)ForgeRegistries.ITEMS.getValue(CosmoCompat.id("cosmopolitan", iceCreamKey.m_135815_() + "_cone"));
        Item Milkshake = (Item)ForgeRegistries.ITEMS.getValue(CosmoCompat.id(iceCreamKey.m_135827_(), iceCreamKey.m_135815_().replace("_ice_cream", "") + "_milkshake"));
        builder.build(finished);
        this.createEmptyingAndFillingRecipe(finished, fluid, i, iceCream, (ItemLike)Items.f_42399_, conditions);
        if (Cone != Items.f_41852_) {
            this.createFillingRecipe(finished, fluid, 250, (ItemLike)CosmoItems.WAFER_CONE.get(), (ItemLike)Cone, conditions);
        }
        if (Milkshake != Items.f_41852_) {
            this.createFillingRecipe(finished, fluid, 250, CosmoItemTags.MILK_BOTTLE, (ItemLike)Milkshake, conditions);
        }
    }

    private void iceCreamCreateRecipe(Consumer<FinishedRecipe> finished, Fluid fluid, int i, ItemLike item, ItemLike iceCream) {
        ResourceLocation iceCreamKey = ForgeRegistries.ITEMS.getKey((Object)((Item)iceCream));
        ResourceLocation key2 = ForgeRegistries.ITEMS.getKey((Object)((Item)item));
        ICondition[] conditions = new ICondition[]{new ModLoadedCondition("neapolitan"), new ItemExistsCondition(iceCreamKey.toString()), new ItemExistsCondition(key2.toString())};
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(MixingRecipe::new, CosmoCompat.id("cosmopolitan", "create/" + iceCreamKey.m_135815_())).require(item).require(DelightfulItemTags.ICE_CUBES).require((ItemLike)Items.f_42501_).require((Fluid)ForgeRegistries.FLUIDS.getValue(CosmoCompat.id("minecraft", "milk")), i).output(fluid, i);
        for (ICondition condition : conditions) {
            builder.withCondition(condition);
        }
        Item Cone = (Item)ForgeRegistries.ITEMS.getValue(CosmoCompat.id("cosmopolitan", iceCreamKey.m_135815_() + "_cone"));
        Item Milkshake = (Item)ForgeRegistries.ITEMS.getValue(CosmoCompat.id(iceCreamKey.m_135827_(), iceCreamKey.m_135815_().replace("_ice_cream", "") + "_milkshake"));
        builder.build(finished);
        this.createEmptyingAndFillingRecipe(finished, fluid, i, iceCream, (ItemLike)Items.f_42399_, conditions);
        if (Cone != Items.f_41852_) {
            this.createFillingRecipe(finished, fluid, 250, (ItemLike)CosmoItems.WAFER_CONE.get(), (ItemLike)Cone, conditions);
        }
        if (Milkshake != Items.f_41852_) {
            this.createFillingRecipe(finished, fluid, 250, CosmoItemTags.MILK_BOTTLE, (ItemLike)Milkshake, conditions);
        }
    }

    private void createEmptyingAndFillingRecipe(Consumer<FinishedRecipe> finished, Fluid fluid, int i, ItemLike item, ItemLike result, ICondition ... conditions) {
        this.createEmptyingRecipe(finished, fluid, i, item, result, conditions);
        this.createFillingRecipe(finished, fluid, i, result, item, conditions);
    }

    private void createEmptyingRecipe(Consumer<FinishedRecipe> finished, Fluid fluid, int i, ItemLike item, ItemLike result, ICondition ... conditions) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)((Item)item));
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(EmptyingRecipe::new, CosmoCompat.id("cosmopolitan", "create/" + key.m_135815_())).require(item).output(fluid, i).output(result);
        builder.withCondition((ICondition)new ModLoadedCondition("create"));
        for (ICondition condition : conditions) {
            builder.withCondition(condition);
        }
        builder.build(finished);
    }

    private void createFillingRecipe(Consumer<FinishedRecipe> finished, Fluid fluid, int i, ItemLike item, ItemLike result, ICondition ... conditions) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)((Item)result));
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(FillingRecipe::new, CosmoCompat.id("cosmopolitan", "create/" + key.m_135815_())).require(fluid, i).require(item).output(result);
        builder.withCondition((ICondition)new ModLoadedCondition("create"));
        for (ICondition condition : conditions) {
            builder.withCondition(condition);
        }
        builder.build(finished);
    }

    private void createFillingRecipe(Consumer<FinishedRecipe> finished, Fluid fluid, int i, TagKey<Item> item, ItemLike result, ICondition ... conditions) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)((Item)result));
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(FillingRecipe::new, CosmoCompat.id("cosmopolitan", "create/" + key.m_135815_())).require(fluid, i).require(item).output(result);
        builder.withCondition((ICondition)new ModLoadedCondition("create"));
        for (ICondition condition : conditions) {
            builder.withCondition(condition);
        }
        builder.build(finished);
    }

    private void registerNineStorageRecipe(Consumer<FinishedRecipe> finished, ItemLike item, ItemLike result) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)((Item)item));
        ResourceLocation resultKey = ForgeRegistries.BLOCKS.getKey((Object)((Block)result));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).m_126127_(Character.valueOf('A'), item).m_126130_("AAA").m_126130_("AAA").m_126130_("AAA").m_126132_("has_" + String.valueOf(key), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)item)).m_176498_(finished);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)item, (int)9).m_126209_(result).m_126132_("has_" + String.valueOf(resultKey), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)result)).m_126140_(finished, CosmoCompat.id("cosmopolitan", key.m_135815_() + "_from_" + resultKey.m_135815_().replace(key.m_135815_() + "_", "")));
    }

    private void registerFourStorageRecipe(Consumer<FinishedRecipe> finished, ItemLike item, ItemLike result) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)((Item)item));
        ResourceLocation resultKey = ForgeRegistries.BLOCKS.getKey((Object)((Block)result));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).m_126127_(Character.valueOf('A'), item).m_126130_("AA").m_126130_("AA").m_126132_("has_" + String.valueOf(key), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)item)).m_176498_(finished);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)item, (int)4).m_126209_(result).m_126209_((ItemLike)Items.f_42590_).m_126209_((ItemLike)Items.f_42590_).m_126209_((ItemLike)Items.f_42590_).m_126209_((ItemLike)Items.f_42590_).m_126132_("has_" + String.valueOf(resultKey), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)result)).m_176498_(finished);
    }

    private void registerConeRecipe(Consumer<FinishedRecipe> finished, ItemLike item, ItemLike iceCream, ItemLike result) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)((Item)item));
        ResourceLocation iceCreamKey = ForgeRegistries.ITEMS.getKey((Object)((Item)iceCream));
        ResourceLocation resultKey = ForgeRegistries.ITEMS.getKey((Object)((Item)result));
        ResourceLocation id = CosmoCompat.id("cosmopolitan", "neapolitan/" + resultKey.m_135815_());
        ResourceLocation id2 = CosmoCompat.id("cosmopolitan", "neapolitan/" + resultKey.m_135815_() + "from_ice_cream");
        ICondition[] conditions = new ICondition[]{new ModLoadedCondition("neapolitan"), new ItemExistsCondition(key.toString()), new ItemExistsCondition(iceCreamKey.toString())};
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)3).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126209_(item).m_206419_(CosmoItemTags.MILK).m_206419_(DelightfulItemTags.ICE_CUBES).m_126209_((ItemLike)Items.f_42501_).m_126132_("has_" + key.m_135815_(), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)item));
        ShapelessRecipeBuilder builder2 = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)3).m_126209_(iceCream).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126132_("has_" + iceCreamKey.m_135815_(), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)iceCream));
        this.registerConditionalRecipe(finished, id, builder, conditions);
        this.registerConditionalRecipe(finished, id2, builder2, conditions);
    }

    private void registerConeRecipe(Consumer<FinishedRecipe> finished, TagKey<Item> item, ItemLike iceCream, ItemLike result) {
        ResourceLocation iceCreamKey = ForgeRegistries.ITEMS.getKey((Object)((Item)iceCream));
        ResourceLocation resultKey = ForgeRegistries.ITEMS.getKey((Object)((Item)result));
        ResourceLocation id = CosmoCompat.id("cosmopolitan", "neapolitan/" + resultKey.m_135815_());
        ResourceLocation id2 = CosmoCompat.id("cosmopolitan", "neapolitan/" + resultKey.m_135815_() + "from_ice_cream");
        ICondition[] conditions = new ICondition[]{new ModLoadedCondition("neapolitan"), new NotCondition((ICondition)new TagEmptyCondition(item.f_203868_())), new ItemExistsCondition(iceCreamKey.toString())};
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)3).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_206419_(item).m_206419_(CosmoItemTags.MILK).m_206419_(DelightfulItemTags.ICE_CUBES).m_126209_((ItemLike)Items.f_42501_).m_126132_("has_" + String.valueOf(item), (CriterionTriggerInstance)CosmoRecipeProvider.m_206406_(item));
        ShapelessRecipeBuilder builder2 = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)3).m_126209_(iceCream).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126209_((ItemLike)CosmoItems.WAFER_CONE.get()).m_126132_("has_" + iceCreamKey.m_135815_(), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)iceCream));
        this.registerConditionalRecipe(finished, id, builder, conditions);
        this.registerConditionalRecipe(finished, id2, builder2, conditions);
    }

    private void registerFourBlocksRecipe(Consumer<FinishedRecipe> finished, ItemLike block, ItemLike result) {
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)((Block)block));
        ResourceLocation resultKey = ForgeRegistries.BLOCKS.getKey((Object)((Block)result));
        ResourceLocation id = CosmoCompat.id("cosmopolitan", "neapolitan/block/" + resultKey.m_135815_());
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)4).m_126127_(Character.valueOf('#'), block).m_126130_("##").m_126130_("##").m_126132_("has_" + key.m_135815_(), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)block));
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("neapolitan")).addCondition((ICondition)new ItemExistsCondition(key.toString())).addRecipe(consumer -> builder.m_126140_(consumer, id)).build(finished, id);
    }

    private void registerIceCreamBlocksRecipe(Consumer<FinishedRecipe> finished, ItemLike iceCream, ItemLike result) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)((Item)iceCream));
        ResourceLocation resultKey = ForgeRegistries.BLOCKS.getKey((Object)((Block)result));
        ResourceLocation id = CosmoCompat.id("cosmopolitan", "neapolitan/block/" + resultKey.m_135815_());
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)8).m_126127_(Character.valueOf('A'), (ItemLike)Blocks.f_50127_).m_126127_(Character.valueOf('B'), iceCream).m_126130_("AAA").m_126130_("ABA").m_126130_("AAA").m_126132_("has_" + key.m_135815_(), (CriterionTriggerInstance)CosmoRecipeProvider.m_125977_((ItemLike)iceCream));
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("neapolitan")).addCondition((ICondition)new ItemExistsCondition(key.toString())).addRecipe(consumer -> builder.m_126140_(consumer, id)).build(finished, id);
    }

    private void registerIceCreamInteraction(Consumer<FinishedRecipe> finished, Item item, Fluid result) {
        this.registerTubInteraction(finished, this.modsLoaded("neapolitan"), List.of(this.itemIngredient(item), this.fluidIngredient((Fluid)CosmoFluids.CREAM.get(), 1)), this.resultFluid(result, 1), 1);
    }

    private void registerIceCreamInteraction(Consumer<FinishedRecipe> finished, Item item, Fluid result, String ... conditions) {
        this.registerTubInteraction(finished, this.modsLoaded(conditions), List.of(this.itemIngredient(item), this.fluidIngredient((Fluid)CosmoFluids.CREAM.get(), 1)), this.resultFluid(result, 1), 1);
    }

    private void registerIceCreamInteraction(Consumer<FinishedRecipe> finished, TagKey<Item> item, Fluid result) {
        this.registerTubInteraction(finished, this.modsLoaded("neapolitan"), List.of(this.tagKeyIngredient(item), this.fluidIngredient((Fluid)CosmoFluids.CREAM.get(), 1)), this.resultFluid(result, 1), 1);
    }

    private void registerIceCreamInteraction(Consumer<FinishedRecipe> finished, TagKey<Item> item, Fluid result, String ... conditions) {
        this.registerTubInteraction(finished, this.modsLoaded(conditions), List.of(this.tagKeyIngredient(item), this.fluidIngredient((Fluid)CosmoFluids.CREAM.get(), 1)), this.resultFluid(result, 1), 1);
    }

    private void registerTubInteraction(Consumer<FinishedRecipe> consumer, List<ICondition> conditions, List<JsonObject> ingredients, JsonObject result, int baseCount) {
        JsonObject json = new JsonObject();
        JsonArray condArr = new JsonArray();
        json.addProperty("type", "cosmopolitan:tub_interacting");
        if (!conditions.isEmpty()) {
            for (ICondition condition : conditions) {
                condArr.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)condArr);
        }
        JsonArray ingArr = new JsonArray();
        ingredients.forEach(arg_0 -> ((JsonArray)ingArr).add(arg_0));
        json.add("ingredient", (JsonElement)ingArr);
        json.add("result", (JsonElement)result);
        json.addProperty("baseCount", (Number)baseCount);
        json.addProperty("requiresCooling", Boolean.valueOf(true));
        ResourceLocation fluidId = new ResourceLocation(result.get("fluid").getAsString());
        String name = fluidId.m_135815_();
        ResourceLocation id = CosmoCompat.id("cosmopolitan", "tub_interacting/" + name);
        consumer.accept(new CustomFinishedRecipe(id, (RecipeSerializer)CosmoRecipes.TUB_INTERACTING_SERIALIZER.get(), json));
    }

    private void registerBoth(Consumer<FinishedRecipe> consumer, Item injectItem, Item emptyItem, Fluid fluid, int amount) {
        ResourceLocation injectKey = ForgeRegistries.ITEMS.getKey((Object)injectItem);
        ResourceLocation emptyKey = ForgeRegistries.ITEMS.getKey((Object)emptyItem);
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)injectItem)).m_135815_();
        this.registerTubRecipe(consumer, name, (RecipeSerializer)CosmoRecipes.TUB_INJECT_SERIALIZER.get(), List.of(new ItemExistsCondition(injectKey.toString()), new ItemExistsCondition(emptyKey.toString())), List.of(this.itemIngredient(injectItem)), List.of(this.resultItem(emptyItem, 1), this.resultFluid(fluid, amount)));
        this.registerTubRecipe(consumer, name + "_extract", (RecipeSerializer)CosmoRecipes.TUB_EXTRACT_SERIALIZER.get(), List.of(new ItemExistsCondition(injectKey.toString()), new ItemExistsCondition(emptyKey.toString())), List.of(this.itemIngredient(emptyItem), this.fluidIngredient(fluid, amount)), List.of(this.resultItem(injectItem, 1)));
    }

    private void registerFlavorRecipesWithoutMilkshake(Consumer<FinishedRecipe> consumer, Item iceCreamItem, Item milkshakeItem, Fluid iceCreamFluid, String ... modids) {
        String name = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)iceCreamFluid)).m_135815_();
        List<ICondition> conds = this.modsLoaded(modids);
        this.registerTubRecipe(consumer, name, (RecipeSerializer)CosmoRecipes.TUB_EXTRACT_SERIALIZER.get(), conds, List.of(this.itemIngredient(Items.f_42399_), this.fluidIngredient(iceCreamFluid, 750)), List.of(this.resultItem(iceCreamItem, 1)));
        this.registerTubRecipe(consumer, name, (RecipeSerializer)CosmoRecipes.TUB_INJECT_SERIALIZER.get(), conds, List.of(this.itemIngredient(iceCreamItem)), List.of(this.resultItem(Items.f_42399_, 1), this.resultFluid(iceCreamFluid, 750)));
        String coneName = name + "_cone";
        Item coneItem = (Item)CosmoItems.WAFER_CONE.get();
        this.registerTubRecipe(consumer, coneName, (RecipeSerializer)CosmoRecipes.TUB_EXTRACT_SERIALIZER.get(), conds, List.of(this.itemIngredient(coneItem), this.fluidIngredient(iceCreamFluid, 250)), List.of(this.resultItem((Item)ForgeRegistries.ITEMS.getValue(CosmoCompat.id("cosmopolitan", coneName)), 1)));
    }

    private void registerFlavorRecipes(Consumer<FinishedRecipe> consumer, Item iceCreamItem, Item milkshakeItem, Fluid iceCreamFluid, String ... modids) {
        String name = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)iceCreamFluid)).m_135815_();
        List<ICondition> conds = this.modsLoaded(modids);
        this.registerTubRecipe(consumer, name, (RecipeSerializer)CosmoRecipes.TUB_EXTRACT_SERIALIZER.get(), conds, List.of(this.itemIngredient(Items.f_42399_), this.fluidIngredient(iceCreamFluid, 750)), List.of(this.resultItem(iceCreamItem, 1)));
        this.registerTubRecipe(consumer, name, (RecipeSerializer)CosmoRecipes.TUB_INJECT_SERIALIZER.get(), conds, List.of(this.itemIngredient(iceCreamItem)), List.of(this.resultItem(Items.f_42399_, 1), this.resultFluid(iceCreamFluid, 750)));
        String coneName = name + "_cone";
        Item coneItem = (Item)CosmoItems.WAFER_CONE.get();
        this.registerTubRecipe(consumer, coneName, (RecipeSerializer)CosmoRecipes.TUB_EXTRACT_SERIALIZER.get(), conds, List.of(this.itemIngredient(coneItem), this.fluidIngredient(iceCreamFluid, 250)), List.of(this.resultItem((Item)ForgeRegistries.ITEMS.getValue(CosmoCompat.id("cosmopolitan", coneName)), 1)));
        String shakeName = name + "_milkshake";
        this.registerTubRecipe(consumer, shakeName, (RecipeSerializer)CosmoRecipes.TUB_EXTRACT_SERIALIZER.get(), conds, List.of(this.tagIngredient("forge:milk/milk_bottle"), this.fluidIngredient(iceCreamFluid, 250)), List.of(this.resultItem(milkshakeItem, 1)));
    }

    private void registerTubRecipe(Consumer<FinishedRecipe> consumer, String name, RecipeSerializer<?> serializer, List<ICondition> conditions, List<JsonObject> ingredients, List<JsonObject> results) {
        JsonObject json = new JsonObject();
        JsonArray condArr = new JsonArray();
        if (!conditions.isEmpty()) {
            for (ICondition condition : conditions) {
                condArr.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)condArr);
        }
        JsonArray ingArr = new JsonArray();
        ingredients.forEach(arg_0 -> ((JsonArray)ingArr).add(arg_0));
        json.add("ingredient", (JsonElement)(ingArr.size() == 1 ? ingArr.get(0) : ingArr));
        JsonArray resArr = new JsonArray();
        results.forEach(arg_0 -> ((JsonArray)resArr).add(arg_0));
        json.add("result", (JsonElement)(resArr.size() == 1 ? resArr.get(0) : resArr));
        ResourceLocation id = CosmoCompat.id("cosmopolitan", (serializer == CosmoRecipes.TUB_EXTRACT_SERIALIZER.get() ? "tub_extracting/" : "tub_injecting/") + name);
        consumer.accept(new CustomFinishedRecipe(id, serializer, json));
    }

    private List<ICondition> modsLoaded(String ... modids) {
        return Arrays.stream(modids).map(ModLoadedCondition::new).collect(Collectors.toList());
    }

    private JsonObject itemIngredient(Item item) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).toString());
        return obj;
    }

    private JsonObject tagIngredient(String tag) {
        JsonObject obj = new JsonObject();
        obj.addProperty("tag", tag);
        return obj;
    }

    private JsonObject tagKeyIngredient(TagKey<Item> tag) {
        JsonObject obj = new JsonObject();
        obj.addProperty("tag", tag.f_203868_().toString());
        return obj;
    }

    private JsonObject fluidIngredient(Fluid fluid, int amount) {
        JsonObject obj = new JsonObject();
        JsonObject fj = new JsonObject();
        fj.addProperty("name", Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluid)).toString());
        fj.addProperty("amount", (Number)amount);
        obj.add("fluid", (JsonElement)fj);
        return obj;
    }

    private JsonObject resultItem(Item item, int count) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).toString());
        obj.addProperty("count", (Number)count);
        return obj;
    }

    private JsonObject resultFluid(Fluid fluid, int amount) {
        JsonObject obj = new JsonObject();
        obj.addProperty("fluid", Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluid)).toString());
        obj.addProperty("amount", (Number)amount);
        return obj;
    }

    private void registerConditionalRecipe(Consumer<FinishedRecipe> finished, ResourceLocation id, ShapelessRecipeBuilder builder, ICondition[] conditions) {
        ConditionalRecipe.Builder conditional = ConditionalRecipe.builder();
        for (ICondition condition : conditions) {
            conditional.addCondition(condition);
        }
        conditional.addRecipe(consumer -> builder.m_126140_(consumer, id)).build(finished, id);
    }

    private record CustomFinishedRecipe(ResourceLocation id, RecipeSerializer<?> serializer, JsonObject json) implements FinishedRecipe
    {
        public void m_7917_(JsonObject out) {
            out.addProperty("type", Objects.requireNonNull(ForgeRegistries.RECIPE_SERIALIZERS.getKey(this.serializer)).toString());
            this.json.entrySet().forEach(e -> out.add((String)e.getKey(), (JsonElement)e.getValue()));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

