/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.common.block;

import com.gumillea.cosmopolitan.core.util.CosmoCompat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGParticleTypes;

public class LifelightBlock
extends Block {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);

    public LifelightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 4) {
            if (randomSource.m_188503_(5) == 0) {
                BlockState next = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1));
                level.m_7731_(pos, next, 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)next));
            }
        } else {
            level.m_46961_(pos, true);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        SimpleParticleType p = CosmoCompat.ug ? (SimpleParticleType)UGParticleTypes.SHIMMER.get() : ParticleTypes.f_123745_;
        double x = (double)pos.m_123341_() + (double)random.m_188501_();
        double y = (double)pos.m_123342_() + 0.2 + (double)random.m_188501_();
        double z = (double)pos.m_123343_() + (double)random.m_188501_();
        double xSpeed = (double)random.m_188501_() * -0.9 * (double)random.m_188501_();
        double zSpeed = (double)random.m_188501_() * -0.9 * (double)random.m_188501_();
        level.m_7106_((ParticleOptions)p, x, y, z, xSpeed, 0.0, zSpeed);
    }

    public BlockState m_5573_(BlockPlaceContext p_55659_) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState state1, boolean b) {
        if (!level.f_46443_ && CosmoCompat.ug && level.m_46472_() == UGDimensions.UNDERGARDEN_LEVEL) {
            level.m_186460_(pos, (Block)this, 20);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!CosmoCompat.ug || level.m_46472_() != UGDimensions.UNDERGARDEN_LEVEL) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age >= 4) {
            level.m_46961_(pos, true);
            return;
        }
        AABB box = new AABB(pos.m_7918_(-1, -1, -1), pos.m_7918_(1, 2, 1));
        List targets = level.m_6443_(LivingEntity.class, box, e -> e.m_6084_() && e.m_21223_() < e.m_21233_());
        if (!targets.isEmpty()) {
            for (LivingEntity living : targets) {
                living.m_5634_(3.0f);
            }
            BlockState next = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1));
            level.m_7731_(pos, next, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)next));
        }
        level.m_186460_(pos, (Block)this, 20);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return 15 - (Integer)state.m_61143_((Property)AGE) * 3;
    }
}

