/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan;

import com.gumillea.cosmopolitan.CosmoConfig;
import com.gumillea.cosmopolitan.core.data.CosmoLanguageProvider;
import com.gumillea.cosmopolitan.core.data.CosmoLootModifierProvider;
import com.gumillea.cosmopolitan.core.data.CosmoLootTableProvider;
import com.gumillea.cosmopolitan.core.data.CosmoRecipeProvider;
import com.gumillea.cosmopolitan.core.data.models.CosmoBlockStateProvider;
import com.gumillea.cosmopolitan.core.data.models.CosmoItemModelProvider;
import com.gumillea.cosmopolitan.core.data.tags.CosmoBlockTagsProvider;
import com.gumillea.cosmopolitan.core.data.tags.CosmoEffectTagsProvider;
import com.gumillea.cosmopolitan.core.data.tags.CosmoItemTagsProvider;
import com.gumillea.cosmopolitan.core.misc.compat.supplementaries.CosmoSoftFluids;
import com.gumillea.cosmopolitan.core.misc.compat.supplementaries.SappyBirchLogInteraction;
import com.gumillea.cosmopolitan.core.reg.CosmoBlocks;
import com.gumillea.cosmopolitan.core.reg.CosmoCauldronInteractions;
import com.gumillea.cosmopolitan.core.reg.CosmoCreativeTabs;
import com.gumillea.cosmopolitan.core.reg.CosmoEffects;
import com.gumillea.cosmopolitan.core.reg.CosmoFluids;
import com.gumillea.cosmopolitan.core.reg.CosmoLootConditions;
import com.gumillea.cosmopolitan.core.reg.CosmoRecipes;
import com.gumillea.cosmopolitan.core.util.CosmoCompat;
import com.gumillea.cosmopolitan.core.util.CosmoCompostableItems;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.CompletableFuture;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cosmopolitan")
@Mod.EventBusSubscriber(modid="cosmopolitan")
public class Cosmopolitan {
    public static final String MODID = "cosmopolitan";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("cosmopolitan");
    public static final Logger LOGGER = LogManager.getLogger((String)"cosmopolitan");

    public Cosmopolitan() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(modEventBus);
        ForgeMod.enableMilkFluid();
        CosmoEffects.EFFECTS.register(modEventBus);
        CosmoEffects.POTIONS.register(modEventBus);
        CosmoRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        CosmoRecipes.RECIPE_TYPE.register(modEventBus);
        CosmoFluids.FLUIDS.register(modEventBus);
        CosmoFluids.FLUID_TYPES.register(modEventBus);
        CosmoCreativeTabs.TABS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        CosmoLootConditions.LOOT_CONDITION_TYPES.register(modEventBus);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CosmoConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CosmoConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            CosmoCompostableItems.registerCompostableItems();
            CosmoEffects.registerBrewingRecipes();
            if (CosmoCompat.nea) {
                CosmoCauldronInteractions.registerCauldronInteractions();
            }
            if (CosmoCompat.sup) {
                CosmoSoftFluids.init();
                FaucetBehaviorsManager.addRegisterFaucetInteraction(() -> FaucetBlockTile.registerInteraction((Object)new SappyBirchLogInteraction()));
            }
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)CosmoBlocks.BERRY_SYRUP_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)CosmoBlocks.BIRCH_SAP_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)CosmoBlocks.STEELEAF_NECTAR_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)CosmoBlocks.LIFELIGHT.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)CosmoBlocks.GLOW_PETALS.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)CosmoBlocks.POTTED_WILDBERRY_BUSH.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)CosmoBlocks.POTTED_FIDDLEHEAD_GREENS.get()), (RenderType)RenderType.m_110463_());
        });
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        CosmoBlockTagsProvider blockTagsProvider = new CosmoBlockTagsProvider(output, provider, helper);
        generator.addProvider(includeServer, (DataProvider)blockTagsProvider);
        generator.addProvider(includeServer, (DataProvider)new CosmoItemTagsProvider(output, provider, blockTagsProvider.m_274426_(), helper));
        generator.addProvider(includeServer, (DataProvider)new CosmoLootModifierProvider(output, provider));
        generator.addProvider(includeServer, (DataProvider)new CosmoRecipeProvider(output));
        generator.addProvider(includeServer, (DataProvider)new CosmoEffectTagsProvider(output, provider, helper));
        generator.addProvider(includeServer, (DataProvider)new CosmoLootTableProvider(output));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new CosmoItemModelProvider(output, helper));
        generator.addProvider(client, (DataProvider)new CosmoBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new CosmoLanguageProvider(output));
    }
}

