/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.repack.jcodec.codecs.vpx;

import com.github.alexthe666.citadel.repack.jcodec.codecs.vpx.VPXConst;
import com.github.alexthe666.citadel.repack.jcodec.common.tools.MathUtil;

public class VPXQuantizer {
    private int y1_dc_delta_q;
    private int uv_dc_delta_q;
    private int uv_ac_delta_q;
    private int y2_dc_delta_q;
    private int y2_ac_delta_q;

    public final void quantizeY(int[] coeffs, int qp) {
        int factDC = MathUtil.clip(VPXConst.dc_qlookup[qp + this.y1_dc_delta_q], 8, 132);
        int invFactAC = MathUtil.clip(VPXConst.ac_qlookup[qp], 8, 132);
        this.quantize(coeffs, factDC, invFactAC);
    }

    public final void quantizeUV(int[] coeffs, int qp) {
        int factDC = MathUtil.clip(VPXConst.dc_qlookup[qp + this.uv_dc_delta_q], 8, 132);
        int invFactAC = MathUtil.clip(VPXConst.ac_qlookup[qp + this.uv_ac_delta_q], 8, 132);
        this.quantize(coeffs, factDC, invFactAC);
    }

    public final void quantizeY2(int[] coeffs, int qp) {
        int factDC = MathUtil.clip(VPXConst.dc_qlookup[qp + this.y2_dc_delta_q] * 2, 8, 132);
        int invFactAC = MathUtil.clip(VPXConst.ac_qlookup[qp + this.y2_ac_delta_q] * 155 / 100, 8, 132);
        this.quantize(coeffs, factDC, invFactAC);
    }

    private final void quantize(int[] coeffs, int factDC, int factAC) {
        coeffs[0] = coeffs[0] / factDC;
        for (int i = 1; i < 16; ++i) {
            coeffs[i] = coeffs[i] / factAC;
        }
    }

    public final void dequantizeY(int[] coeffs, int qp) {
        int factDC = MathUtil.clip(VPXConst.dc_qlookup[qp + this.y1_dc_delta_q], 8, 132);
        int factAC = MathUtil.clip(VPXConst.ac_qlookup[qp], 8, 132);
        this.dequantize(coeffs, factDC, factAC);
    }

    public final void dequantizeUV(int[] coeffs, int qp) {
        int factDC = MathUtil.clip(VPXConst.dc_qlookup[qp + this.uv_dc_delta_q], 8, 132);
        int factAC = MathUtil.clip(VPXConst.ac_qlookup[qp + this.uv_ac_delta_q], 8, 132);
        this.dequantize(coeffs, factDC, factAC);
    }

    public final void dequantizeY2(int[] coeffs, int qp) {
        int factDC = MathUtil.clip(VPXConst.dc_qlookup[qp + this.y2_dc_delta_q] * 2, 8, 132);
        int factAC = MathUtil.clip(VPXConst.ac_qlookup[qp + this.y2_ac_delta_q] * 155 / 100, 8, 132);
        this.dequantize(coeffs, factDC, factAC);
    }

    private final void dequantize(int[] coeffs, int factDC, int factAC) {
        coeffs[0] = coeffs[0] * factDC;
        int i = 1;
        while (i < 16) {
            int n = i++;
            coeffs[n] = coeffs[n] * factAC;
        }
    }
}

