/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.emi;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.CraftingContainerRecipeTransferHandlerServer;

public record EmiTransferRecipeMessage(ResourceLocation recipeId, ResourceLocation recipeTypeId, int action, List<Integer> slots, List<Integer> crafting, int output, List<ItemStack> stacks, boolean maxTransfer) {
    public static void encode(EmiTransferRecipeMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130085_(msg.recipeId);
        packetBuffer.m_130085_(msg.recipeTypeId);
        packetBuffer.writeInt(msg.action);
        packetBuffer.m_236828_(msg.slots, FriendlyByteBuf::m_130130_);
        packetBuffer.m_236828_(msg.crafting, FriendlyByteBuf::m_130130_);
        packetBuffer.writeInt(msg.output);
        packetBuffer.m_236828_(msg.stacks, FriendlyByteBuf::m_130055_);
        packetBuffer.writeBoolean(msg.maxTransfer);
    }

    public static EmiTransferRecipeMessage decode(FriendlyByteBuf packetBuffer) {
        return new EmiTransferRecipeMessage(packetBuffer.m_130281_(), packetBuffer.m_130281_(), packetBuffer.readInt(), packetBuffer.m_236845_(FriendlyByteBuf::m_130242_), packetBuffer.m_236845_(FriendlyByteBuf::m_130242_), packetBuffer.readInt(), packetBuffer.m_236845_(FriendlyByteBuf::m_130267_), packetBuffer.readBoolean());
    }

    static void onMessage(EmiTransferRecipeMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> EmiTransferRecipeMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    public static void handleMessage(EmiTransferRecipeMessage payload, @Nullable ServerPlayer player) {
        RecipeType recipeType = (RecipeType)BuiltInRegistries.f_256990_.m_7745_(payload.recipeTypeId);
        if (recipeType == null) {
            return;
        }
        CraftingContainerRecipeTransferHandlerServer.setItemsWithStacks((Player)player, payload.recipeId, recipeType, payload.stacks, payload.crafting, payload.slots, payload.maxTransfer);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase container = (StorageContainerMenuBase)abstractContainerMenu;
        Slot output = null;
        if (payload.output >= 0 && payload.output < container.getTotalSlotsNumber()) {
            output = container.m_38853_(payload.output);
        }
        if (output != null) {
            if (payload.action == 1) {
                container.m_150399_(output.f_40219_, 0, ClickType.PICKUP, (Player)player);
            } else if (payload.action == 2) {
                container.m_150399_(output.f_40219_, 0, ClickType.QUICK_MOVE, (Player)player);
            }
        }
    }
}

