/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;

public class GraphHelper {
    public static <T> Set<T> getAllDescendants(T parent, Function<T, Collection<T>> childGetter) throws CircularReferenceException {
        HashSet descendants = new HashSet();
        LinkedList<T> toAdd = new LinkedList<T>(childGetter.apply(parent));
        while (!toAdd.isEmpty()) {
            Object child = toAdd.poll();
            if (child == parent) {
                throw new CircularReferenceException();
            }
            if (!descendants.add(child)) continue;
            toAdd.addAll(childGetter.apply(child));
        }
        return descendants;
    }

    public static class CircularReferenceException
    extends Exception {
    }
}

