/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.shop.offer.order;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.network.GsonSerializableCodecs;
import com.petrolpark.recipe.ingredient.modifier.IngredientModifier;
import com.petrolpark.recipe.ingredient.modifier.PassIngredientModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ShopOrderModifier
implements LootContextUser {
    public static final Codec<ShopOrderModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientModifier.CODEC.optionalFieldOf("requirement", (Object)PassIngredientModifier.INSTANCE).forGetter(ShopOrderModifier::getIngredientModifier), (App)GsonSerializableCodecs.NUMBER_PROVIDER.fieldOf("success").forGetter(ShopOrderModifier::getSuccessMultiplier), (App)GsonSerializableCodecs.NUMBER_PROVIDER.optionalFieldOf("failure", (Object)ConstantValue.m_165692_((float)0.0f)).forGetter(ShopOrderModifier::getFailureNumberProvider)).apply((Applicative)instance, ShopOrderModifier::new));
    public final IngredientModifier ingredientModifier;
    public final NumberProvider successMultiplier;
    public final NumberProvider failureMultiplier;

    public ShopOrderModifier(IngredientModifier ingredientModifier, NumberProvider successMultiplier, NumberProvider failureMultiplier) {
        this.ingredientModifier = ingredientModifier;
        this.successMultiplier = successMultiplier;
        this.failureMultiplier = failureMultiplier;
    }

    public IngredientModifier getIngredientModifier() {
        return this.ingredientModifier;
    }

    public NumberProvider getSuccessMultiplier() {
        return this.successMultiplier;
    }

    public NumberProvider getFailureNumberProvider() {
        return this.failureMultiplier;
    }

    public List<Component> getDescription(Level level) {
        ArrayList<Component> description = new ArrayList<Component>();
        this.ingredientModifier.addToDescription(description, level);
        return description;
    }

    public NumberProvider getMultiplier(ItemStack stack, Level level) {
        if (this.ingredientModifier.test(stack, level)) {
            return this.successMultiplier;
        }
        return this.failureMultiplier;
    }
}

