/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.recipe.contamination;

import com.google.gson.JsonObject;
import com.petrolpark.contamination.IContamination;
import com.petrolpark.contamination.ItemContamination;
import com.petrolpark.recipe.contamination.IHandleContaminationMyself;
import com.petrolpark.util.ItemHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CombineContaminatedItemsRecipe
extends CustomRecipe
implements IHandleContaminationMyself<CraftingContainer> {
    public static final Serializer SERIALIZER = new Serializer();

    public CombineContaminatedItemsRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack firstStack = ItemStack.f_41583_;
        boolean atLeastTwo = false;
        boolean atLeastOneContaminant = false;
        for (ItemStack stack : container.m_280657_()) {
            if (stack.m_41619_()) continue;
            if (ItemContamination.get(stack).hasAnyExtrinsicContaminant()) {
                atLeastOneContaminant = true;
            }
            if (firstStack.m_41619_()) {
                firstStack = stack;
                continue;
            }
            if (!ItemHelper.equalIgnoringTags(stack, firstStack, "Contamination")) {
                return false;
            }
            atLeastTwo = true;
        }
        return atLeastTwo && atLeastOneContaminant;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack result = ItemStack.f_41583_;
        int count = 0;
        for (ItemStack stack : container.m_280657_()) {
            if (stack.m_41619_()) continue;
            ++count;
            if (!result.m_41619_()) continue;
            result = stack;
        }
        result = result.m_255036_(count);
        IContamination<?, ?> contamination = ItemContamination.get(result);
        contamination.fullyDecontaminate();
        ItemContamination.perpetuateSingle(container.m_280657_().stream(), result);
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public boolean contaminationHandled(CraftingContainer container, RegistryAccess registryAccess) {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CombineContaminatedItemsRecipe> {
        public CombineContaminatedItemsRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            return new CombineContaminatedItemsRecipe(recipeId);
        }

        @Nullable
        public CombineContaminatedItemsRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new CombineContaminatedItemsRecipe(recipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CombineContaminatedItemsRecipe pRecipe) {
        }
    }
}

