/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.event;

import com.mojang.brigadier.CommandDispatcher;
import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkConfig;
import com.petrolpark.PetrolparkTags;
import com.petrolpark.badge.BadgesCapability;
import com.petrolpark.command.ContaminateCommand;
import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.ItemContamination;
import com.petrolpark.item.decay.DecayingItemHandler;
import com.petrolpark.item.decay.IDecayingItem;
import com.petrolpark.shop.customer.EntityCustomer;
import com.petrolpark.team.AbstractTeam;
import com.petrolpark.team.SinglePlayerTeam;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommonEvents {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        ContaminateCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public static void onTickLevel(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.level.m_5776_() && event.level.m_7654_().m_129783_() == event.level) {
            ++((DecayingItemHandler.ServerDecayingItemHandler)Petrolpark.DECAYING_ITEM_HANDLER.get()).gameTime;
        }
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Contaminant.ReloadListener(event.getRegistryAccess()));
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.getCapability(BadgesCapability.Provider.PLAYER_BADGES).isPresent()) {
                event.addCapability(Petrolpark.asResource("badges"), (ICapabilityProvider)new BadgesCapability.Provider());
            }
            if (!player.getCapability(SinglePlayerTeam.CAPABILITY).isPresent()) {
                event.addCapability(Petrolpark.asResource("team"), (ICapabilityProvider)new SinglePlayerTeam(player));
            }
        } else if (!entity.getCapability(EntityCustomer.CAPABILITY).isPresent()) {
            event.addCapability(Petrolpark.asResource("customer"), (ICapabilityProvider)new EntityCustomer(entity));
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(BadgesCapability.Provider.PLAYER_BADGES).ifPresent(oldStore -> event.getEntity().getCapability(BadgesCapability.Provider.PLAYER_BADGES).ifPresent(newStore -> newStore.setBadges(oldStore.getBadges())));
            event.getOriginal().getCapability(SinglePlayerTeam.CAPABILITY).ifPresent(oldCap -> event.getEntity().getCapability(SinglePlayerTeam.CAPABILITY).ifPresent(newCap -> newCap.copyTeamData(event.getEntity().m_9236_(), (AbstractTeam<?>)oldCap, PetrolparkTags.TeamDataTypes.LOST_ON_PLAYER_DEATH::matches)));
        }
    }

    @SubscribeEvent
    public static void onPotionBrewed(PotionBrewEvent.Post event) {
        for (int slot = 0; slot < 3; ++slot) {
            ItemStack potion = event.getItem(slot);
            IDecayingItem.startDecay(potion);
            if (!((Boolean)PetrolparkConfig.SERVER.brewingPropagatesContaminants.get()).booleanValue()) continue;
            ItemContamination.perpetuateSingle(Stream.of(event.getItem(3), potion).dropWhile(s -> (Boolean)PetrolparkConfig.SERVER.brewingWaterBottleContaminantsIgnored.get() != false && PotionUtils.m_43579_((ItemStack)s) == Potions.f_43599_), potion);
        }
    }
}

