/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.contamination;

import com.petrolpark.contamination.Contaminable;
import com.petrolpark.contamination.Contaminables;
import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.Contamination;
import com.petrolpark.contamination.IContamination;
import com.petrolpark.contamination.IItemStackDuck;
import com.petrolpark.contamination.IncontaminableContamination;
import com.petrolpark.contamination.ItemContaminationSavedEvent;
import java.util.stream.Stream;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ItemContamination
extends Contamination<Item, ItemStack> {
    public static final String TAG_KEY = "Contamination";

    public static IContamination<?, ?> create(ItemStack stack) {
        if (!Contaminables.ITEM.isContaminableStack(stack)) {
            return IncontaminableContamination.INSTANCE;
        }
        return new ItemContamination(stack);
    }

    public static IContamination<?, ?> get(ItemStack stack) {
        return ItemContamination.getDuck(stack).getContamination();
    }

    public static final void perpetuateSingle(Stream<ItemStack> inputs, ItemStack output) {
        ItemContamination.perpetuate(inputs.map(stack -> stack.m_255036_(1)), Stream.of(output));
    }

    public static final void perpetuateSingle(Stream<ItemStack> inputs, Stream<ItemStack> outputs) {
        ItemContamination.perpetuate(inputs.map(stack -> stack.m_255036_(1)), outputs);
    }

    public static final void perpetuate(Stream<ItemStack> inputs, Stream<ItemStack> outputs) {
        IContamination.perpetuate(inputs.dropWhile(ItemStack::m_41619_), outputs, ItemContamination::get);
    }

    protected ItemContamination(ItemStack stack) {
        super(stack);
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_(TAG_KEY, 9)) {
            this.orphanContaminants.addAll(stack.m_41783_().m_128437_(TAG_KEY, 8).stream().map(Tag::m_7916_).map(ResourceLocation::new).map(Contaminant::get).toList());
        }
        for (Contaminant contaminant : this.orphanContaminants) {
            this.contaminants.add(contaminant);
            this.contaminants.addAll(contaminant.getChildren());
        }
    }

    @Override
    public Contaminable<Item, ItemStack> getContaminable() {
        return Contaminables.ITEM;
    }

    @Override
    public Item getType() {
        return ((ItemStack)this.stack).m_41720_();
    }

    @Override
    public double getAmount() {
        return ((ItemStack)this.stack).m_41613_();
    }

    @Override
    public void save() {
        ((ItemStack)this.stack).m_41749_(TAG_KEY);
        if (!this.orphanContaminants.isEmpty()) {
            ((ItemStack)this.stack).m_41784_().m_128365_(TAG_KEY, (Tag)this.writeNBT());
        }
        ItemContamination.getDuck((ItemStack)this.stack).onContaminationSaved();
        MinecraftForge.EVENT_BUS.post((Event)new ItemContaminationSavedEvent((ItemStack)this.stack, this));
    }

    protected static IItemStackDuck getDuck(ItemStack stack) {
        return (IItemStackDuck)stack;
    }
}

