/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.contamination.Contaminant;
import com.petrolpark.team.data.ITeamDataType;
import com.petrolpark.util.Lang;
import java.util.Collections;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PetrolparkTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return PetrolparkTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return PetrolparkTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return PetrolparkTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return PetrolparkTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static enum TeamDataTypes {
        LOST_ON_PLAYER_DEATH;

        public final TagKey<ITeamDataType<?>> tag = TagKey.m_203882_(PetrolparkRegistries.Keys.TEAM_DATA_TYPE, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(ITeamDataType<?> teamDataType) {
            return ((Holder)PetrolparkRegistries.getRegistry(PetrolparkRegistries.Keys.TEAM_DATA_TYPE).getHolder(teamDataType).orElseThrow()).m_203656_(this.tag);
        }
    }

    public static enum Contaminants {
        HIDDEN,
        NOT_PRESERVED_CRUSHING("not_preserved/crushing");

        public final TagKey<Contaminant> tag;

        private Contaminants() {
            this.tag = TagKey.m_203882_(PetrolparkRegistries.Keys.CONTAMINANT, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));
        }

        private Contaminants(String path) {
            this.tag = TagKey.m_203882_(PetrolparkRegistries.Keys.CONTAMINANT, (ResourceLocation)Petrolpark.asResource(path));
        }

        public boolean matches(Contaminant contaminant) {
            return ((Holder.Reference)PetrolparkRegistries.getDataRegistry(PetrolparkRegistries.Keys.CONTAMINANT).m_203300_(PetrolparkRegistries.getDataRegistry(PetrolparkRegistries.Keys.CONTAMINANT).m_7447_((Object)contaminant)).orElseThrow()).m_203656_(this.tag);
        }
    }

    public static enum MenuTypes {
        ALWAYS_SHOWS_EXTENDED_INVENTORY,
        NEVER_SHOWS_EXTENDED_INVENTORY,
        ALLOWS_MANUAL_ONLY_CRAFTING;

        public final TagKey<MenuType<?>> tag = TagKey.m_203882_((ResourceKey)Registries.f_256798_, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(AbstractContainerMenu menu) {
            try {
                return this.matches(menu.m_6772_());
            }
            catch (UnsupportedOperationException e) {
                return false;
            }
        }

        public boolean matches(MenuType<?> menuType) {
            return ForgeRegistries.MENU_TYPES.getHolder(menuType).map(h -> h.m_203656_(this.tag)).orElse(false);
        }
    }

    public static enum BlockEntityTypes {
        CONTAMINABLE_KINETIC;

        public final TagKey<BlockEntityType<?>> tag = TagKey.m_203882_((ResourceKey)Registries.f_256922_, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(BlockEntity blockEntity) {
            return this.matches(blockEntity.m_58903_());
        }

        public boolean matches(BlockEntityType<?> blockEntityType) {
            return ((Holder)ForgeRegistries.BLOCK_ENTITY_TYPES.getHolder(blockEntityType).orElseThrow()).m_203656_(this.tag);
        }
    }

    public static enum Fluids {
        INCONTAMINABLE;

        public final TagKey<Fluid> tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidStack stack) {
            return stack.getFluid().m_205067_(this.tag);
        }
    }

    public static enum Items {
        INCONTAMINABLE,
        CONTAMINABLE_BLOCKS;

        public final TagKey<Item> tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }
    }
}

