/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.forge.addons.framedblocks;

import com.fizzware.dramaticdoors.forge.forge.addons.framedblocks.TallDoorConnectionPredicate;
import com.fizzware.dramaticdoors.forge.forge.addons.framedblocks.TallDoorFullFacePredicate;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.predicate.contex.ConTexMode;
import xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.predicate.fullface.FullFacePredicate;
import xfacthd.framedblocks.api.shapes.ShapeGenerator;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.SideSkipPredicates;

public enum DDBlockType implements IBlockType
{
    FRAMED_TALL_DOOR(true, false, false, false, true, false, true, false, ConTexMode.FULL_FACE),
    FRAMED_TALL_IRON_DOOR(true, false, false, false, true, false, true, false, ConTexMode.FULL_FACE);

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final boolean canOcclude;
    private final boolean specialHitbox;
    private final boolean specialTile;
    private final boolean waterloggable;
    private final boolean blockItem;
    private final boolean allowIntangible;
    private final boolean doubleBlock;
    private final boolean lockable;
    private final boolean supportsCT;
    private final ConTexMode minCTMode;
    private final ShapeGenerator shapeGen;

    public static void addEnums() {
    }

    private DDBlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, ConTexMode contextMode) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, contextMode, ShapeGenerator.EMPTY);
    }

    private DDBlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, ConTexMode contextMode, ShapeGenerator shapeGen) {
        this.canOcclude = canOcclude;
        this.specialHitbox = specialHitbox;
        this.specialTile = specialTile;
        this.waterloggable = waterloggable;
        this.blockItem = blockItem;
        this.allowIntangible = allowIntangible;
        this.doubleBlock = doubleBlock;
        this.lockable = lockable;
        this.supportsCT = contextMode != null;
        this.minCTMode = contextMode;
        this.shapeGen = shapeGen;
    }

    public int compareTo(IBlockType other) {
        if (!(other instanceof DDBlockType)) {
            return 1;
        }
        DDBlockType type = (DDBlockType)other;
        return this.compareTo(type);
    }

    public ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        return this.shapeGen.generate(states);
    }

    public String getName() {
        return this.name;
    }

    public boolean canOccludeWithSolidCamo() {
        return this.canOcclude;
    }

    public boolean hasBlockItem() {
        return this.blockItem;
    }

    public boolean hasSpecialHitbox() {
        return this.specialHitbox;
    }

    public boolean hasSpecialTile() {
        return this.specialTile;
    }

    public boolean allowMakingIntangible() {
        return this.allowIntangible;
    }

    public boolean isDoubleBlock() {
        return this.doubleBlock;
    }

    public boolean canLockState() {
        return this.lockable;
    }

    public boolean supportsWaterLogging() {
        return this.waterloggable;
    }

    public boolean supportsConnectedTextures() {
        return this.supportsCT;
    }

    public ConTexMode getMinimumConTexMode() {
        return this.minCTMode;
    }

    public FullFacePredicate getFullFacePredicate() {
        return TallDoorFullFacePredicate.INSTANCE;
    }

    public SideSkipPredicate getSideSkipPredicate() {
        return (SideSkipPredicate)SideSkipPredicates.PREDICATES.get(BlockType.FRAMED_CUBE);
    }

    public ConnectionPredicate getConnectionPredicate() {
        return TallDoorConnectionPredicate.INSTANCE;
    }
}

