/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.node;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;
import xaero.common.misc.MapFactory;
import xaero.hud.category.setting.ObjectCategorySetting;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.EditorListEntryWidget;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.entry.EditorListRootEntryFactory;
import xaero.hud.category.ui.entry.widget.EditorButton;
import xaero.hud.category.ui.node.EditorCategoryNode;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.options.EditorOptionsNode;
import xaero.hud.category.ui.node.options.EditorSimpleButtonNode;
import xaero.hud.category.ui.node.options.range.setting.IEditorSettingNode;
import xaero.hud.category.ui.node.options.range.setting.IEditorSettingNodeBuilder;
import xaero.hud.category.ui.node.options.text.EditorTextFieldOptionsNode;
import xaero.hud.category.ui.node.tooltip.IEditorDataTooltipSupplier;

public class EditorSettingsNode<SETTING_DATA extends EditorOptionsNode<?>>
extends EditorNode {
    private final Map<ObjectCategorySetting<?>, SETTING_DATA> settings;
    private final List<SETTING_DATA> settingList;
    private boolean toBeDeleted;
    private final EditorSimpleButtonNode deleteButton;
    private final EditorSimpleButtonNode protectionButton;
    private final EditorTextFieldOptionsNode nameOption;
    private final ListFactory listFactory;
    private final boolean rootSettings;
    private boolean protection;

    protected EditorSettingsNode(@Nonnull Map<ObjectCategorySetting<?>, SETTING_DATA> settings, @Nonnull List<SETTING_DATA> settingList, @Nonnull EditorSimpleButtonNode deleteButton, @Nonnull EditorSimpleButtonNode protectionButton, @Nonnull EditorTextFieldOptionsNode nameOption, @Nonnull ListFactory listFactory, boolean rootSettings, boolean movable, @Nonnull EditorListRootEntryFactory listEntryFactory, IEditorDataTooltipSupplier tooltipSupplier, boolean protection) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.settings = settings;
        this.settingList = settingList;
        this.listFactory = listFactory;
        this.rootSettings = rootSettings;
        this.deleteButton = deleteButton;
        this.protectionButton = protectionButton;
        this.nameOption = nameOption;
        this.protection = protection;
    }

    public Map<ObjectCategorySetting<?>, SETTING_DATA> getSettings() {
        return this.settings;
    }

    public IEditorSettingNode<?> getSettingData(ObjectCategorySetting<?> setting) {
        return (IEditorSettingNode)this.settings.get(setting);
    }

    public boolean isRootSettings() {
        return this.rootSettings;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted() {
        this.toBeDeleted = true;
    }

    public boolean getProtection() {
        return this.protection;
    }

    public void setProtected(boolean protection) {
        this.protection = protection;
    }

    @Override
    public List<EditorNode> getSubNodes() {
        List<EditorNode> result = this.listFactory.get();
        result.addAll(this.settingList);
        if (!this.protection) {
            result.add(this.nameOption);
        }
        result.add(this.deleteButton);
        result.add(this.protectionButton);
        return result;
    }

    @Override
    public String getDisplayName() {
        return I18n.m_118938_((String)"gui.xaero_category_settings", (Object[])new Object[0]);
    }

    public EditorTextFieldOptionsNode getNameOption() {
        return this.nameOption;
    }

    public static final class FinalBuilder
    extends Builder<EditorSettingsNode<?>, FinalBuilder> {
        private FinalBuilder(MapFactory mapFactory, ListFactory listFactory, List<ObjectCategorySetting<?>> allSettings) {
            super(mapFactory, listFactory, allSettings);
        }

        @Override
        protected EditorSettingsNode<?> buildInternally(List<IEditorSettingNode<?>> builtSettingData, Map<ObjectCategorySetting<?>, IEditorSettingNode<?>> builtSettingsDataMap) {
            EditorSettingsNode result = new EditorSettingsNode(builtSettingsDataMap, builtSettingData, this.deleteButtonBuilder.build(), this.protectionButtonBuilder.build(), this.nameOptionBuilder.build(), this.listFactory, this.rootSettings, this.movable, this.listEntryFactory, this.tooltipSupplier, this.protection);
            return result;
        }
    }

    public static abstract class Builder<SD extends EditorSettingsNode<?>, SDB extends Builder<SD, SDB>>
    extends EditorNode.Builder<Builder<SD, SDB>> {
        protected final SDB self = this;
        protected final Map<ObjectCategorySetting<?>, IEditorSettingNodeBuilder<?, ?>> settingMap;
        protected final List<IEditorSettingNodeBuilder<?, ?>> settingList;
        protected final EditorSimpleButtonNode.Builder deleteButtonBuilder;
        protected final EditorSimpleButtonNode.Builder protectionButtonBuilder;
        protected final EditorTextFieldOptionsNode.Builder nameOptionBuilder;
        protected final MapFactory mapFactory;
        protected final ListFactory listFactory;
        protected boolean rootSettings;
        protected boolean protection;

        protected Builder(MapFactory mapFactory, ListFactory listFactory, List<ObjectCategorySetting<?>> allSettings) {
            this.settingMap = mapFactory.get();
            this.settingList = listFactory.get();
            this.deleteButtonBuilder = EditorSimpleButtonNode.Builder.begin();
            this.protectionButtonBuilder = EditorSimpleButtonNode.Builder.begin();
            this.nameOptionBuilder = EditorTextFieldOptionsNode.Builder.begin(listFactory);
            this.mapFactory = mapFactory;
            this.listFactory = listFactory;
            for (ObjectCategorySetting<?> setting : allSettings) {
                this.addSetting(setting);
            }
        }

        private <V> void addSetting(ObjectCategorySetting<V> setting) {
            IEditorSettingNodeBuilder builder = setting.getSettingUIType().getSettingNodeBuilderFactory().apply(this.listFactory).setSetting(setting);
            this.settingMap.put(setting, builder);
            this.settingList.add(builder);
        }

        @Override
        public SDB setDefault() {
            super.setDefault();
            for (IEditorSettingNodeBuilder<?, ?> builder : this.settingList) {
                builder.setSettingValue(null);
            }
            this.setRootSettings(false);
            this.nameOptionBuilder.setDefault();
            this.deleteButtonBuilder.setDefault().setDisplayName(I18n.m_118938_((String)"gui.xaero_category_delete", (Object[])new Object[0])).setCallback((parent, bd, rl) -> {
                EditorSettingsNode settings = (EditorSettingsNode)parent;
                Minecraft mc = Minecraft.m_91087_();
                Screen configScreen = mc.f_91080_;
                MutableComponent confirmSecondLine = Component.m_237115_((String)settings.getNameOption().getResult()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)));
                mc.m_91152_((Screen)new ConfirmScreen(result -> {
                    if (result) {
                        settings.setToBeDeleted();
                    }
                    mc.m_91152_(configScreen);
                }, (Component)Component.m_237115_((String)"gui.xaero_category_delete_confirm"), (Component)confirmSecondLine));
            }).setIsActiveSupplier((parent, data) -> !((EditorSettingsNode)parent).getProtection());
            this.protectionButtonBuilder.setDefault().setDisplayName("").setCallback((parent, bd, rl) -> {
                EditorSettingsNode settings = (EditorSettingsNode)parent;
                boolean currentlyProtected = settings.getProtection();
                Minecraft mc = Minecraft.m_91087_();
                Screen configScreen = mc.f_91080_;
                MutableComponent confirmFirstLine = Component.m_237115_((String)(currentlyProtected ? "gui.xaero_category_disable_protection_confirm" : "gui.xaero_category_enable_protection_confirm"));
                ChatFormatting confirmSecondLineColor = currentlyProtected ? ChatFormatting.RED : ChatFormatting.GREEN;
                MutableComponent confirmSecondLine = Component.m_237115_((String)settings.getNameOption().getResult()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)confirmSecondLineColor)));
                mc.m_91152_((Screen)new ConfirmScreen(result -> {
                    if (result) {
                        settings.setProtected(!settings.getProtection());
                    }
                    mc.m_91152_(configScreen);
                }, (Component)confirmFirstLine, (Component)confirmSecondLine));
            }).setMessageSupplier((parent, bd) -> () -> I18n.m_118938_((String)(((EditorSettingsNode)parent).getProtection() ? "gui.xaero_category_disable_protection" : "gui.xaero_category_enable_protection"), (Object[])new Object[0])).setIsActiveSupplier((parent, bd) -> !((EditorSettingsNode)parent).isRootSettings()).setTooltipSupplier((parent, bd) -> new CursorBox((Component)Component.m_237115_((String)"gui.xaero_box_category_protection")));
            this.setTooltipSupplier((parent, data) -> {
                if (!(parent instanceof EditorCategoryNode)) {
                    return null;
                }
                EditorCategoryNode category = (EditorCategoryNode)parent;
                MutableComponent displayNameComponent = Component.m_237115_((String)category.getDisplayName());
                CursorBox tooltip = new CursorBox((Component)Component.m_237110_((String)"gui.xaero_box_category_settings", (Object[])new Object[]{displayNameComponent}));
                tooltip.setAutoLinebreak(false);
                return tooltip;
            });
            return this.self;
        }

        @Override
        protected EditorListRootEntry.CenteredEntryFactory getCenteredEntryFactory(EditorNode data, EditorNode parent, int index, GuiCategoryEditor.SettingRowList rowList) {
            return (x, y, width, height, root) -> {
                EditorButton button = new EditorButton(parent, true, 216, 20, data, rowList);
                return new EditorListEntryWidget(x, y, width, height, index, rowList, root, (AbstractWidget)button, data.getTooltipSupplier(parent));
            };
        }

        public <T> SDB setSettingValue(ObjectCategorySetting<T> setting, T value) {
            IEditorSettingNodeBuilder<?, ?> settingBuilder = this.settingMap.get(setting);
            settingBuilder.setSettingValue(value);
            return this.self;
        }

        public SDB setRootSettings(boolean rootSettings) {
            this.rootSettings = rootSettings;
            return this.self;
        }

        public SDB setProtection(boolean protection) {
            this.protection = protection;
            return this.self;
        }

        public EditorTextFieldOptionsNode.Builder getNameOptionBuilder() {
            return this.nameOptionBuilder;
        }

        public EditorSimpleButtonNode.Builder getDeleteButtonBuilder() {
            return this.deleteButtonBuilder;
        }

        @Override
        protected EditorNode buildInternally() {
            if (this.nameOptionBuilder.needsInputStringValidator()) {
                this.nameOptionBuilder.setInputStringValidator(s -> true);
            }
            List builtSettingData = this.settingList.stream().map(b -> b.setRootSettings(this.rootSettings)).map(IEditorSettingNodeBuilder::build).collect(this.listFactory::get, List::add, List::addAll);
            Map<ObjectCategorySetting<?>, IEditorSettingNode<?>> builtSettingsDataMap = this.mapFactory.get();
            for (IEditorSettingNode sd : builtSettingData) {
                if (!(sd instanceof EditorOptionsNode)) {
                    throw new IllegalStateException("illegal setting data class! " + sd.getClass());
                }
                builtSettingsDataMap.put(sd.getSetting(), sd);
            }
            return this.buildInternally(builtSettingData, builtSettingsDataMap);
        }

        protected abstract SD buildInternally(List<IEditorSettingNode<?>> var1, Map<ObjectCategorySetting<?>, IEditorSettingNode<?>> var2);
    }
}

