/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.concurrent.atomic.AtomicInteger;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.event.IEventHelper;
import net.darkhax.bookshelf.api.event.block.IFarmlandTrampleListener;
import net.darkhax.bookshelf.api.event.client.IRecipeSyncEvent;
import net.darkhax.bookshelf.api.event.entity.IItemUseTickEvent;
import net.darkhax.bookshelf.api.event.entity.player.IPlayerWakeUpEvent;
import net.darkhax.bookshelf.api.event.item.IItemAttributeEvent;
import net.darkhax.bookshelf.api.event.item.IItemTooltipEvent;
import net.darkhax.bookshelf.impl.event.ForgeItemAttributeEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class EventHelperForge
implements IEventHelper {
    private static final Multimap<EventPriority, IItemAttributeEvent.Listener> ITEM_ATTRIBUTE_LISTENERS = HashMultimap.create();
    private static final Multimap<EventPriority, IItemUseTickEvent> ITEM_USE_TICK_LISTENERS = HashMultimap.create();

    @Override
    public void addItemTooltipListener(IItemTooltipEvent listener, IEventHelper.Ordering ordering) {
        if (Services.PLATFORM.isPhysicalClient()) {
            MinecraftForge.EVENT_BUS.addListener(EventHelperForge.priority(ordering), false, ItemTooltipEvent.class, e -> listener.apply(e.getItemStack(), e.getToolTip(), e.getFlags()));
        }
    }

    @Override
    public void addPlayerWakeUpListener(IPlayerWakeUpEvent listener, IEventHelper.Ordering ordering) {
        MinecraftForge.EVENT_BUS.addListener(EventHelperForge.priority(ordering), false, PlayerWakeUpEvent.class, e -> listener.apply(e.getEntity()));
    }

    @Override
    public void addRecipeSyncListener(IRecipeSyncEvent listener, IEventHelper.Ordering ordering) {
        if (Services.PLATFORM.isPhysicalClient()) {
            MinecraftForge.EVENT_BUS.addListener(EventHelperForge.priority(ordering), false, RecipesUpdatedEvent.class, e -> listener.apply(e.getRecipeManager()));
        }
    }

    @Override
    public void addFarmlandTrampleListener(IFarmlandTrampleListener listener, IEventHelper.Ordering ordering) {
        EventPriority priority = EventHelperForge.priority(ordering);
        MinecraftForge.EVENT_BUS.addListener(priority, false, BlockEvent.FarmlandTrampleEvent.class, e -> {
            if (listener.apply(e.getEntity(), e.getPos(), e.getState())) {
                e.setCanceled(true);
            }
        });
    }

    @Override
    public void addItemAttributeListener(IItemAttributeEvent.Listener listener, IEventHelper.Ordering ordering) {
        EventPriority priority = EventHelperForge.priority(ordering);
        if (!ITEM_ATTRIBUTE_LISTENERS.containsKey((Object)priority)) {
            MinecraftForge.EVENT_BUS.addListener(priority, false, ItemAttributeModifierEvent.class, e -> {
                ForgeItemAttributeEvent wrapper = new ForgeItemAttributeEvent((ItemAttributeModifierEvent)e);
                ITEM_ATTRIBUTE_LISTENERS.get((Object)priority).forEach(entry -> entry.accept(wrapper));
            });
        }
        ITEM_ATTRIBUTE_LISTENERS.put((Object)priority, (Object)listener);
    }

    @Override
    public void addItemUseTickListener(IItemUseTickEvent listener, IEventHelper.Ordering ordering) {
        EventPriority priority = EventHelperForge.priority(ordering);
        if (!ITEM_USE_TICK_LISTENERS.containsKey((Object)priority)) {
            MinecraftForge.EVENT_BUS.addListener(EventHelperForge.priority(ordering), false, LivingEntityUseItemEvent.Tick.class, e -> {
                AtomicInteger duration = new AtomicInteger(e.getDuration());
                ITEM_USE_TICK_LISTENERS.get((Object)priority).forEach(entry -> entry.onUseTick(e.getEntity(), e.getItem(), duration));
                e.setDuration(duration.get());
            });
        }
        ITEM_USE_TICK_LISTENERS.put((Object)priority, (Object)listener);
    }

    private static EventPriority priority(IEventHelper.Ordering ordering) {
        return switch (ordering) {
            case IEventHelper.Ordering.BEFORE -> EventPriority.HIGH;
            case IEventHelper.Ordering.DEFAULT -> EventPriority.NORMAL;
            case IEventHelper.Ordering.AFTER -> EventPriority.LOW;
            default -> EventPriority.NORMAL;
        };
    }
}

