/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.systems;

import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.tags.ModBlockTags;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;

public class EnvironmentEffects {
    public static void tickChunk(ServerLevel level, LevelChunk chunk) {
        LevelChunkSection[] chunkSections = chunk.m_7103_();
        ChunkPos chunkPos = chunk.m_7697_();
        int chunkX = chunkPos.m_45604_();
        int chunkZ = chunkPos.m_45605_();
        for (int i = 0; i < chunkSections.length; ++i) {
            LevelChunkSection section = chunkSections[i];
            if (!section.m_63014_() && !AdAstraConfig.forcePlanetTick) continue;
            int yCord = SectionPos.m_123223_((int)chunk.m_151568_(i));
            for (int j = 0; j < AdAstraConfig.planetRandomTickSpeed; ++j) {
                short temperature;
                BlockPos pos = level.m_46496_(chunkX, yCord, chunkZ, 15);
                BlockState state = section.m_62982_(pos.m_123341_() - chunkX, pos.m_123342_() - yCord, pos.m_123343_() - chunkZ);
                if (state.m_60795_() || !AdAstraEvents.EnvironmentTickEvent.fire(level, pos, state, temperature = TemperatureApi.API.getTemperature((Level)level, pos))) continue;
                if (temperature > 70) {
                    EnvironmentEffects.tickHot(level, pos, state);
                    continue;
                }
                if (temperature < -20) {
                    EnvironmentEffects.tickCold(level, pos, state);
                    continue;
                }
                if (OxygenApi.API.hasOxygen((Level)level, pos)) continue;
                EnvironmentEffects.tickBlock(level, pos, state);
            }
        }
    }

    private static void tickBlock(ServerLevel level, BlockPos pos, BlockState state) {
        if (state.m_204336_(ModBlockTags.DESTROYED_IN_SPACE) && !EnvironmentEffects.hasOxygenOnAnySide(level, pos)) {
            level.m_46961_(pos, true);
        } else if (state.m_60734_() instanceof GrassBlock && !EnvironmentEffects.hasOxygenOnAnySide(level, pos)) {
            level.m_46597_(pos, Blocks.f_50493_.m_49966_());
        } else if (state.m_60734_() instanceof FarmBlock && !EnvironmentEffects.hasOxygenOnAnySide(level, pos)) {
            level.m_46597_(pos, Blocks.f_50493_.m_49966_());
        } else if (state.m_60734_() instanceof CampfireBlock) {
            level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CampfireBlock.f_51230_, (Comparable)((Direction)state.m_61143_((Property)CampfireBlock.f_51230_))));
        } else if (state.m_60734_() instanceof CandleBlock) {
            level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)CandleBlock.f_152790_, (Comparable)((Integer)state.m_61143_((Property)CandleBlock.f_152790_)))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false)));
        } else if (state.m_60734_() instanceof CandleCakeBlock) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)CandleCakeBlock.f_152850_, (Comparable)Boolean.valueOf(false)));
        }
    }

    private static void tickCold(ServerLevel level, BlockPos pos, BlockState state) {
        FluidState fluidState = state.m_60819_();
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        } else if (fluidState.m_76170_() && fluidState.m_205070_(ModFluidTags.FREEZES_IN_SPACE)) {
            level.m_46597_(pos, Blocks.f_50126_.m_49966_());
        }
    }

    private static void tickHot(ServerLevel level, BlockPos pos, BlockState state) {
        FluidState fluidState = state.m_60819_();
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        } else if (fluidState.m_76170_() && fluidState.m_205070_(ModFluidTags.EVAPORATES_IN_SPACE)) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            ModUtils.sendParticles(level, ParticleTypes.f_123755_, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 8, 0.5, 0.5, 0.5, 0.0);
        }
    }

    private static boolean hasOxygenOnAnySide(ServerLevel level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!OxygenApi.API.hasOxygen((Level)level, pos.m_121945_(direction))) continue;
            return true;
        }
        return false;
    }
}

