/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.vehicles;

import earth.terrarium.adastra.common.entities.multipart.MultipartPartEntity;
import earth.terrarium.adastra.common.entities.vehicles.Vehicle;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

public class VehiclePart
extends Entity
implements MultipartPartEntity<Vehicle> {
    private final Vehicle vehicle;
    private final EntityDimensions size;
    private final Vector3f offset;
    private final BiFunction<Player, InteractionHand, InteractionResult> interactionHandler;

    public VehiclePart(Vehicle vehicle, float width, float height, Vector3f offset, BiFunction<Player, InteractionHand, InteractionResult> interactionHandler) {
        super(vehicle.m_6095_(), vehicle.m_9236_());
        this.vehicle = vehicle;
        this.interactionHandler = interactionHandler;
        this.offset = offset;
        this.size = EntityDimensions.m_20395_((float)width, (float)height);
        this.m_6210_();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.vehicle.m_142340_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.vehicle.m_6469_(source, amount);
    }

    public boolean m_7306_(Entity entity) {
        return entity == this || this.vehicle == entity;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        return this.size;
    }

    public boolean m_142391_() {
        return false;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return this.interactionHandler.apply(player, hand);
    }

    public void tickPart() {
        this.m_146867_();
        Matrix3f rotationMatrix = new Matrix3f();
        rotationMatrix.rotateY(this.vehicle.m_146908_() * ((float)Math.PI / 180));
        Vector3f offset = this.offset.mulTranspose((Matrix3fc)rotationMatrix, new Vector3f());
        this.m_6034_(this.vehicle.m_20185_() + (double)offset.x(), this.vehicle.m_20186_() + (double)offset.y(), this.vehicle.m_20189_() + (double)offset.z());
    }

    @Override
    public Vehicle getParent() {
        return this.vehicle;
    }
}

