/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks.machines;

import earth.terrarium.adastra.common.blocks.base.MachineBlock;
import earth.terrarium.adastra.common.blocks.base.Wrenchable;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DetectorBlock
extends MachineBlock
implements Wrenchable {
    public static final BooleanProperty INVERTED = BooleanProperty.m_61465_((String)"inverted");
    public static final EnumProperty<DetectionType> DETECTION_TYPE = EnumProperty.m_61587_((String)"detection_type", DetectionType.class);

    public DetectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false))).m_61124_(DETECTION_TYPE, (Comparable)((Object)DetectionType.OXYGEN)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{INVERTED, DETECTION_TYPE});
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    @Override
    public void onWrench(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        if (level.m_5776_()) {
            return;
        }
        if (user.m_6144_()) {
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)INVERTED));
            user.m_5661_((Boolean)state.m_61143_((Property)INVERTED) == false ? ConstantComponents.DETECTOR_INVERTED_TRUE : ConstantComponents.DETECTOR_INVERTED_FALSE, true);
        } else {
            BlockState newState = (BlockState)state.m_61122_(DETECTION_TYPE);
            level.m_46597_(pos, newState);
            DetectionType newType = (DetectionType)((Object)newState.m_61143_(DETECTION_TYPE));
            user.m_5661_(switch (newType) {
                default -> throw new IncompatibleClassChangeError();
                case DetectionType.OXYGEN -> ConstantComponents.DETECTOR_OXYGEN_MODE;
                case DetectionType.GRAVITY -> ConstantComponents.DETECTOR_GRAVITY_MODE;
                case DetectionType.TEMPERATURE -> ConstantComponents.DETECTOR_TEMPERATURE_MODE;
            }, true);
        }
        level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.WRENCH.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.9f);
    }

    public static enum DetectionType implements StringRepresentable
    {
        OXYGEN,
        GRAVITY,
        TEMPERATURE;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

