/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.blockentities.base.MachineBlockEntity;
import earth.terrarium.adastra.common.blocks.machines.DetectorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DetectorBlockEntity
extends MachineBlockEntity {
    public DetectorBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        boolean power;
        if (time % 40L != 0L) {
            return;
        }
        boolean inverted = (Boolean)state.m_61143_((Property)DetectorBlock.INVERTED);
        switch ((DetectorBlock.DetectionType)((Object)state.m_61143_(DetectorBlock.DETECTION_TYPE))) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OXYGEN: {
                boolean bl = this.hasOxygen(level, pos, inverted);
                break;
            }
            case GRAVITY: {
                boolean bl = this.hasNormalGravity(level, pos, inverted);
                break;
            }
            case TEMPERATURE: {
                boolean bl = power = this.hasSafeTemperature(level, pos, inverted);
            }
        }
        if (power != (Boolean)state.m_61143_((Property)DetectorBlock.POWERED)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)DetectorBlock.POWERED, (Comparable)Boolean.valueOf(power)));
        }
    }

    public boolean hasOxygen(ServerLevel level, BlockPos pos, boolean inverted) {
        for (Direction direction : Direction.values()) {
            if (!OxygenApi.API.hasOxygen((Level)level, pos.m_121945_(direction))) continue;
            return !inverted;
        }
        return inverted;
    }

    public boolean hasNormalGravity(ServerLevel level, BlockPos pos, boolean inverted) {
        for (Direction direction : Direction.values()) {
            float gravity = GravityApi.API.getGravity((Level)level, pos.m_121945_(direction)) * 9.807f;
            if (!(gravity > 8.807f) || !(gravity < 10.807f)) continue;
            return !inverted;
        }
        return inverted;
    }

    public boolean hasSafeTemperature(ServerLevel level, BlockPos pos, boolean inverted) {
        for (Direction direction : Direction.values()) {
            if (!TemperatureApi.API.isLiveable((Level)level, pos.m_121945_(direction))) continue;
            return !inverted;
        }
        return inverted;
    }
}

