/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.screens.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.adastra.api.systems.PlanetData;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.utils.ClientData;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.entities.vehicles.Lander;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.items.armor.JetSuitItem;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class OverlayScreen {
    public static final ResourceLocation BATTERY_EMPTY = new ResourceLocation("ad_astra", "textures/gui/sprites/overlay/battery_empty.png");
    public static final ResourceLocation BATTERY = new ResourceLocation("ad_astra", "textures/gui/sprites/overlay/battery.png");
    public static final ResourceLocation OXYGEN_TANK_EMPTY = new ResourceLocation("ad_astra", "textures/gui/sprites/overlay/oxygen_tank_empty.png");
    public static final ResourceLocation OXYGEN_TANK = new ResourceLocation("ad_astra", "textures/gui/sprites/overlay/oxygen_tank.png");
    public static final ResourceLocation ROCKET_BAR = new ResourceLocation("ad_astra", "textures/gui/sprites/overlay/rocket_bar.png");
    public static final ResourceLocation ROCKET = new ResourceLocation("ad_astra", "textures/gui/sprites/overlay/rocket.png");

    public static void render(GuiGraphics graphics, float partialTick) {
        Lander lander;
        Entity amount3;
        Item amount22;
        int color;
        int textWidth;
        String text;
        float scale;
        int y;
        int x;
        double ratio;
        long capacity;
        Item y22;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        Level level = player.m_9236_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91066_.f_92063_) {
            return;
        }
        Font font = minecraft.f_91062_;
        int width = minecraft.m_91268_().m_85445_();
        int height = minecraft.m_91268_().m_85446_();
        PoseStack poseStack = graphics.m_280168_();
        Entity entity = player.m_20202_();
        if (entity instanceof Rocket) {
            Rocket rocket = (Rocket)entity;
            int countdown = Mth.m_14167_((float)((float)rocket.launchTicks() / 20.0f));
            if (rocket.isLaunching()) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)width / 2.0f, (float)height / 2.0f, 0.0f);
                poseStack.m_85841_(4.0f, 4.0f, 4.0f);
                graphics.m_280137_(font, String.valueOf(countdown), 0, -10, 15020627);
                poseStack.m_85849_();
            }
            graphics.m_280163_(ROCKET_BAR, 0, height / 2, 0.0f, 0.0f, 16, 128, 16, 128);
            poseStack.m_85836_();
            double y22 = Mth.m_14008_((double)rocket.m_20186_(), (double)100.0, (double)AdAstraConfig.atmosphereLeave);
            poseStack.m_85837_((double)0.3f, ((double)AdAstraConfig.atmosphereLeave - y22 - 500.0) / 4.5, 0.0);
            graphics.m_280163_(ROCKET, 3, height / 2 + 113, 0.0f, 0.0f, 8, 11, 8, 11);
            poseStack.m_85849_();
        }
        ItemStack chestStack = player.m_150109_().m_36052_(2);
        if (SpaceSuitItem.hasFullSet((LivingEntity)player) && (y22 = chestStack.m_41720_()) instanceof SpaceSuitItem) {
            SpaceSuitItem spaceSuit = (SpaceSuitItem)y22;
            long amount22 = SpaceSuitItem.getOxygenAmount((Entity)player);
            capacity = spaceSuit.getFluidContainer(chestStack).getTankCapacity(0);
            ratio = (double)amount22 / (double)capacity;
            int barHeight = (int)(ratio * 52.0);
            x = AdAstraConfigClient.oxygenBarX;
            y = AdAstraConfigClient.oxygenBarY;
            scale = AdAstraConfigClient.oxygenBarScale;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            graphics.m_280163_(OXYGEN_TANK_EMPTY, x, y, 0.0f, 0.0f, 62, 52, 62, 52);
            graphics.m_280163_(OXYGEN_TANK, x, y + 52 - barHeight, 0.0f, (float)(52 - barHeight), 62, barHeight, 62, 52);
            text = String.format("%.1f%%", ratio * 100.0);
            textWidth = font.m_92895_(text);
            color = ratio <= 0.0 ? 14423100 : 0xFFFFFF;
            PlanetData localData = ClientData.getLocalData();
            if (localData != null && localData.oxygen()) {
                color = 0x55FF55;
            }
            graphics.m_280488_(font, text, (int)((float)x + (float)(62 - textWidth) / 2.0f), y + 52 + 3, color);
            poseStack.m_85849_();
        }
        if (JetSuitItem.hasFullSet((LivingEntity)player) && (amount22 = chestStack.m_41720_()) instanceof JetSuitItem) {
            JetSuitItem jetSuit = (JetSuitItem)amount22;
            long amount3 = jetSuit.getEnergyStorage(chestStack).getStoredEnergy();
            capacity = jetSuit.getEnergyStorage(chestStack).getMaxCapacity();
            ratio = (double)amount3 / (double)capacity;
            int barWidth = (int)(ratio * 49.0);
            x = AdAstraConfigClient.energyBarX;
            y = AdAstraConfigClient.energyBarY;
            scale = AdAstraConfigClient.energyBarScale;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            graphics.m_280163_(BATTERY_EMPTY, x, y, 0.0f, 0.0f, 49, 27, 49, 27);
            graphics.m_280163_(BATTERY, x, y, 0.0f, 27.0f, barWidth, 27, 49, 27);
            text = String.format("%.1f%%", ratio * 100.0);
            textWidth = font.m_92895_(text);
            color = ratio <= 0.0 ? 14423100 : 0x55FFFF;
            graphics.m_280488_(font, text, (int)((float)x + (float)(49 - textWidth) / 2.0f), y + 27 + 3, color);
            poseStack.m_85849_();
        }
        if ((amount3 = player.m_20202_()) instanceof Lander && level.m_8055_((lander = (Lander)amount3).m_20097_().m_6625_(2)).m_60795_()) {
            int ground = level.m_5452_(Heightmap.Types.WORLD_SURFACE, lander.m_20183_()).m_123342_();
            int distance = Math.max(0, lander.m_20183_().m_123342_() - ground);
            poseStack.m_85836_();
            poseStack.m_252880_((float)width / 2.0f, (float)height / 2.0f, 0.0f);
            poseStack.m_85841_(1.4f, 1.4f, 1.4f);
            float alpha = Mth.m_14036_((float)(0.1f - (float)(lander.m_20184_().m_7098_() + 0.5)), (float)0.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            graphics.m_280653_(font, (Component)Component.m_237110_((String)"message.ad_astra.lander.onboard", (Object[])new Object[]{minecraft.f_91066_.f_92089_.m_90863_().getString().toUpperCase(Locale.ROOT)}), 0, 60, 15020627);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int distanceColor = 0x55FF55;
            if (distance < 100) {
                distanceColor = 0xFF5555;
            } else if (distance < 300) {
                distanceColor = 0xFFFF55;
            }
            graphics.m_280137_(font, String.valueOf(distance), 0, 30, distanceColor);
            poseStack.m_85849_();
        }
    }
}

