/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.components.machines;

import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.client.components.PressableImageButton;
import earth.terrarium.adastra.client.components.base.ContainerWidget;
import earth.terrarium.adastra.client.components.machines.ConfigurationButton;
import earth.terrarium.adastra.client.utils.GuiUtils;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.base.BaseContainerMenu;
import earth.terrarium.adastra.common.menus.slots.InventorySlot;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundResetSideConfigPacket;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;

public class SidedConfigWidget
extends ContainerWidget {
    private final BaseContainerMenu<? extends ContainerMachineBlockEntity> menu;
    private final ContainerMachineBlockEntity entity;
    private int index;

    public SidedConfigWidget(int x, int y, int width, int height, BaseContainerMenu<? extends ContainerMachineBlockEntity> menu) {
        super(x, y, width, height);
        this.menu = menu;
        this.entity = menu.getEntity();
        this.init();
        this.setActive(false);
    }

    public void init() {
        this.renderables.clear();
        this.children.clear();
        if (this.index >= this.entity.getSideConfig().size()) {
            this.index = 0;
        } else if (this.index < 0) {
            this.index = this.entity.getSideConfig().size() - 1;
        } else if (this.entity.getSideConfig().isEmpty()) {
            return;
        }
        SideConfigButtons buttons = this.createSideButtons(this.index);
        this.addRenderableWidget(new PressableImageButton(this.m_252754_(), this.m_252907_(), 18, 18, 0, 0, 18, GuiUtils.RESET_BUTTON, 18, 54, button -> {
            this.entity.resetToDefault(this.index);
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundResetSideConfigPacket(this.entity.m_58899_(), this.index));
            this.init();
        })).m_257544_(Tooltip.m_257550_((Component)ConstantComponents.RESET_TO_DEFAULT));
        buttons.center(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
    }

    private SideConfigButtons createSideButtons(int i) {
        GridLayout layout = new GridLayout().m_267612_(3);
        ConfigurationEntry entry = this.entity.getSideConfig().get(i);
        for (Map.Entry<Direction, Configuration> side : entry.sides().entrySet()) {
            ConfigurationButton button = new ConfigurationButton(this.entity, i, entry, side.getKey(), side.getValue());
            button.f_93624_ = this.index == i;
            switch (side.getKey()) {
                case UP: {
                    layout.m_264379_((LayoutElement)button, 0, 1);
                    break;
                }
                case DOWN: {
                    layout.m_264379_((LayoutElement)button, 2, 1);
                    break;
                }
                case NORTH: {
                    layout.m_264379_((LayoutElement)button, 1, 1);
                    break;
                }
                case SOUTH: {
                    layout.m_264379_((LayoutElement)button, 2, 0);
                    break;
                }
                case EAST: {
                    layout.m_264379_((LayoutElement)button, 1, 0);
                    break;
                }
                case WEST: {
                    layout.m_264379_((LayoutElement)button, 1, 2);
                }
            }
        }
        layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(x$0);
        });
        return new SideConfigButtons(layout);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.menu.f_38839_.stream().filter(slot -> slot instanceof InventorySlot).forEach(slot -> ((InventorySlot)((Object)slot)).setActive(!active));
    }

    public void toggle() {
        this.setActive(!this.m_142518_());
    }

    public void setIndex(int index) {
        this.index = index;
        this.init();
    }

    public int getIndex() {
        return this.index;
    }

    public Component getMessage() {
        return Component.m_237110_((String)"side_config.ad_astra.title", (Object[])new Object[]{this.entity.getSideConfig().get(this.index).title()});
    }

    private record SideConfigButtons(GridLayout layout) {
        public void center(int x, int y, int width, int height) {
            this.layout.m_264036_();
            this.layout.m_264152_(x + (width - this.layout.m_5711_()) / 2, y + (height - this.layout.m_93694_()) / 2);
        }
    }
}

